/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.core.model.AbstractScriptBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugModel;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class BreakpointUtils {
    public static String getNatureId(IScriptBreakpoint breakpoint) {
        ScriptDebugManager manager = ScriptDebugManager.getInstance();
        return manager.getNatureByDebugModel(breakpoint.getModelIdentifier());
    }

    public static IDLTKLanguageToolkit getLanguageToolkit(IScriptBreakpoint breakpoint) {
        return DLTKLanguageManager.getLanguageToolkit((String)BreakpointUtils.getNatureId(breakpoint));
    }

    public static IDLTKUILanguageToolkit getUILanguageToolkit(IScriptBreakpoint breakpoint) {
        return DLTKUILanguageManager.getLanguageToolkit((String)BreakpointUtils.getNatureId(breakpoint));
    }

    public static void addLineBreakpoint(ITextEditor textEditor, int lineNumber) throws CoreException {
        BreakpointUtils.addLineBreakpoint(textEditor, lineNumber, null);
    }

    public static void addLineBreakpoint(ITextEditor textEditor, int lineNumber, String debugModelId) throws CoreException {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IResource resource = BreakpointUtils.getBreakpointResource(textEditor);
        try {
            IRegion line = document.getLineInformation(lineNumber - 1);
            int start = line.getOffset();
            int end = start + line.getLength();
            if (debugModelId == null && (debugModelId = BreakpointUtils.getDebugModelId(textEditor, resource)) == null) {
                return;
            }
            IPath location = BreakpointUtils.getBreakpointResourceLocation(textEditor);
            ScriptDebugModel.createLineBreakpoint((String)debugModelId, (IResource)resource, (IPath)location, (int)lineNumber, (int)start, (int)end, (boolean)true, null);
        }
        catch (BadLocationException e) {
            DLTKDebugPlugin.log((Throwable)e);
        }
    }

    public static void addSpawnpoint(ITextEditor textEditor, int lineNumber) throws CoreException {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IResource resource = BreakpointUtils.getBreakpointResource(textEditor);
        try {
            IRegion line = document.getLineInformation(lineNumber - 1);
            int start = line.getOffset();
            int end = start + line.getLength();
            String debugModelId = BreakpointUtils.getDebugModelId(textEditor, resource);
            if (debugModelId == null) {
                return;
            }
            IPath location = BreakpointUtils.getBreakpointResourceLocation(textEditor);
            ScriptDebugModel.createSpawnpoint((String)debugModelId, (IResource)resource, (IPath)location, (int)lineNumber, (int)start, (int)end, (boolean)true, null);
        }
        catch (BadLocationException e) {
            DLTKDebugPlugin.log((Throwable)e);
        }
    }

    public static IResource getBreakpointResource(ITextEditor textEditor) {
        return BreakpointUtils.getBreakpointResource(textEditor.getEditorInput());
    }

    public static IResource getBreakpointResource(IEditorInput editorInput) {
        IResource resource = (IResource)editorInput.getAdapter(IResource.class);
        if (resource == null) {
            resource = BreakpointUtils.getWorkspaceRoot();
        }
        return resource;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IBreakpointLocationTester getBreakpointLocationTester(IEditorInput editorInput) throws CoreException {
        IResource resource = (IResource)editorInput.getAdapter(IResource.class);
        if (resource != null && !resource.equals((Object)BreakpointUtils.getWorkspaceRoot())) {
            return new ResourceBreakpointLocationTester(resource);
        }
        IModelElement element = (IModelElement)editorInput.getAdapter(IModelElement.class);
        if (element != null) {
            return new SimpleBreakpointLocationTester(element.getPath());
        }
        return null;
    }

    public static IPath getBreakpointResourceLocation(ITextEditor textEditor) throws CoreException {
        IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            return resource.getFullPath();
        }
        IModelElement element = (IModelElement)textEditor.getEditorInput().getAdapter(IModelElement.class);
        if (element != null) {
            return element.getPath();
        }
        return null;
    }

    private static String getDebugModelId(ITextEditor textEditor, IResource resource) throws CoreException {
        IDLTKLanguageToolkit toolkit;
        String debugModelId = ScriptDebugModel.getDebugModelId((IResource)resource);
        if (debugModelId != null) {
            return debugModelId;
        }
        IModelElement element = (IModelElement)textEditor.getEditorInput().getAdapter(IModelElement.class);
        if (element != null && (toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element)) != null) {
            return ScriptDebugManager.getInstance().getDebugModelByNature(toolkit.getNatureId());
        }
        return null;
    }

    public static ILineBreakpoint findLineBreakpoint(ITextEditor editor, int lineNumber) throws CoreException {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = BreakpointUtils.getBreakpointResource(editorInput);
        String debugModelId = BreakpointUtils.getDebugModelId(editor, resource);
        return BreakpointUtils.findLineBreakpoint(editor, lineNumber, debugModelId);
    }

    public static ILineBreakpoint findLineBreakpoint(ITextEditor editor, int lineNumber, String debugModelId) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(debugModelId);
        IBreakpointLocationTester tester = BreakpointUtils.getBreakpointLocationTester(editor.getEditorInput());
        if (tester == null) {
            return null;
        }
        int i = 0;
        while (i < breakpoints.length) {
            try {
                ILineBreakpoint lineBreakpoint;
                if (tester.evaluate(breakpoints[i]) && (lineBreakpoint = (ILineBreakpoint)breakpoints[i]).getLineNumber() == lineNumber) {
                    return lineBreakpoint;
                }
            }
            catch (CoreException e) {
                DLTKDebugUIPlugin.log(e);
            }
            ++i;
        }
        return null;
    }

    public static void addMethodEntryBreakpoint(ITextEditor textEditor, int lineNumber, String methodName) throws CoreException {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            try {
                IRegion line = document.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                IPath path = resource.getLocation();
                IScriptMethodEntryBreakpoint methodEntryBreakpoint = ScriptDebugModel.createMethodEntryBreakpoint((IResource)resource, (IPath)path, (int)lineNumber, (int)start, (int)end, (boolean)false, null, (String)methodName);
                methodEntryBreakpoint.setBreakOnEntry(true);
                ((AbstractScriptBreakpoint)methodEntryBreakpoint).register(true);
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }

    public static void addWatchPoint(ITextEditor textEditor, int lineNumber, String fieldName) throws CoreException {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            try {
                IRegion line = document.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                IPath path = resource.getLocation();
                ScriptDebugModel.createWatchPoint((IResource)resource, (IPath)path, (int)lineNumber, (int)start, (int)end, (String)fieldName);
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }

    public static void addExceptionBreakpoint(String debugModelId, boolean caught, boolean uncaught, IType type) throws CoreException {
        IResource resource = type.getResource();
        if (resource == null || !resource.getProject().exists()) {
            resource = BreakpointUtils.getWorkspaceRoot();
        }
        if (resource != null) {
            ScriptDebugModel.createExceptionBreakpoint((String)debugModelId, (IResource)resource, (String)type.getTypeQualifiedName(), (boolean)caught, (boolean)uncaught, (boolean)true, null);
        }
    }

    public static interface IBreakpointLocationTester {
        public boolean evaluate(IBreakpoint var1) throws CoreException;
    }

    private static class ResourceBreakpointLocationTester
    implements IBreakpointLocationTester {
        private final IResource resource;

        public ResourceBreakpointLocationTester(IResource resource) {
            this.resource = resource;
        }

        public boolean evaluate(IBreakpoint breakpoint) {
            return this.resource.equals((Object)breakpoint.getMarker().getResource());
        }
    }

    private static class SimpleBreakpointLocationTester
    implements IBreakpointLocationTester {
        private final String path;

        public SimpleBreakpointLocationTester(IPath path) {
            this.path = path.toPortableString();
        }

        public boolean evaluate(IBreakpoint breakpoint) throws CoreException {
            IResource bpResource = breakpoint.getMarker().getResource();
            if (bpResource.equals((Object)BreakpointUtils.getWorkspaceRoot())) {
                String bpLocation = (String)breakpoint.getMarker().getAttribute("location");
                return this.path.equals(bpLocation);
            }
            return false;
        }
    }
}

