/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.actions.FindReferencesAction;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public class FindReferencesInWorkingSetAction
extends FindReferencesAction {
    private IWorkingSet[] fWorkingSets;

    public FindReferencesInWorkingSetAction(IDLTKLanguageToolkit toolkit, IWorkbenchSite site) {
        this(toolkit, site, null);
    }

    public FindReferencesInWorkingSetAction(IDLTKLanguageToolkit toolkit, IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(toolkit, site);
        this.fWorkingSets = workingSets;
    }

    public FindReferencesInWorkingSetAction(IDLTKLanguageToolkit toolkit, ScriptEditor editor) {
        this(toolkit, editor, null);
    }

    public FindReferencesInWorkingSetAction(IDLTKLanguageToolkit toolkit, ScriptEditor editor, IWorkingSet[] workingSets) {
        super(toolkit, editor);
        this.fWorkingSets = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindReferencesInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesInWorkingSetAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_REF);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help supprot here...");
        }
    }

    QuerySpecification createQuery(IModelElement element) throws ModelException {
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = factory.queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IDLTKSearchScope scope = factory.createSearchScope(workingSets, true, this.getLanguageToolkit());
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

