/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.base.scope.CriteriaHelpScope;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableSelectedToc;
import org.eclipse.help.internal.workingset.AdaptableSelectedTopic;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.WorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResults
implements ISearchHitCollector {
    private ArrayList<AdaptableHelpResource> scopes;
    private int maxHits;
    private String locale;
    private AbstractHelpScope filter;
    private CriteriaHelpScope criteriaScope;
    protected SearchHit[] searchHits = new SearchHit[0];
    private QueryTooComplexException searchException = null;
    private boolean isQuickSearch;

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale) {
        this(workingSets, maxHits, locale, false);
    }

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale, boolean isQuickSearch) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
        this.criteriaScope = new CriteriaHelpScope(this.getCriteriaScopes(workingSets));
        this.isQuickSearch = isQuickSearch;
    }

    public void setFilter(AbstractHelpScope filter) {
        this.filter = filter;
    }

    @Override
    public void addHits(List<SearchHit> hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode((String)highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        Iterator<SearchHit> iter = hits.iterator();
        int filteredHits = 0;
        while (filteredHits < this.maxHits && iter.hasNext()) {
            ITopic t;
            SearchHit rawHit = iter.next();
            String href = rawHit.getHref();
            IToc toc = null;
            AdaptableHelpResource scope = null;
            if (this.scopes == null) {
                toc = this.getTocForTopic(href, this.locale);
                if (toc == null && !rawHit.canOpen()) {
                    continue;
                }
            } else {
                scope = this.getScopeForTopic(href);
                if (scope == null) continue;
                if (scope instanceof AdaptableToc || scope instanceof AdaptableSelectedToc) {
                    toc = (IToc)scope.getAdapter(IToc.class);
                } else if (scope instanceof AdaptableTopic || scope instanceof AdaptableSelectedTopic) {
                    toc = (IToc)scope.getParent().getAdapter(IToc.class);
                }
            }
            float score = rawHit.getScore();
            if (!scoreScaleSet) {
                if (score > 0.0f) {
                    scoreScale = 0.99f / score;
                    score = 1.0f;
                }
                scoreScaleSet = true;
            } else {
                score = score * scoreScale + 0.01f;
            }
            String label = rawHit.getLabel();
            if ("".equals(label) && toc != null && (t = scope != null ? scope.getTopic(href) : toc.getTopic(href)) != null) {
                label = t.getLabel();
            }
            if (label == null || "".equals(label)) {
                label = href;
            }
            if (urlEncodedWords.length() > 0) {
                href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
            }
            ++filteredHits;
            searchHitList.add(new SearchHit(href, label, rawHit.getSummary(), score, toc, rawHit.getRawId(), rawHit.getParticipantId(), rawHit.isPotentialHit()));
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    public void setHits(SearchHit[] hits) {
        this.searchHits = hits;
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        boolean enabled = HelpPlugin.getCriteriaManager().isCriteriaEnabled();
        int i = 0;
        while (i < this.scopes.size()) {
            String owningTocHref;
            Toc toc;
            IToc tocRoot;
            AdaptableHelpResource scope = this.scopes.get(i);
            ITopic inScopeTopic = scope.getTopic(href);
            if (inScopeTopic != null && (this.filter == null || this.filter.inScope(inScopeTopic)) && (!enabled || enabled && this.criteriaScope.inScope(inScopeTopic))) {
                return scope;
            }
            if (!this.isQuickSearch && (tocRoot = this.getTocForScope(scope, this.locale)) != null && (toc = HelpPlugin.getTocManager().getOwningToc(href)) != null && (owningTocHref = toc.getHref()) == tocRoot.getHref()) {
                Topic extradirTopic = new Topic();
                extradirTopic.setHref(href);
                if ((this.filter == null || this.filter.inScope((ITopic)extradirTopic)) && (!enabled || enabled && this.criteriaScope.inScope(inScopeTopic))) {
                    return scope;
                }
            }
            ++i;
        }
        return null;
    }

    private IToc getTocForScope(AdaptableHelpResource scope, String locale) {
        if (scope == null) {
            return null;
        }
        String href = scope.getHref();
        if (scope.getAdapter(IToc.class) instanceof IToc) {
            IToc toc = (IToc)scope.getAdapter(IToc.class);
            href = toc.getTopic(null).getHref();
        }
        if (href != null && href.length() > 0) {
            return this.getTocForTopic(href, locale);
        }
        AdaptableHelpResource[] childrenScopes = scope.getChildren();
        if (childrenScopes != null) {
            int i = 0;
            while (i < childrenScopes.length) {
                IToc toc = this.getTocForScope(childrenScopes[i], locale);
                if (toc != null) {
                    return toc;
                }
                ++i;
            }
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        Toc toc;
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        boolean foundInToc = false;
        int i = 0;
        while (i < tocs.length) {
            Toc nextToc = tocs[i];
            ITopic topic = nextToc.getTopic(href);
            if (topic != null) {
                foundInToc = true;
                if (this.filter == null || this.filter.inScope(topic)) {
                    return nextToc;
                }
            }
            if ((topic = nextToc.getTopic(null)) != null && href != null && href.equals(topic.getHref())) {
                return nextToc;
            }
            ++i;
        }
        if (!foundInToc && (toc = HelpPlugin.getTocManager().getOwningToc(href)) != null) {
            foundInToc = true;
            if (this.filter == null || this.filter.inScope((IToc)toc)) {
                return toc;
            }
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    public QueryTooComplexException getException() {
        return this.searchException;
    }

    private ArrayList<AdaptableHelpResource> getScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        this.scopes = new ArrayList(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            AdaptableHelpResource[] elements = wSets[w].getElements();
            int i = 0;
            while (i < elements.length) {
                this.scopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return this.scopes;
    }

    private ArrayList<CriterionResource> getCriteriaScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        ArrayList<CriterionResource> criteriaScopes = new ArrayList<CriterionResource>(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            CriterionResource[] elements = wSets[w].getCriteria();
            int i = 0;
            while (i < elements.length) {
                criteriaScopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return criteriaScopes;
    }

    @Override
    public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
        this.searchException = exception;
    }
}

