/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.ui.internal.launchconfiguration.local;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.debug.ui.launcher.AbstractScriptLaunchShortcut;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.debug.ui.internal.Activator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LuaApplicationLaunchShortcut
extends AbstractScriptLaunchShortcut {
    protected ILaunchConfigurationType getConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.koneki.ldt.debug.core.lualocaldebug");
    }

    protected String getNatureId() {
        return "org.eclipse.koneki.ldt.nature";
    }

    public void searchAndLaunch(Object[] search, String mode, String selectMessage, String emptyMessage) {
        Object selection = search[0];
        ILaunchConfiguration config = null;
        config = this.findExistingLaunchConfiguration(selection, mode);
        if (config == null) {
            config = this.createLaunchConfiguration(selection);
        }
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    private ILaunchConfiguration createLaunchConfiguration(Object selection) {
        block16: {
            if (selection instanceof IFile) {
                return this.createLaunchConfiguration((IFile)selection);
            }
            if (selection instanceof ISourceModule) {
                try {
                    IResource correspondingResource = ((ISourceModule)selection).getCorrespondingResource();
                    if (correspondingResource instanceof IFile) {
                        return this.createLaunchConfiguration((IFile)correspondingResource);
                    }
                    break block16;
                }
                catch (ModelException e) {
                    Activator.logError(NLS.bind((String)"Unable to get corresponding resource for module {0}", (Object)selection), e);
                    return null;
                }
            }
            if (selection instanceof IFolder) {
                IModelElement sourcefolder = DLTKCore.create((IResource)((IFolder)selection));
                if (sourcefolder instanceof IScriptFolder) {
                    return this.createLaunchConfiguration((IParent)((IScriptFolder)sourcefolder));
                }
            } else {
                if (selection instanceof IScriptFolder) {
                    return this.createLaunchConfiguration((IParent)((IScriptFolder)selection));
                }
                if (selection instanceof IProject) {
                    IScriptProject project = DLTKCore.create((IProject)((IProject)selection));
                    if (project != null) {
                        return this.createLaunchConfiguration(project);
                    }
                } else if (selection instanceof ProjectFragment) {
                    IScriptProject scriptProject = ((ProjectFragment)selection).getScriptProject();
                    if (scriptProject != null) {
                        return this.createLaunchConfiguration(scriptProject);
                    }
                } else if (selection instanceof IScriptProject) {
                    return this.createLaunchConfiguration((IScriptProject)selection);
                }
            }
        }
        return null;
    }

    public ILaunchConfiguration createLaunchConfiguration(IFile script) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            String fileNameWithoutExtension = script.getLocation().removeFileExtension().lastSegment();
            String configNamePrefix = MessageFormat.format("{0}_{1}", script.getProject().getName(), fileNameWithoutExtension);
            wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configNamePrefix));
            wc.setAttribute("nature", this.getNatureId());
            wc.setAttribute("project", script.getProject().getName());
            wc.setAttribute("mainScript", script.getProjectRelativePath().toPortableString());
            wc.setAttribute("process_factory_id", "org.eclipse.dltk.launching.scriptProcessFactory");
            wc.setMappedResources(new IResource[]{script});
            config = wc.doSave();
        }
        catch (CoreException e) {
            Activator.logError("Unable to create a launch configuration from a LaunchShortcut", e);
        }
        return config;
    }

    public ILaunchConfiguration createLaunchConfiguration(IParent sourcecontainer) {
        IResource[] scripts = null;
        try {
            scripts = this.findScripts(new Object[]{sourcecontainer}, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchingMessages.ScriptLaunchShortcut_0, (String)e.getMessage());
            return null;
        }
        if (scripts.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchingMessages.ScriptLaunchShortcut_1, (String)this.getSelectionEmptyMessage());
        } else {
            IResource script;
            if (scripts.length == 1) {
                return this.createLaunchConfiguration(scripts[0]);
            }
            if (scripts.length > 1 && (script = this.chooseScript(scripts, this.getScriptSelectionTitle())) != null) {
                return this.createLaunchConfiguration(scripts[0]);
            }
        }
        return null;
    }

    public ILaunchConfiguration createLaunchConfiguration(IScriptProject project) {
        String defaultModuleName = new Path("main.lua").removeFileExtension().toString();
        IModuleSource mainModule = LuaUtils.getModuleSource((String)defaultModuleName, (IScriptProject)project);
        if (mainModule != null) {
            try {
                return this.createLaunchConfiguration(mainModule.getModelElement().getCorrespondingResource());
            }
            catch (ModelException e) {
                Activator.logWarning("Unable to find ressource corresponding to main module", e);
            }
        }
        return this.createLaunchConfiguration((IParent)project);
    }

    private ILaunchConfiguration findExistingLaunchConfiguration(Object container, String launchMode) {
        try {
            List<ILaunchConfiguration> candidateConfigs = this.retreiveLaunchConfiguration(launchMode);
            candidateConfigs = this.filterConfig(container, candidateConfigs);
            if (!candidateConfigs.isEmpty()) {
                return candidateConfigs.get(0);
            }
        }
        catch (CoreException e) {
            Activator.logWarning("Unable to retrieve existing launch configuration.", e);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return null;
    }

    private List<ILaunchConfiguration> retreiveLaunchConfiguration(String launchMode) throws CoreException {
        ILaunchGroup group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.getConfigurationType(), launchMode);
        LaunchHistory history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory(group.getIdentifier());
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        candidateConfigs.addAll(Arrays.asList(history.getFavorites()));
        candidateConfigs.addAll(Arrays.asList(history.getHistory()));
        if (candidateConfigs.isEmpty()) {
            candidateConfigs.addAll(Arrays.asList(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getConfigurationType())));
        }
        return candidateConfigs;
    }

    private List<ILaunchConfiguration> filterConfig(Object selection, List<ILaunchConfiguration> candidateConfigs) throws InterruptedException, CoreException {
        IResource[] scripts = this.findScripts(new Object[]{selection}, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        return this.filterConfig(Arrays.asList(scripts), candidateConfigs);
    }

    private List<ILaunchConfiguration> filterConfig(List<IResource> scripts, List<ILaunchConfiguration> configs) throws CoreException {
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration config : configs) {
            for (IResource script : scripts) {
                if (!config.getAttribute("mainScript", "").equals(script.getProjectRelativePath().toString()) || !config.getAttribute("project", "").equals(script.getProject().getName()) || !config.getType().equals(this.getConfigurationType())) continue;
                candidateConfigs.add(config);
            }
        }
        return candidateConfigs;
    }

    protected void launch(IResource script, String mode) {
        this.searchAndLaunch(new Object[]{script}, mode, null, null);
    }

    @Deprecated
    protected ILaunchConfiguration createConfiguration(IResource script) {
        return super.createConfiguration(script);
    }
}

