/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import com.cforcoding.jmd.MarkDown;
import com.naef.jnlua.LuaState;
import com.naef.jnlua.NamedJavaFunction;
import java.util.ArrayList;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ExprTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ExternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.InternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ModuleTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Parameter;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.PrimitiveTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Return;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;

public final class APIModelFactory {
    private APIModelFactory() {
    }

    public static final void registerAPIModelFactory(LuaState l) {
        NamedJavaFunction[] namedJavaFunctions = APIModelFactory.createFunctions();
        l.register("javaapimodelfactory", namedJavaFunctions);
    }

    private static NamedJavaFunction[] createFunctions() {
        ArrayList<NamedJavaFunction> javaFunctions = new ArrayList<NamedJavaFunction>();
        javaFunctions.add(APIModelFactory.newItem());
        javaFunctions.add(APIModelFactory.itemAddOccurrence());
        javaFunctions.add(APIModelFactory.newExternalTypeRef());
        javaFunctions.add(APIModelFactory.newInternalTypeRef());
        javaFunctions.add(APIModelFactory.newModuleTypeRef());
        javaFunctions.add(APIModelFactory.newExprTypeRef());
        javaFunctions.add(APIModelFactory.newPrimitiveTypeRef());
        javaFunctions.add(APIModelFactory.itemSetExpression());
        javaFunctions.add(APIModelFactory.newRecordTypeDef());
        javaFunctions.add(APIModelFactory.recordTypeDefAddField());
        javaFunctions.add(APIModelFactory.newFunctionTypeDef());
        javaFunctions.add(APIModelFactory.functionAddParam());
        javaFunctions.add(APIModelFactory.functionAddReturn());
        javaFunctions.add(APIModelFactory.newReturn());
        javaFunctions.add(APIModelFactory.returnAddTypeRef());
        javaFunctions.add(APIModelFactory.newLuaFileAPI());
        javaFunctions.add(APIModelFactory.fileAPIAddGlobalVar());
        javaFunctions.add(APIModelFactory.fileAPIAddReturn());
        javaFunctions.add(APIModelFactory.fileAPIAddTypeDef());
        javaFunctions.add(APIModelFactory.markdown());
        return javaFunctions.toArray(new NamedJavaFunction[javaFunctions.size()]);
    }

    private static NamedJavaFunction newItem() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String name = l.checkString(1);
                String documentation = l.checkString(2);
                int sourceRangeMin = l.checkInteger(3);
                int sourceRangeMax = l.checkInteger(4);
                TypeRef type = (TypeRef)l.checkJavaObject(5, TypeRef.class, null);
                Item item = new Item();
                item.setName(name);
                item.setDocumentation(documentation);
                item.setStart(sourceRangeMin);
                item.setEnd(sourceRangeMax);
                if (type != null) {
                    item.setType(type);
                }
                l.pushJavaObject((Object)item);
                return 1;
            }

            public String getName() {
                return "newitem";
            }
        };
    }

    private static NamedJavaFunction itemAddOccurrence() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                Item item = (Item)l.checkJavaObject(1, Item.class);
                Identifier identifier = (Identifier)((Object)l.checkJavaObject(2, Identifier.class));
                item.addOccurrence(identifier);
                return 0;
            }

            public String getName() {
                return "addoccurrence";
            }
        };
    }

    private static NamedJavaFunction newExternalTypeRef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String modulename = l.checkString(1);
                String typename = l.checkString(2);
                ExternalTypeRef typeref = new ExternalTypeRef(modulename, typename);
                l.pushJavaObject((Object)typeref);
                return 1;
            }

            public String getName() {
                return "newexternaltyperef";
            }
        };
    }

    private static NamedJavaFunction newInternalTypeRef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String typename = l.checkString(1);
                InternalTypeRef typeref = new InternalTypeRef(typename);
                l.pushJavaObject((Object)typeref);
                return 1;
            }

            public String getName() {
                return "newinternaltyperef";
            }
        };
    }

    private static NamedJavaFunction newModuleTypeRef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String typename = l.checkString(1);
                int returnposition = l.checkInteger(2);
                ModuleTypeRef typeref = new ModuleTypeRef(typename, returnposition);
                l.pushJavaObject((Object)typeref);
                return 1;
            }

            public String getName() {
                return "newmoduletyperef";
            }
        };
    }

    private static NamedJavaFunction newExprTypeRef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                int returnposition = l.checkInteger(1);
                ExprTypeRef typeref = new ExprTypeRef(returnposition);
                l.pushJavaObject((Object)typeref);
                return 1;
            }

            public String getName() {
                return "newexprtyperef";
            }
        };
    }

    private static NamedJavaFunction newPrimitiveTypeRef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String typename = l.checkString(1);
                PrimitiveTypeRef typeref = new PrimitiveTypeRef(typename);
                l.pushJavaObject((Object)typeref);
                return 1;
            }

            public String getName() {
                return "newprimitivetyperef";
            }
        };
    }

    private static NamedJavaFunction itemSetExpression() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                Item item = (Item)l.checkJavaObject(1, Item.class);
                LuaExpression expr = (LuaExpression)((Object)l.checkJavaObject(2, LuaExpression.class));
                ((ExprTypeRef)item.getType()).setExpression(expr);
                return 0;
            }

            public String getName() {
                return "setexpression";
            }
        };
    }

    private static NamedJavaFunction newRecordTypeDef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String name = l.checkString(1);
                String documentation = l.checkString(2);
                int sourceRangeMin = l.checkInteger(3);
                int sourceRangeMax = l.checkInteger(4);
                RecordTypeDef record = new RecordTypeDef();
                record.setName(name);
                record.setDocumentation(documentation);
                record.setStart(sourceRangeMin);
                record.setEnd(sourceRangeMax);
                l.pushJavaObject((Object)record);
                return 1;
            }

            public String getName() {
                return "newrecordtypedef";
            }
        };
    }

    private static NamedJavaFunction recordTypeDefAddField() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                RecordTypeDef record = (RecordTypeDef)l.checkJavaObject(1, RecordTypeDef.class);
                Item item = (Item)l.checkJavaObject(2, Item.class);
                record.addField(item);
                return 0;
            }

            public String getName() {
                return "addfield";
            }
        };
    }

    private static NamedJavaFunction newFunctionTypeDef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                l.pushJavaObject((Object)new FunctionTypeDef());
                return 1;
            }

            public String getName() {
                return "newfunctiontypedef";
            }
        };
    }

    private static NamedJavaFunction functionAddParam() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                FunctionTypeDef function = (FunctionTypeDef)l.checkJavaObject(1, FunctionTypeDef.class);
                String paramName = l.checkString(2);
                TypeRef type = (TypeRef)l.checkJavaObject(3, TypeRef.class);
                String description = l.checkString(4);
                function.addParameter(new Parameter(paramName, type, description));
                return 0;
            }

            public String getName() {
                return "addparam";
            }
        };
    }

    private static NamedJavaFunction newReturn() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                l.pushJavaObject((Object)new Return());
                return 1;
            }

            public String getName() {
                return "newreturn";
            }
        };
    }

    private static NamedJavaFunction returnAddTypeRef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                Return ret = (Return)l.checkJavaObject(1, Return.class);
                TypeRef typeRef = (TypeRef)l.checkJavaObject(2, TypeRef.class);
                ret.addType(typeRef);
                return 0;
            }

            public String getName() {
                return "addtype";
            }
        };
    }

    private static NamedJavaFunction functionAddReturn() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                FunctionTypeDef function = (FunctionTypeDef)l.checkJavaObject(1, FunctionTypeDef.class);
                Return ret = (Return)l.checkJavaObject(2, Return.class);
                function.addReturn(ret);
                return 0;
            }

            public String getName() {
                return "functionaddreturn";
            }
        };
    }

    private static NamedJavaFunction newLuaFileAPI() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String documentation = l.checkString(1, null);
                LuaFileAPI luafileAPI = new LuaFileAPI();
                if (documentation != null) {
                    luafileAPI.setDocumentation(documentation);
                }
                l.pushJavaObject((Object)luafileAPI);
                return 1;
            }

            public String getName() {
                return "newfileapi";
            }
        };
    }

    private static NamedJavaFunction fileAPIAddGlobalVar() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                LuaFileAPI luaFileAPI = (LuaFileAPI)((Object)l.checkJavaObject(1, LuaFileAPI.class));
                Item item = (Item)l.checkJavaObject(2, Item.class);
                luaFileAPI.addGlobalVar(item);
                return 0;
            }

            public String getName() {
                return "addglobalvar";
            }
        };
    }

    private static NamedJavaFunction fileAPIAddTypeDef() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                LuaFileAPI luaFileAPI = (LuaFileAPI)((Object)l.checkJavaObject(1, LuaFileAPI.class));
                String typeName = l.checkString(2);
                TypeDef typedef = (TypeDef)l.checkJavaObject(3, TypeDef.class);
                luaFileAPI.addType(typeName, typedef);
                return 0;
            }

            public String getName() {
                return "addtypedef";
            }
        };
    }

    private static NamedJavaFunction fileAPIAddReturn() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                LuaFileAPI luaFileAPI = (LuaFileAPI)((Object)l.checkJavaObject(1, LuaFileAPI.class));
                Return ret = (Return)l.checkJavaObject(2, Return.class);
                luaFileAPI.addReturns(ret);
                return 0;
            }

            public String getName() {
                return "fileapiaddreturn";
            }
        };
    }

    private static NamedJavaFunction markdown() {
        return new NamedJavaFunction(){
            private MarkDown markdown = new MarkDown();

            public int invoke(LuaState l) {
                String input = l.checkString(1);
                String result = this.markdown.transform(input);
                l.pushString(result);
                return 1;
            }

            public String getName() {
                return "markdown";
            }
        };
    }
}

