/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.folding;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.ui.text.folding.IElementCommentResolver;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class DefaultElementCommentResolver
implements IElementCommentResolver {
    private final ISourceModule fModule;
    private final String fContent;
    private Document fDocument = null;

    public DefaultElementCommentResolver(ISourceModule module) {
        this(module, null);
    }

    public DefaultElementCommentResolver(ISourceModule module, String contents) {
        this.fModule = module;
        this.fContent = contents;
    }

    protected IModelElement getContainingElement(IModelElement el, int offset, int length) throws ModelException {
        PositionVisitor visitor = new PositionVisitor(offset, length);
        el.accept((IModelElementVisitor)visitor);
        return visitor.result;
    }

    public IModelElement getElementByCommentPosition(int offset, int length) {
        try {
            return this.getElementByCommentPositionImpl(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    protected IModelElement getElementByCommentPositionImpl(int offset, int length) throws BadLocationException, ModelException {
        if (this.fDocument == null) {
            this.fDocument = new Document(this.getSource());
        }
        if (!this.checkIfPositionIsComment(this.fDocument, offset)) {
            return null;
        }
        IModelElement el = this.getContainingElement((IModelElement)this.fModule, offset, length);
        if (el != null && el.getElementType() == 9) {
            return el;
        }
        int sourceRangeEnd = this.getSourceRangeEnd(this.fDocument, el);
        IModelElement res = this.searchForNonCommentElement(this.fDocument, this.fModule, offset + length, sourceRangeEnd);
        if (res == null) {
            return el;
        }
        return res;
    }

    protected String getSource() throws ModelException {
        return this.fContent != null ? this.fContent : this.fModule.getSource();
    }

    protected int getSourceRangeEnd(Document d, IModelElement el) throws ModelException {
        int sourceRangeEnd = d.getLength();
        if (el != null && el.getElementType() == 7) {
            SourceType t = (SourceType)el;
            sourceRangeEnd = t.getSourceRange().getOffset() + t.getSourceRange().getLength();
        }
        return sourceRangeEnd;
    }

    protected boolean checkIfPositionIsComment(Document d, int offset) throws BadLocationException {
        int line = d.getLineOfOffset(offset);
        int q = d.getLineOffset(line);
        while (q < d.getLength() && Character.isWhitespace(d.getChar(q)) && q <= offset) {
            ++q;
        }
        return d.getChar(q) == '#';
    }

    /*
     * Unable to fully structure code
     */
    protected IModelElement searchForNonCommentElement(Document d, ISourceModule content, int endOfCommentOffset, int lowerbound) throws BadLocationException, ModelException {
        res = null;
        off = endOfCommentOffset;
        line = d.getLineOfOffset(off);
        off = d.getLineOffset(line);
        ** GOTO lbl13
        {
            ++off;
            do {
                if (off < lowerbound - 1 && Character.isWhitespace(d.getChar(off))) continue block0;
                if (d.getChar(off) != '#') {
                    res = content.getElementAt(off);
                    break block0;
                }
                off = d.getLineOffset(++line);
lbl13:
                // 2 sources

            } while (off < lowerbound);
        }
        return res;
    }

    private static class PositionVisitor
    implements IModelElementVisitor {
        IModelElement result = null;
        private final int offset;
        private final int length;

        public PositionVisitor(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public boolean visit(IModelElement element) {
            if (element instanceof ISourceReference) {
                ISourceRange range;
                try {
                    range = ((ISourceReference)element).getSourceRange();
                }
                catch (ModelException modelException) {
                    return true;
                }
                if (this.offset >= range.getOffset() && this.offset + this.length <= range.getOffset() + range.getLength() && (element.getElementType() == 9 || element.getElementType() == 7)) {
                    this.result = element;
                }
            }
            return true;
        }
    }
}

