/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    Shell tip;
    TrayItem item;
    int x;
    int y;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    Listener listener;
    Listener parentListener;
    TextLayout layoutText;
    TextLayout layoutMessage;
    Region region;
    Font boldFont;
    Runnable runnable;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 10000;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.autohide = true;
        this.y = -1;
        this.x = -1;
        Display display = this.getDisplay();
        this.tip = new Shell(parent, 16392);
        Color background = display.getSystemColor(29);
        this.tip.setBackground(background);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        ToolTip.this.onDispose(event);
                        break;
                    }
                    case 9: {
                        ToolTip.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        ToolTip.this.onMouseDown(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.tip.addListener(9, this.listener);
        this.tip.addListener(3, this.listener);
        this.parentListener = new Listener(){

            public void handleEvent(Event event) {
                ToolTip.this.dispose();
            }
        };
        parent.addListener(12, this.parentListener);
    }

    static int checkStyle(int style) {
        int mask = 11;
        if ((style & mask) == 0) {
            return style;
        }
        return ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] polyline;
        Display display = this.parent.getDisplay();
        int x = this.x;
        int y = this.y;
        if (x == -1 || y == -1) {
            Point point = this.item != null ? this.item.getLocation() : display.getCursorLocation();
            x = point.x;
            y = point.y;
        }
        Monitor monitor = this.parent.getMonitor();
        Rectangle dest = monitor.getBounds();
        Point size = this.getSize(dest.width / 4);
        int w = size.x;
        int h = size.y;
        int t = (this.style & 0x1000) != 0 ? 20 : 0;
        int i = (this.style & 0x1000) != 0 ? 16 : 0;
        this.tip.setSize(w, h + t);
        boolean bl = this.spikeAbove = dest.height >= y + size.y + t;
        if (dest.width >= x + size.x) {
            if (dest.height >= y + size.y + t) {
                polyline = new int[]{0, 5 + t, 1, 5 + t, 1, 3 + t, 3, 1 + t, 5, 1 + t, 5, t, 16, t, 16, 0, 35, t, w - 5, t, w - 5, 1 + t, w - 3, 1 + t, w - 1, 3 + t, w - 1, 5 + t, w, 5 + t, w, h - 5 + t, w - 1, h - 5 + t, w - 1, h - 3 + t, w - 2, h - 3 + t, w - 2, h - 2 + t, w - 3, h - 2 + t, w - 3, h - 1 + t, w - 5, h - 1 + t, w - 5, h + t, 5, h + t, 5, h - 1 + t, 3, h - 1 + t, 3, h - 2 + t, 2, h - 2 + t, 2, h - 3 + t, 1, h - 3 + t, 1, h - 5 + t, 0, h - 5 + t, 0, 5 + t};
                this.borderPolygon = new int[]{0, 5 + t, 1, 4 + t, 1, 3 + t, 3, 1 + t, 4, 1 + t, 5, t, 16, t, 16, 1, 35, t, w - 6, 0 + t, w - 5, 1 + t, w - 4, 1 + t, w - 2, 3 + t, w - 2, 4 + t, w - 1, 5 + t, w - 1, h - 6 + t, w - 2, h - 5 + t, w - 2, h - 4 + t, w - 4, h - 2 + t, w - 5, h - 2 + t, w - 6, h - 1 + t, 5, h - 1 + t, 4, h - 2 + t, 3, h - 2 + t, 1, h - 4 + t, 1, h - 5 + t, 0, h - 6 + t, 0, 5 + t};
                this.tip.setLocation(Math.max(0, x - i), y);
            } else {
                polyline = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, w - 5, 0, w - 5, 1, w - 3, 1, w - 1, 3, w - 1, 5, w, 5, w, h - 5, w - 1, h - 5, w - 1, h - 3, w - 2, h - 3, w - 2, h - 2, w - 3, h - 2, w - 3, h - 1, w - 5, h - 1, w - 5, h, 35, h, 16, h + t, 16, h, 5, h, 5, h - 1, 3, h - 1, 3, h - 2, 2, h - 2, 2, h - 3, 1, h - 3, 1, h - 5, 0, h - 5, 0, 5};
                this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, w - 6, 0, w - 5, 1, w - 4, 1, w - 2, 3, w - 2, 4, w - 1, 5, w - 1, h - 6, w - 2, h - 5, w - 2, h - 4, w - 4, h - 2, w - 5, h - 2, w - 6, h - 1, 36, h - 1, 16, h + t - 1, 16, h - 1, 5, h - 1, 4, h - 2, 3, h - 2, 1, h - 4, 1, h - 5, 0, h - 6, 0, 5};
                this.tip.setLocation(Math.max(0, x - i), y - size.y - t);
            }
        } else if (dest.height >= y + size.y + t) {
            polyline = new int[]{0, 5 + t, 1, 5 + t, 1, 3 + t, 3, 1 + t, 5, 1 + t, 5, t, w - 35, t, w - 16, 0, w - 16, t, w - 5, t, w - 5, 1 + t, w - 3, 1 + t, w - 1, 3 + t, w - 1, 5 + t, w, 5 + t, w, h - 5 + t, w - 1, h - 5 + t, w - 1, h - 3 + t, w - 2, h - 3 + t, w - 2, h - 2 + t, w - 3, h - 2 + t, w - 3, h - 1 + t, w - 5, h - 1 + t, w - 5, h + t, 5, h + t, 5, h - 1 + t, 3, h - 1 + t, 3, h - 2 + t, 2, h - 2 + t, 2, h - 3 + t, 1, h - 3 + t, 1, h - 5 + t, 0, h - 5 + t, 0, 5 + t};
            this.borderPolygon = new int[]{0, 5 + t, 1, 4 + t, 1, 3 + t, 3, 1 + t, 4, 1 + t, 5, t, w - 35, t, w - 17, 2, w - 17, t, w - 6, t, w - 5, 1 + t, w - 4, 1 + t, w - 2, 3 + t, w - 2, 4 + t, w - 1, 5 + t, w - 1, h - 6 + t, w - 2, h - 5 + t, w - 2, h - 4 + t, w - 4, h - 2 + t, w - 5, h - 2 + t, w - 6, h - 1 + t, 5, h - 1 + t, 4, h - 2 + t, 3, h - 2 + t, 1, h - 4 + t, 1, h - 5 + t, 0, h - 6 + t, 0, 5 + t};
            this.tip.setLocation(Math.min(dest.width - size.x, x - size.x + i), y);
        } else {
            polyline = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, w - 5, 0, w - 5, 1, w - 3, 1, w - 1, 3, w - 1, 5, w, 5, w, h - 5, w - 1, h - 5, w - 1, h - 3, w - 2, h - 3, w - 2, h - 2, w - 3, h - 2, w - 3, h - 1, w - 5, h - 1, w - 5, h, w - 16, h, w - 16, h + t, w - 35, h, 5, h, 5, h - 1, 3, h - 1, 3, h - 2, 2, h - 2, 2, h - 3, 1, h - 3, 1, h - 5, 0, h - 5, 0, 5};
            this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, w - 6, 0, w - 5, 1, w - 4, 1, w - 2, 3, w - 2, 4, w - 1, 5, w - 1, h - 6, w - 2, h - 5, w - 2, h - 4, w - 4, h - 2, w - 5, h - 2, w - 6, h - 1, w - 17, h - 1, w - 17, h + t - 2, w - 36, h - 1, 5, h - 1, 4, h - 2, 3, h - 2, 1, h - 4, 1, h - 5, 0, h - 6, 0, 5};
            this.tip.setLocation(Math.min(dest.width - size.x, x - size.x + i), y - size.y - t);
        }
        if ((this.style & 0x1000) != 0) {
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = new Region(display);
            this.region.add(polyline);
            this.tip.setRegion(this.region);
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getSize(int maxWidth) {
        int textWidth = 0;
        int messageWidth = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(-1);
            textWidth = this.layoutText.getBounds().width;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(-1);
            messageWidth = this.layoutMessage.getBounds().width;
        }
        int messageTrim = 28;
        boolean hasImage = this.layoutText != null && (this.style & 0x1000) != 0 && (this.style & 0xB) != 0;
        int textTrim = messageTrim + (hasImage ? 16 : 0);
        int width = Math.min(maxWidth, Math.max(textWidth + textTrim, messageWidth + messageTrim));
        int textHeight = 0;
        int messageHeight = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(maxWidth - textTrim);
            textHeight = this.layoutText.getBounds().height;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(maxWidth - messageTrim);
            messageHeight = this.layoutMessage.getBounds().height;
        }
        int height = 20 + messageHeight;
        if (this.layoutText != null) {
            height += Math.max(16, textHeight) + 10;
        }
        return new Point(width, height);
    }

    public String getMessage() {
        this.checkWidget();
        return this.layoutMessage != null ? this.layoutMessage.getText() : "";
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.layoutText != null ? this.layoutText.getText() : "";
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.tip.getVisible();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void onDispose(Event event) {
        Shell parent = this.getParent();
        parent.removeListener(12, this.parentListener);
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        if (this.runnable != null) {
            Display display = this.getDisplay();
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        this.tip.dispose();
        this.tip = null;
        if (this.region != null) {
            this.region.dispose();
        }
        this.region = null;
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        this.borderPolygon = null;
    }

    void onMouseDown(Event event) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
    }

    void onPaint(Event event) {
        GC gc = event.gc;
        int x = 10;
        int y = 10;
        if ((this.style & 0x1000) != 0) {
            if (this.spikeAbove) {
                y += 20;
            }
            gc.drawPolygon(this.borderPolygon);
        } else {
            Rectangle rect = this.tip.getClientArea();
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
        if (this.layoutText != null) {
            int id2 = this.style & 0xB;
            if ((this.style & 0x1000) != 0 && id2 != 0) {
                Display display = this.getDisplay();
                Image image = display.getSystemImage(id2);
                Rectangle rect = image.getBounds();
                gc.drawImage(image, 0, 0, rect.width, rect.height, x, y, 16, 16);
                x += 16;
            }
            this.layoutText.draw(gc, x += 4, y);
            y += 10 + Math.max(16, this.layoutText.getBounds().height);
        }
        if (this.layoutMessage != null) {
            x = 14;
            this.layoutMessage.draw(gc, x, y);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAutoHide(boolean autoHide) {
        this.checkWidget();
        this.autohide = autoHide;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if (this.x == x && this.y == y) {
            return;
        }
        this.x = x;
        this.y = y;
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutMessage = new TextLayout(display);
            this.layoutMessage.setText(string);
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutText = new TextLayout(display);
            this.layoutText.setText(string);
            Font font = display.getSystemFont();
            FontData data = font.getFontData()[0];
            this.boldFont = new Font((Device)display, data.getName(), data.getHeight(), 1);
            TextStyle style = new TextStyle(this.boldFont, null, null);
            this.layoutText.setStyle(style, 0, string.length());
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            this.configure();
        }
        this.tip.setVisible(visible);
        Display display = this.getDisplay();
        if (this.runnable != null) {
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        if (this.autohide && visible) {
            this.runnable = new Runnable(){

                public void run() {
                    if (!ToolTip.this.isDisposed()) {
                        ToolTip.this.setVisible(false);
                    }
                }
            };
            display.timerExec(10000, this.runnable);
        }
    }
}

