/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.actions.CommonActionDescriptorManager;
import org.eclipse.ui.internal.navigator.actions.CommonActionProviderDescriptor;
import org.eclipse.ui.internal.navigator.extensions.CommonActionExtensionSite;
import org.eclipse.ui.internal.navigator.extensions.SkeletonActionProvider;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.navigator.MenuInsertionPoint;

public final class NavigatorActionService
extends ActionGroup
implements IMementoAware {
    private static final IContributionItem[] DEFAULT_GROUPS = new IContributionItem[]{new Separator("group.new"), new GroupMarker("group.goto"), new GroupMarker("group.open"), new GroupMarker("group.openWith"), new Separator("group.edit"), new GroupMarker("group.show"), new GroupMarker("group.reorganize"), new GroupMarker("group.port"), new Separator("group.generate"), new Separator("group.search"), new Separator("group.build"), new Separator("additions"), new Separator("group.properties")};
    private final ICommonViewerSite commonViewerSite;
    private final StructuredViewer structuredViewer;
    private final NavigatorContentService contentService;
    private final INavigatorViewerDescriptor viewerDescriptor;
    private final Set actionProviderDescriptors = new HashSet();
    private final Map actionProviderInstances = new HashMap();
    private IMemento memento;
    private IContributionItem[] menuGroups;
    private boolean disposed = false;

    public NavigatorActionService(ICommonViewerSite aCommonViewerSite, StructuredViewer aStructuredViewer, INavigatorContentService aContentService) {
        Assert.isNotNull((Object)aCommonViewerSite);
        Assert.isNotNull((Object)aStructuredViewer);
        Assert.isNotNull((Object)aContentService);
        this.commonViewerSite = aCommonViewerSite;
        this.contentService = (NavigatorContentService)aContentService;
        this.structuredViewer = aStructuredViewer;
        this.viewerDescriptor = this.contentService.getViewerDescriptor();
    }

    public void prepareMenuForPlatformContributions(MenuManager menu, ISelectionProvider aSelectionProvider, boolean force) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        if (this.commonViewerSite instanceof ICommonViewerWorkbenchSite && (force || this.viewerDescriptor.allowsPlatformContributionsToContextMenu())) {
            ((ICommonViewerWorkbenchSite)this.commonViewerSite).registerContextMenu(this.contentService.getViewerDescriptor().getPopupMenuId(), menu, aSelectionProvider);
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        if (this.menuGroups == null) {
            this.createMenuGroups();
        }
        int i = 0;
        while (i < this.menuGroups.length) {
            aMenu.add(this.menuGroups[i]);
            ++i;
        }
        this.addCommonActionProviderMenu(aMenu);
    }

    private void createMenuGroups() {
        MenuInsertionPoint[] customPoints = this.viewerDescriptor.getCustomInsertionPoints();
        if (customPoints == null) {
            this.menuGroups = DEFAULT_GROUPS;
        } else {
            this.menuGroups = new IContributionItem[customPoints.length];
            int i = 0;
            while (i < customPoints.length) {
                this.menuGroups[i] = customPoints[i].isSeparator() ? new Separator(customPoints[i].getName()) : new GroupMarker(customPoints[i].getName());
                ++i;
            }
        }
    }

    private boolean filterActionProvider(final CommonActionProviderDescriptor providerDesc) {
        IPluginContribution piCont = new IPluginContribution(){

            public String getLocalId() {
                return providerDesc.getId();
            }

            public String getPluginId() {
                return providerDesc.getPluginId();
            }
        };
        return WorkbenchActivityHelper.filterItem((Object)piCont);
    }

    private void addCommonActionProviderMenu(final IMenuManager aMenu) {
        CommonActionProviderDescriptor[] providerDescriptors = CommonActionDescriptorManager.getInstance().findRelevantActionDescriptors(this.contentService, this.getContext());
        if (providerDescriptors.length > 0) {
            int i = 0;
            while (i < providerDescriptors.length) {
                final CommonActionProviderDescriptor providerDescriptorLocal = providerDescriptors[i];
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    public void run() throws Exception {
                        if (!NavigatorActionService.this.filterActionProvider(providerDescriptorLocal)) {
                            CommonActionProvider provider = NavigatorActionService.this.getActionProviderInstance(providerDescriptorLocal);
                            provider.setContext(NavigatorActionService.this.getContext());
                            provider.fillContextMenu(aMenu);
                        }
                    }
                });
                ++i;
            }
        }
    }

    public void fillActionBars(final IActionBars theActionBars) {
        CommonActionProviderDescriptor[] providerDescriptors;
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        theActionBars.clearGlobalActionHandlers();
        ActionContext context = this.getContext();
        if (context == null) {
            context = new ActionContext((ISelection)StructuredSelection.EMPTY);
        }
        if ((providerDescriptors = CommonActionDescriptorManager.getInstance().findRelevantActionDescriptors(this.contentService, context)).length > 0) {
            int i = 0;
            while (i < providerDescriptors.length) {
                final CommonActionProviderDescriptor providerDesciptorLocal = providerDescriptors[i];
                final ActionContext actionContextLocal = context;
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    public void run() throws Exception {
                        if (!NavigatorActionService.this.filterActionProvider(providerDesciptorLocal)) {
                            CommonActionProvider provider = null;
                            provider = NavigatorActionService.this.getActionProviderInstance(providerDesciptorLocal);
                            provider.setContext(actionContextLocal);
                            provider.fillActionBars(theActionBars);
                            provider.updateActionBars();
                        }
                    }
                });
                ++i;
            }
        }
        theActionBars.updateActionBars();
        theActionBars.getMenuManager().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator iter = this.actionProviderInstances.values().iterator();
            while (iter.hasNext()) {
                CommonActionProvider element = (CommonActionProvider)iter.next();
                element.dispose();
            }
            this.actionProviderInstances.clear();
        }
        this.actionProviderDescriptors.clear();
        this.disposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(IMemento aMemento) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        this.memento = aMemento;
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator actionProviderIterator = this.actionProviderInstances.values().iterator();
            while (actionProviderIterator.hasNext()) {
                final CommonActionProvider provider = (CommonActionProvider)actionProviderIterator.next();
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    public void run() throws Exception {
                        provider.restoreState(NavigatorActionService.this.memento);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IMemento aMemento) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        this.memento = aMemento;
        CommonActionProvider provider = null;
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator actionProviderIterator = this.actionProviderInstances.values().iterator();
            while (actionProviderIterator.hasNext()) {
                provider = (CommonActionProvider)actionProviderIterator.next();
                provider.saveState(this.memento);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonActionProvider getActionProviderInstance(final CommonActionProviderDescriptor aProviderDescriptor) {
        CommonActionProvider provider = null;
        provider = (CommonActionProvider)this.actionProviderInstances.get(aProviderDescriptor);
        if (provider != null) {
            return provider;
        }
        Map map = this.actionProviderInstances;
        synchronized (map) {
            provider = (CommonActionProvider)this.actionProviderInstances.get(aProviderDescriptor);
            if (provider == null) {
                final CommonActionProvider[] retProvider = new CommonActionProvider[1];
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    public void run() throws Exception {
                        retProvider[0] = aProviderDescriptor.createActionProvider();
                        if (retProvider[0] != null) {
                            NavigatorActionService.this.initialize(aProviderDescriptor.getId(), aProviderDescriptor.getPluginId(), retProvider[0]);
                        }
                    }
                });
                if (retProvider[0] == null) {
                    retProvider[0] = SkeletonActionProvider.INSTANCE;
                }
                this.actionProviderInstances.put(aProviderDescriptor, retProvider[0]);
                provider = retProvider[0];
            }
        }
        return provider;
    }

    private void initialize(final String id, final String pluginId, final CommonActionProvider anActionProvider) {
        if (anActionProvider != null && anActionProvider != SkeletonActionProvider.INSTANCE) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                public void run() throws Exception {
                    CommonActionExtensionSite configuration = new CommonActionExtensionSite(id, pluginId, NavigatorActionService.this.commonViewerSite, NavigatorActionService.this.contentService, NavigatorActionService.this.structuredViewer);
                    anActionProvider.init(configuration);
                    anActionProvider.restoreState(NavigatorActionService.this.memento);
                    anActionProvider.setContext(new ActionContext((ISelection)StructuredSelection.EMPTY));
                }
            });
        }
    }
}

