/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.core.search.matching2.FalseMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.IMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrMatchingPredicate<E>
implements IMatchingPredicate<E> {
    private List<IMatchingPredicate<E>> predicates = new ArrayList<IMatchingPredicate<E>>();

    public void addPredicate(IMatchingPredicate<E> predicate) {
        this.predicates.add(predicate);
    }

    @Override
    public MatchLevel match(E node) {
        for (IMatchingPredicate<E> predicate : this.predicates) {
            MatchLevel level = predicate.match(node);
            if (level == null) continue;
            return level;
        }
        return null;
    }

    @Override
    public MatchLevel resolvePotentialMatch(E node) {
        for (IMatchingPredicate<E> predicate : this.predicates) {
            MatchLevel level = predicate.resolvePotentialMatch(node);
            if (level == null) continue;
            return level;
        }
        return null;
    }

    public IMatchingPredicate<E> optimize() {
        IMatchingPredicate predicate;
        LinkedList<IMatchingPredicate<E>> queue = new LinkedList<IMatchingPredicate<E>>(this.predicates);
        while ((predicate = (IMatchingPredicate)queue.poll()) != null) {
            Iterator<IMatchingPredicate<E>> i = this.predicates.iterator();
            while (i.hasNext()) {
                IMatchingPredicate<E> next = i.next();
                if (predicate == next || !predicate.contains(next)) continue;
                i.remove();
                queue.remove(next);
            }
        }
        if (this.predicates.isEmpty()) {
            return new FalseMatchingPredicate();
        }
        if (this.predicates.size() == 1) {
            return this.predicates.get(0);
        }
        return this;
    }

    @Override
    public boolean contains(IMatchingPredicate<E> predicate) {
        return false;
    }
}

