/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.net.URI;
import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.IDbgpSpawnpoint;
import org.eclipse.dltk.dbgp.commands.IDbgpCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpSpawnpointCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpSpawnpointCommands
extends DbgpBaseCommands
implements IDbgpSpawnpointCommands {
    private static final String ELEMENT_SPAWNPOINT = "spawnpoint";
    private static final String ATTR_ID = "id";
    private static final String ATTR_STATE = "state";
    private static final String ATTR_FILENAME = "filename";
    private static final String ATTR_LINENO = "lineno";
    private static final String CMD_GET = "spawnpoint_get";
    private static final String CMD_SET = "spawnpoint_set";
    private static final String CMD_LIST = "spawnpoint_list";
    private static final String CMD_REMOVE = "spawnpoint_remove";
    private static final String CMD_UPDATE = "spawnpoint_update";
    private static final String OPTION_ID = "-d";
    private static final String OPTION_FILENAME = "-f";
    private static final String OPTION_LINE = "-n";
    private static final String OPTION_STATE = "-s";
    private static final String STATE_ENABLED = "enabled";
    private static final String STATE_DISABLED = "disabled";
    private final IDbgpCommands commands;
    private boolean initialized = false;

    public DbgpSpawnpointCommands(IDbgpCommunicator communicator, IDbgpCommands commands) {
        super(communicator);
        this.commands = commands;
    }

    private void initSpawnpoints() {
        if (this.initialized) {
            return;
        }
        try {
            this.commands.getCoreCommands().setFeature("multiple_sessions", "1");
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.logWarning("Error setting 'multiple_sessions' feature to '1'", e);
        }
        this.initialized = true;
    }

    public IDbgpSpawnpoint getSpawnpoint(String spawnpointId) throws DbgpException {
        this.initSpawnpoints();
        DbgpRequest request = DbgpSpawnpointCommands.createRequest(CMD_GET);
        request.addOption(OPTION_ID, spawnpointId);
        Element response = this.communicate(request);
        String id = response.getAttribute(ATTR_ID);
        if (id != null) {
            return new DbgpSpawnpointString(id, DbgpSpawnpointCommands.parseState(response), response.getAttribute(ATTR_FILENAME), DbgpSpawnpointCommands.parseLineNumber(response));
        }
        return null;
    }

    public IDbgpSpawnpoint[] listSpawnpoints() throws DbgpException {
        this.initSpawnpoints();
        DbgpRequest request = DbgpSpawnpointCommands.createRequest(CMD_LIST);
        Element response = this.communicate(request);
        NodeList points = response.getElementsByTagName(ELEMENT_SPAWNPOINT);
        IDbgpSpawnpoint[] result = new IDbgpSpawnpoint[points.getLength()];
        int count = 0;
        int i = 0;
        while (i < points.getLength()) {
            Element point = (Element)points.item(i);
            String id = point.getAttribute(ATTR_ID);
            if (id != null) {
                result[count++] = new DbgpSpawnpointString(id, DbgpSpawnpointCommands.parseState(point), point.getAttribute(ATTR_FILENAME), DbgpSpawnpointCommands.parseLineNumber(point));
            }
            ++i;
        }
        if (count < result.length) {
            IDbgpSpawnpoint[] newResult = new IDbgpSpawnpoint[count];
            System.arraycopy(result, 0, newResult, 0, count);
            return newResult;
        }
        return result;
    }

    public void removeSpawnpoint(String spawnpointId) throws DbgpException {
        if (spawnpointId == null) {
            return;
        }
        this.initSpawnpoints();
        DbgpRequest request = DbgpSpawnpointCommands.createRequest(CMD_REMOVE);
        request.addOption(OPTION_ID, spawnpointId);
        this.communicate(request);
    }

    public IDbgpSpawnpoint setSpawnpoint(URI uri, int lineNumber, boolean enabled) throws DbgpException {
        this.initSpawnpoints();
        DbgpRequest request = DbgpSpawnpointCommands.createRequest(CMD_SET);
        request.addOption(OPTION_FILENAME, uri.toString());
        request.addOption(OPTION_LINE, lineNumber);
        request.addOption(OPTION_STATE, enabled ? STATE_ENABLED : STATE_DISABLED);
        Element response = this.communicate(request);
        String id = response.getAttribute(ATTR_ID);
        if (id != null) {
            return new DbgpSpawnpoint(id, DbgpSpawnpointCommands.parseState(response), uri, lineNumber);
        }
        return null;
    }

    public void updateSpawnpoint(String spawnpointId, boolean enabled) throws DbgpException {
        this.initSpawnpoints();
        DbgpRequest request = DbgpSpawnpointCommands.createRequest(CMD_UPDATE);
        request.addOption(OPTION_ID, spawnpointId);
        request.addOption(OPTION_STATE, enabled ? STATE_ENABLED : STATE_DISABLED);
        this.communicate(request);
    }

    private static boolean parseState(Element response) {
        return STATE_ENABLED.equals(response.getAttribute(ATTR_STATE));
    }

    private static int parseLineNumber(Element point) {
        try {
            return Integer.parseInt(point.getAttribute(ATTR_LINENO));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static abstract class AbstractSpawnpoint
    implements IDbgpSpawnpoint {
        private final String id;
        private final boolean enabled;
        private final int lineNumber;

        public AbstractSpawnpoint(String id, boolean enabled, int lineNumber) {
            this.id = id;
            this.enabled = enabled;
            this.lineNumber = lineNumber;
        }

        public String getId() {
            return this.id;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String toString() {
            return String.valueOf(this.id) + '/' + (this.enabled ? DbgpSpawnpointCommands.STATE_ENABLED : DbgpSpawnpointCommands.STATE_DISABLED) + '/' + this.getFilename() + ':' + this.lineNumber;
        }
    }

    private static class DbgpSpawnpoint
    extends AbstractSpawnpoint {
        private final URI uri;

        public DbgpSpawnpoint(String id, boolean enabled, URI uri, int lineNumber) {
            super(id, enabled, lineNumber);
            this.uri = uri;
        }

        public String getFilename() {
            return this.uri.toString();
        }
    }

    private static class DbgpSpawnpointString
    extends AbstractSpawnpoint {
        private final String filename;

        public DbgpSpawnpointString(String id, boolean enabled, String filename, int lineNumber) {
            super(id, enabled, lineNumber);
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

