/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.editor.internal.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class LuaCodeScanner
extends AbstractScriptScanner {
    private static String[] fgKeywords = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"};
    private static String[] fgTokenProperties = new String[]{"DLTK_string", "DLTK_single_line_comment", "DLTK_multi_line_comment", "DLTK_number", "DLTK_default", "DLTK_keyword"};

    public LuaCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token keyword = this.getToken("DLTK_keyword");
        Token comment = this.getToken("DLTK_single_line_comment");
        Token multiline = this.getToken("DLTK_multi_line_comment");
        Token numbers = this.getToken("DLTK_number");
        Token other = this.getToken("DLTK_default");
        rules.add((IRule)new MultiLineRule("--[[", "]]", (IToken)multiline));
        rules.add((IRule)new EndOfLineRule("--", (IToken)comment));
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new LuaWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new LuaWordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        rules.add((IRule)wordRule);
        LuaNumberRule numberRule = new LuaNumberRule((IToken)numbers);
        rules.add((IRule)numberRule);
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }

    private static class LuaNumberRule
    extends NumberRule {
        public LuaNumberRule(IToken token) {
            super(token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c;
            int p = c = scanner.read();
            if (Character.isDigit((char)c) || c == 46 || c == 45) {
                boolean hex = false;
                if (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1) {
                    do {
                        p = c;
                        c = scanner.read();
                        if (c != 120 && (c != 88 || hex)) continue;
                        hex = true;
                        p = c;
                        c = scanner.read();
                    } while (Character.isDigit((char)c) || hex && Character.digit((char)c, 16) != -1);
                    if (c != 101 && c != 69) {
                        scanner.unread();
                    }
                    if (p == 46) {
                        scanner.unread();
                        return Token.UNDEFINED;
                    }
                    return this.fToken;
                }
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static class LuaWhitespaceDetector
    implements IWhitespaceDetector {
        private LuaWhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }

    private static class LuaWordDetector
    implements IWordDetector {
        private LuaWordDetector() {
        }

        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierStart(character);
        }
    }
}

