/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IViewerCreator;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.IViewerDescriptor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class ViewerDescriptor
implements IViewerDescriptor {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String EXTENSIONS_ATTRIBUTE = "extensions";
    private static final String LABEL_ATTRIBUTE = "label";
    private IConfigurationElement fConfiguration;
    private IViewerCreator fViewerCreator;
    private Class fViewerClass;
    static /* synthetic */ Class class$0;

    public ViewerDescriptor(IConfigurationElement config) {
        this.fConfiguration = config;
    }

    public Viewer createViewer(Viewer currentViewer, Composite parent, CompareConfiguration mp) {
        if (currentViewer != null && currentViewer.getClass() == this.fViewerClass) {
            return currentViewer;
        }
        if (this.fViewerCreator == null) {
            try {
                this.fViewerCreator = (IViewerCreator)this.fConfiguration.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                CompareUIPlugin.log(e);
            }
        }
        if (this.fViewerCreator != null) {
            Viewer viewer;
            if (currentViewer != null) {
                CompareHandlerService[] compareHandlerService;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.compare.internal.CompareHandlerService;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((compareHandlerService = (CompareHandlerService[])Utilities.getAdapter(currentViewer, clazz)) != null) {
                    int i = 0;
                    while (i < compareHandlerService.length) {
                        compareHandlerService[i].dispose();
                        ++i;
                    }
                }
            }
            if ((viewer = this.fViewerCreator.createViewer(parent, mp)) != null) {
                this.fViewerClass = viewer.getClass();
            }
            return viewer;
        }
        return null;
    }

    public String getExtension() {
        return this.fConfiguration.getAttribute(EXTENSIONS_ATTRIBUTE);
    }

    String getLabel() {
        return this.fConfiguration.getAttribute(LABEL_ATTRIBUTE);
    }
}

