/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text.folding;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockRequestor;
import org.eclipse.dltk.ui.text.folding.IFoldingContent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Block;
import org.eclipse.koneki.ldt.ui.internal.editor.text.folding.LuaFoldingBlockKind;

public class LuaCodeFoldingBlockProvider
extends ASTVisitor
implements IFoldingBlockProvider {
    private boolean fCollapseBlocks;
    private int fBlockLinesMin;
    private IFoldingBlockRequestor requestor;

    public void initializePreferences(IPreferenceStore preferenceStore) {
        this.fCollapseBlocks = preferenceStore.getBoolean("editor_folding_init_methods");
        this.fBlockLinesMin = preferenceStore.getInt("editor_folding_lines_limit");
    }

    public void setRequestor(IFoldingBlockRequestor requestor) {
        this.requestor = requestor;
    }

    public int getMinimalLineCount() {
        return this.fBlockLinesMin;
    }

    public void computeFoldableBlocks(IFoldingContent content) {
        if (content.getModelElement() instanceof ISourceModule) {
            IModuleDeclaration declaration = SourceParserUtil.parse((ISourceModule)((ISourceModule)content.getModelElement()), null);
            for (LuaASTNode node : ((LuaSourceRoot)declaration).getInternalContent().getContent().getContent()) {
                if (!(node instanceof Block)) continue;
                this.requestor.acceptBlock(node.sourceStart(), node.sourceEnd(), (IFoldingBlockKind)LuaFoldingBlockKind.COMMENT, null, this.fCollapseBlocks);
            }
        }
    }
}

