/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal;

import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IScriptStack;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.koneki.ldt.debug.core.internal.Activator;
import org.eclipse.koneki.ldt.debug.core.internal.LuaCoroutine;

public class LuaCoroutineStack
implements IScriptStack {
    private IScriptStackFrame[] frames;
    private final Object framesLock = new Object();
    private final LuaCoroutine thread;

    public LuaCoroutineStack(LuaCoroutine thread) {
        this.thread = thread;
        this.frames = null;
    }

    protected IDbgpStackLevel[] requestStackLevels() throws DbgpException {
        return this.thread.getDbgpSession().getCoreCommands().getStackLevels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFrames() throws DbgpException {
        IDbgpStackLevel[] levels = this.requestStackLevels();
        Object object = this.framesLock;
        synchronized (object) {
            IScriptStackFrame[] newFrames = new IScriptStackFrame[levels.length];
            int i = 0;
            while (i < newFrames.length) {
                newFrames[i] = new ScriptStackFrame((IScriptStack)this, levels[i]);
                ++i;
            }
            this.frames = newFrames;
        }
    }

    public ScriptThread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.getFrames().length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFrames() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.frames == null ? true : this.frames.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptStackFrame[] getFrames() {
        Object object = this.framesLock;
        synchronized (object) {
            if (this.frames == null) {
                try {
                    this.readFrames();
                }
                catch (DbgpException e) {
                    Activator.logError("Cannot read stack frames", e);
                }
            }
            return this.frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptStackFrame getTopFrame() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.getFrames()[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFrames() {
        Object object = this.framesLock;
        synchronized (object) {
            int i = 0;
            while (i < this.frames.length) {
                ((ScriptStackFrame)this.frames[i]).updateVariables();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.framesLock;
        synchronized (object) {
            return this.frames != null;
        }
    }
}

