/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.IDbgpFeature;
import org.eclipse.dltk.dbgp.IDbgpNotificationManager;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpRawListener;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpSessionInfo;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.breakpoints.DbgpBreakpointConfig;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.commands.IDbgpContextCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpPropertyCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpStackCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.dltk.dbgp.internal.managers.IDbgpStreamManager;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlEntityParser;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.debug.core.IDebugOptions;
import org.eclipse.koneki.ldt.debug.core.internal.LuaCoroutine;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LuaCoroutineDbgpSession
implements IDbgpSession {
    private static final String COROUTINE_FLAG = "-o";
    private IDbgpSession actualSession;
    private LuaCoroutine coroutine;
    private IDbgpCoreCommands proxyCoreCommands;

    public LuaCoroutineDbgpSession(IDbgpSession actualSession, LuaCoroutine coroutine) {
        this.actualSession = actualSession;
        this.coroutine = coroutine;
        this.proxyCoreCommands = new CoroutineCoreCommands();
    }

    public void bindToCoroutine(LuaCoroutine newCoroutine) {
        this.coroutine = newCoroutine;
    }

    public IDbgpCoreCommands getCoreCommands() {
        return this.proxyCoreCommands;
    }

    public void addTerminationListener(IDbgpTerminationListener listener) {
        this.actualSession.addTerminationListener(listener);
    }

    public IDbgpExtendedCommands getExtendedCommands() {
        return this.actualSession.getExtendedCommands();
    }

    public void removeTerminationListener(IDbgpTerminationListener listener) {
        this.actualSession.removeTerminationListener(listener);
    }

    public Object get(Class type) {
        return this.actualSession.get(type);
    }

    public IDebugOptions getDebugOptions() {
        return this.actualSession.getDebugOptions();
    }

    public void configure(IDebugOptions debugOptions) {
        this.actualSession.configure(debugOptions);
    }

    public void requestTermination() {
        this.actualSession.requestTermination();
    }

    public void waitTerminated() throws InterruptedException {
        this.actualSession.waitTerminated();
    }

    public IDbgpSessionInfo getInfo() {
        return this.actualSession.getInfo();
    }

    public IDbgpStreamManager getStreamManager() {
        return this.actualSession.getStreamManager();
    }

    public IDbgpNotificationManager getNotificationManager() {
        return this.actualSession.getNotificationManager();
    }

    public void addRawListener(IDbgpRawListener listener) {
        this.actualSession.addRawListener(listener);
    }

    public void removeRawListenr(IDbgpRawListener listener) {
        this.actualSession.removeRawListenr(listener);
    }

    public IDbgpCommunicator getCommunicator() {
        return this.actualSession.getCommunicator();
    }

    private class CoroutineContextCommands
    extends DbgpBaseCommands
    implements IDbgpContextCommands {
        private static final String CONTEXT_NAMES_COMMAND = "context_names";
        private static final String CONTEXT_GET = "context_get";
        private static final String TAG_CONTEXT = "context";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_ID = "id";

        public CoroutineContextCommands(IDbgpCommunicator communicator) {
            super(communicator);
        }

        protected Map parseContextNamesResponse(Element response) throws DbgpException {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            NodeList contexts = response.getElementsByTagName(TAG_CONTEXT);
            int i = 0;
            while (i < contexts.getLength()) {
                Element context = (Element)contexts.item(i);
                String name = context.getAttribute(ATTR_NAME);
                Integer id = new Integer(context.getAttribute(ATTR_ID));
                map.put(id, name);
                ++i;
            }
            return map;
        }

        protected IDbgpProperty[] parseContextPropertiesResponse(Element response) throws DbgpException {
            NodeList properties = response.getChildNodes();
            ArrayList<IDbgpProperty> list = new ArrayList<IDbgpProperty>();
            int i = 0;
            while (i < properties.getLength()) {
                Node item = properties.item(i);
                if (item instanceof Element && item.getNodeName().equals("property")) {
                    list.add(DbgpXmlEntityParser.parseProperty((Element)((Element)item)));
                }
                ++i;
            }
            return list.toArray(new IDbgpProperty[list.size()]);
        }

        public Map getContextNames(int stackDepth) throws DbgpException {
            DbgpRequest request = CoroutineContextCommands.createRequest((String)CONTEXT_NAMES_COMMAND);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            request.addOption("-d", stackDepth);
            return this.parseContextNamesResponse(this.communicate(request));
        }

        public IDbgpProperty[] getContextProperties(int stackDepth) throws DbgpException {
            DbgpRequest request = CoroutineContextCommands.createRequest((String)CONTEXT_GET);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            request.addOption("-d", stackDepth);
            return this.parseContextPropertiesResponse(this.communicate(request));
        }

        public IDbgpProperty[] getContextProperties(int stackDepth, int contextId) throws DbgpException {
            DbgpRequest request = CoroutineContextCommands.createRequest((String)CONTEXT_GET);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            request.addOption("-d", stackDepth);
            request.addOption("-c", contextId);
            return this.parseContextPropertiesResponse(this.communicate(request));
        }
    }

    private class CoroutineCoreCommands
    implements IDbgpCoreCommands {
        private IDbgpCoreCommands actualCoreCommands;
        private IDbgpStackCommands proxiedStackCommands;
        private IDbgpContextCommands proxiedContextCommands;
        private IDbgpPropertyCommands proxiedPropertyCommands;

        public CoroutineCoreCommands() {
            this.actualCoreCommands = LuaCoroutineDbgpSession.this.actualSession.getCoreCommands();
            this.proxiedStackCommands = new CoroutineStackCommands(LuaCoroutineDbgpSession.this.getCommunicator());
            this.proxiedContextCommands = new CoroutineContextCommands(LuaCoroutineDbgpSession.this.getCommunicator());
            this.proxiedPropertyCommands = new CoroutinePropertyCommands(LuaCoroutineDbgpSession.this.getCommunicator());
        }

        public String getSource(URI uri) throws DbgpException {
            return this.actualCoreCommands.getSource(uri);
        }

        public IDbgpStatus getStatus() throws DbgpException {
            return this.actualCoreCommands.getStatus();
        }

        public IDbgpStatus run() throws DbgpException {
            return this.actualCoreCommands.run();
        }

        public String getSource(URI uri, int beginLine) throws DbgpException {
            return this.actualCoreCommands.getSource(uri, beginLine);
        }

        public boolean configureStdout(int value) throws DbgpException {
            return this.actualCoreCommands.configureStdout(value);
        }

        public boolean configureStderr(int value) throws DbgpException {
            return this.actualCoreCommands.configureStderr(value);
        }

        public String getSource(URI uri, int beginLine, int endLine) throws DbgpException {
            return this.actualCoreCommands.getSource(uri, beginLine, endLine);
        }

        public String setLineBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig config) throws DbgpException {
            return this.actualCoreCommands.setLineBreakpoint(uri, lineNumber, config);
        }

        public IDbgpStatus stepInto() throws DbgpException {
            return this.actualCoreCommands.stepInto();
        }

        public Map getTypeMap() throws DbgpException {
            return this.actualCoreCommands.getTypeMap();
        }

        public String setCallBreakpoint(URI uri, String function, DbgpBreakpointConfig config) throws DbgpException {
            return this.actualCoreCommands.setCallBreakpoint(uri, function, config);
        }

        public IDbgpStatus stepOver() throws DbgpException {
            return this.actualCoreCommands.stepOver();
        }

        public String setReturnBreakpoint(URI uri, String function, DbgpBreakpointConfig config) throws DbgpException {
            return this.actualCoreCommands.setReturnBreakpoint(uri, function, config);
        }

        public String setExceptionBreakpoint(String exception, DbgpBreakpointConfig config) throws DbgpException {
            return this.actualCoreCommands.setExceptionBreakpoint(exception, config);
        }

        public String setConditionalBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig config) throws DbgpException {
            return this.actualCoreCommands.setConditionalBreakpoint(uri, lineNumber, config);
        }

        public IDbgpStatus stepOut() throws DbgpException {
            return this.actualCoreCommands.stepOut();
        }

        public String setConditionalBreakpoint(URI uri, DbgpBreakpointConfig config) throws DbgpException {
            return this.actualCoreCommands.setConditionalBreakpoint(uri, config);
        }

        public IDbgpStatus stop() throws DbgpException {
            return this.actualCoreCommands.stop();
        }

        public String setWatchBreakpoint(URI uri, int line, DbgpBreakpointConfig config) throws DbgpException {
            return this.actualCoreCommands.setWatchBreakpoint(uri, line, config);
        }

        public void removeBreakpoint(String id) throws DbgpException {
            this.actualCoreCommands.removeBreakpoint(id);
        }

        public void updateBreakpoint(String id, DbgpBreakpointConfig config) throws DbgpException {
            this.actualCoreCommands.updateBreakpoint(id, config);
        }

        public IDbgpBreakpoint getBreakpoint(String id) throws DbgpException {
            return this.actualCoreCommands.getBreakpoint(id);
        }

        public IDbgpStatus detach() throws DbgpException {
            return this.actualCoreCommands.detach();
        }

        public IDbgpBreakpoint[] getBreakpoints() throws DbgpException {
            return this.actualCoreCommands.getBreakpoints();
        }

        public IDbgpFeature getFeature(String featureName) throws DbgpException {
            return this.actualCoreCommands.getFeature(featureName);
        }

        public boolean setFeature(String featureName, String featureValue) throws DbgpException {
            return this.actualCoreCommands.setFeature(featureName, featureValue);
        }

        public int getStackDepth() throws DbgpException {
            return this.proxiedStackCommands.getStackDepth();
        }

        public IDbgpStackLevel[] getStackLevels() throws DbgpException {
            return this.proxiedStackCommands.getStackLevels();
        }

        public IDbgpStackLevel getStackLevel(int stackDepth) throws DbgpException {
            return this.proxiedStackCommands.getStackLevel(stackDepth);
        }

        public Map getContextNames(int stackDepth) throws DbgpException {
            return this.proxiedContextCommands.getContextNames(stackDepth);
        }

        public IDbgpProperty[] getContextProperties(int stackDepth) throws DbgpException {
            return this.proxiedContextCommands.getContextProperties(stackDepth);
        }

        public IDbgpProperty[] getContextProperties(int stackDepth, int contextId) throws DbgpException {
            return this.proxiedContextCommands.getContextProperties(stackDepth, contextId);
        }

        public IDbgpProperty getPropertyByKey(String name, String key) throws DbgpException {
            return this.proxiedPropertyCommands.getPropertyByKey(name, key);
        }

        public IDbgpProperty getProperty(String name) throws DbgpException {
            return this.proxiedPropertyCommands.getProperty(name);
        }

        public IDbgpProperty getProperty(String name, int stackDepth) throws DbgpException {
            return this.proxiedPropertyCommands.getProperty(name, stackDepth);
        }

        public IDbgpProperty getProperty(String name, int stackDepth, int contextId) throws DbgpException {
            return this.proxiedPropertyCommands.getProperty(name, stackDepth, contextId);
        }

        public IDbgpProperty getProperty(int page, String name, int stackDepth) throws DbgpException {
            return this.proxiedPropertyCommands.getProperty(page, name, stackDepth);
        }

        public boolean setProperty(IDbgpProperty property) throws DbgpException {
            return this.proxiedPropertyCommands.setProperty(property);
        }

        public boolean setProperty(String name, int stackDepth, String value) throws DbgpException {
            return this.proxiedPropertyCommands.setProperty(name, stackDepth, value);
        }
    }

    private class CoroutinePropertyCommands
    extends DbgpBaseCommands
    implements IDbgpPropertyCommands {
        private static final String PROPERTY_GET_COMMAND = "property_get";
        private static final String PROPERTY_SET_COMMAND = "property_set";

        public CoroutinePropertyCommands(IDbgpCommunicator communicator) {
            super(communicator);
        }

        protected IDbgpProperty parsePropertyResponse(Element response) throws DbgpException {
            NodeList properties = response.getElementsByTagName("property");
            return DbgpXmlEntityParser.parseProperty((Element)((Element)properties.item(0)));
        }

        protected IDbgpProperty getProperty(Integer page, String name, Integer stackDepth, Integer contextId) throws DbgpException {
            DbgpRequest request = CoroutinePropertyCommands.createRequest((String)PROPERTY_GET_COMMAND);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            request.addOption("-n", (Object)name);
            if (stackDepth != null) {
                request.addOption("-d", (Object)stackDepth);
            }
            if (contextId != null) {
                request.addOption("-c", (Object)contextId);
            }
            if (page != null) {
                request.addOption("-p", (Object)page);
            }
            return this.parsePropertyResponse(this.communicate(request));
        }

        public IDbgpProperty getPropertyByKey(String name, String key) throws DbgpException {
            DbgpRequest request = CoroutinePropertyCommands.createRequest((String)PROPERTY_GET_COMMAND);
            request.addOption("-n", (Object)name);
            request.addOption("-k", (Object)key);
            return this.parsePropertyResponse(this.communicate(request));
        }

        public IDbgpProperty getProperty(String name) throws DbgpException {
            return this.getProperty(null, name, null, null);
        }

        public IDbgpProperty getProperty(String name, int stackDepth) throws DbgpException {
            return this.getProperty(null, name, stackDepth, null);
        }

        public IDbgpProperty getProperty(String name, int stackDepth, int contextId) throws DbgpException {
            return this.getProperty(null, name, stackDepth, contextId);
        }

        public IDbgpProperty getProperty(int page, String name, int stackDepth) throws DbgpException {
            return this.getProperty(page, name, stackDepth, null);
        }

        public boolean setProperty(IDbgpProperty property) throws DbgpException {
            DbgpRequest request = CoroutinePropertyCommands.createRequest((String)PROPERTY_SET_COMMAND);
            request.addOption("-n", (Object)property.getName());
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            request.setData(property.getValue());
            return DbgpXmlParser.parseSuccess((Element)this.communicate(request));
        }

        public boolean setProperty(String name, int stackDepth, String value) throws DbgpException {
            DbgpRequest request = CoroutinePropertyCommands.createRequest((String)PROPERTY_SET_COMMAND);
            request.addOption("-n", (Object)name);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            request.addOption("-d", stackDepth);
            request.setData(value);
            return DbgpXmlParser.parseSuccess((Element)this.communicate(request));
        }
    }

    private class CoroutineStackCommands
    extends DbgpBaseCommands
    implements IDbgpStackCommands {
        private static final String STACK_DEPTH_COMMAND = "stack_depth";
        private static final String STACK_GET_COMMAND = "stack_get";
        private static final String TAG_STACK = "stack";
        private static final String ATTR_DEPTH = "depth";
        private final Comparator levelComparator;

        public CoroutineStackCommands(IDbgpCommunicator communicator) {
            super(communicator);
            this.levelComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    IDbgpStackLevel level1 = (IDbgpStackLevel)o1;
                    IDbgpStackLevel level2 = (IDbgpStackLevel)o2;
                    return level1.getLevel() - level2.getLevel();
                }
            };
        }

        protected int parseStackDepthResponse(Element response) throws DbgpDebuggingEngineException {
            return Integer.parseInt(response.getAttribute(ATTR_DEPTH));
        }

        protected IDbgpStackLevel[] parseStackLevels(Element response) throws DbgpException {
            NodeList nodes = response.getElementsByTagName(TAG_STACK);
            IDbgpStackLevel[] list = new IDbgpStackLevel[nodes.getLength()];
            int i = 0;
            while (i < nodes.getLength()) {
                Element level = (Element)nodes.item(i);
                list[i] = DbgpXmlEntityParser.parseStackLevel((Element)level);
                ++i;
            }
            Arrays.sort(list, this.levelComparator);
            return list;
        }

        public int getStackDepth() throws DbgpException {
            DbgpRequest request = CoroutineStackCommands.createRequest((String)STACK_DEPTH_COMMAND);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            return this.parseStackDepthResponse(this.communicate(request));
        }

        public IDbgpStackLevel[] getStackLevels() throws DbgpException {
            DbgpRequest request = CoroutineStackCommands.createRequest((String)STACK_GET_COMMAND);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            return this.parseStackLevels(this.communicate(request));
        }

        public IDbgpStackLevel getStackLevel(int stackDepth) throws DbgpException {
            DbgpRequest request = CoroutineStackCommands.createRequest((String)STACK_GET_COMMAND);
            request.addOption("-d", stackDepth);
            request.addOption(LuaCoroutineDbgpSession.COROUTINE_FLAG, (Object)LuaCoroutineDbgpSession.this.coroutine.getCoroutineId());
            IDbgpStackLevel[] levels = this.parseStackLevels(this.communicate(request));
            return levels.length == 1 ? levels[0] : null;
        }
    }
}

