/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.part.MultiEditorInput;

public class CompatibilityEditor
extends CompatibilityPart {
    public static final String MODEL_ELEMENT_ID = "org.eclipse.e4.ui.compatibility.editor";
    private EditorReference reference;
    @Inject
    private EModelService modelService;

    @Inject
    CompatibilityEditor(MPart part, EditorReference ref) {
        super(part);
        this.reference = ref;
        if (!part.getTags().contains("removeOnHide")) {
            part.getTags().add("removeOnHide");
        }
    }

    IWorkbenchPart createPart(WorkbenchPartReference reference) throws PartInitException {
        IWorkbenchPart part = super.createPart(reference);
        IEditorInput input = ((EditorReference)reference).getEditorInput();
        if (input instanceof MultiEditorInput && part instanceof MultiEditor) {
            this.createMultiEditorChildren(part, input);
        }
        return part;
    }

    private void createMultiEditorChildren(IWorkbenchPart part, IEditorInput input) throws PartInitException {
        IWorkbenchPage page = this.reference.getPage();
        MPart model = this.getModel();
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)model);
        IEditorRegistry registry = (IEditorRegistry)model.getContext().get(IEditorRegistry.class);
        MultiEditorInput multiEditorInput = (MultiEditorInput)input;
        IEditorInput[] inputs = multiEditorInput.getInput();
        String[] editorIds = multiEditorInput.getEditors();
        IEditorPart[] editors = new IEditorPart[editorIds.length];
        int i = 0;
        while (i < editorIds.length) {
            EditorDescriptor innerDesc = (EditorDescriptor)registry.findEditor(editorIds[i]);
            if (innerDesc == null) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_unknownEditorIDMessage, (Object)editorIds[i]));
            }
            EditorReference innerReference = new EditorReference(window.getContext(), page, model, inputs[i], innerDesc, null);
            editors[i] = (IEditorPart)innerReference.createPart();
            innerReference.initialize(editors[i]);
            ++i;
        }
        ((AbstractMultiEditor)part).setChildren(editors);
    }

    protected boolean createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        IConfigurationElement element;
        super.createPartControl(legacyPart, parent);
        this.part.getContext().set(IEditorPart.class, (Object)((IEditorPart)legacyPart));
        EditorDescriptor descriptor = this.reference.getDescriptor();
        if (descriptor != null && (element = descriptor.getConfigurationElement()) != null) {
            String iconURI = element.getAttribute("icon");
            if (iconURI != null && !iconURI.startsWith("platform:/plugin/")) {
                StringBuilder builder = new StringBuilder("platform:/plugin/");
                builder.append(element.getContributor().getName()).append('/');
                if (iconURI.startsWith("$nl$")) {
                    iconURI = iconURI.substring(4);
                }
                builder.append(iconURI);
                iconURI = builder.toString();
            }
            this.part.setIconURI(iconURI);
        }
        if (legacyPart instanceof AbstractMultiEditor && !(legacyPart instanceof MultiEditor)) {
            try {
                this.createMultiEditorChildren(legacyPart, this.reference.getEditorInput());
            }
            catch (PartInitException e) {
                this.handlePartInitException(e);
                return false;
            }
        }
        return true;
    }

    public IEditorPart getEditor() {
        return (IEditorPart)this.getPart();
    }

    public WorkbenchPartReference getReference() {
        return this.reference;
    }

    void updateImages(MPart part) {
        this.updateTabImages((MUIElement)part);
    }

    void disposeSite(PartSite site) {
        EditorActionBars bars = (EditorActionBars)site.getActionBars();
        EditorReference.disposeEditorActionBars(bars);
        super.disposeSite(site);
    }
}

