/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.core.identity.Activator;

public abstract class BaseID
implements ID {
    private static final long serialVersionUID = -6242599410460002514L;
    protected Namespace namespace;

    protected BaseID() {
    }

    protected BaseID(Namespace namespace) {
        Assert.isNotNull((Object)namespace, (String)"namespace cannot be null");
        this.namespace = namespace;
    }

    public int compareTo(Object o) {
        Assert.isTrue((o != null && o instanceof BaseID ? 1 : 0) != 0, (String)"incompatible types for compare");
        return this.namespace.getCompareToForObject(this, (BaseID)o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BaseID)) {
            return false;
        }
        return this.namespace.testIDEquals(this, (BaseID)o);
    }

    public String getName() {
        return this.namespace.getNameForID(this);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return this.namespace.getHashCodeForID(this);
    }

    public String toExternalForm() {
        return this.namespace.toExternalForm(this);
    }

    protected abstract int namespaceCompareTo(BaseID var1);

    protected abstract boolean namespaceEquals(BaseID var1);

    protected abstract String namespaceGetName();

    protected abstract int namespaceHashCode();

    protected String namespaceToExternalForm() {
        return String.valueOf(this.namespace.getScheme()) + ":" + this.namespaceGetName();
    }

    public Object getAdapter(Class clazz) {
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, clazz.getName());
    }
}

