/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.core.internal;

import org.eclipse.dltk.debug.core.model.IScriptStackFrame;

public class UnreachableStackFrame {
    public static final String TAIL_RETURN_SCHEME = "tailreturn";
    public static final String CCODE_SCHEME = "ccode";
    public static final String UNKNOWN_SCHEME = "unknown";
    private final IScriptStackFrame frame;
    private final String reason;

    public UnreachableStackFrame(IScriptStackFrame frame, String reason) {
        this.frame = frame;
        this.reason = reason;
    }

    public IScriptStackFrame getFrame() {
        return this.frame;
    }

    public String getReason() {
        return this.reason;
    }

    public static UnreachableStackFrame checkReachable(IScriptStackFrame frame) {
        String scheme = frame.getSourceURI().getScheme();
        if (scheme.equals(TAIL_RETURN_SCHEME)) {
            return new UnreachableStackFrame(frame, TAIL_RETURN_SCHEME);
        }
        if (scheme.equals(CCODE_SCHEME)) {
            return new UnreachableStackFrame(frame, CCODE_SCHEME);
        }
        if (scheme.equals(UNKNOWN_SCHEME)) {
            return new UnreachableStackFrame(frame, UNKNOWN_SCHEME);
        }
        return null;
    }
}

