/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.Member;
import org.eclipse.dltk.internal.core.ModelElement;

public abstract class NamedMember
extends Member {
    protected String name;

    public NamedMember(ModelElement parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    protected IScriptFolder getScriptFolder() {
        return null;
    }

    public String getFullyQualifiedName(String enclosingTypeSeparator, boolean showParameters) throws ModelException {
        INamespace namespace = this.getNamespace();
        if (namespace != null && !namespace.isRoot()) {
            return String.valueOf(namespace.getQualifiedName(enclosingTypeSeparator)) + enclosingTypeSeparator + this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
        }
        return this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
    }

    public String getTypeQualifiedName(String typeSeparator, boolean showParameters) throws ModelException {
        NamedMember declaringType;
        String thisName = this.name;
        if (thisName.startsWith(typeSeparator)) {
            return thisName;
        }
        switch (this.parent.getElementType()) {
            case 5: {
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(thisName);
                    if (DLTKCore.DEBUG) {
                        System.err.println("TODO: NamedMember: add type parameters");
                    }
                    return buffer.toString();
                }
                return thisName;
            }
            case 7: {
                declaringType = (NamedMember)this.parent;
                break;
            }
            case 8: 
            case 9: {
                declaringType = (NamedMember)((Object)((IMember)((Object)this.parent)).getDeclaringType());
                break;
            }
            default: {
                return null;
            }
        }
        String declTName = "";
        if (declaringType != null) {
            declTName = declaringType.getTypeQualifiedName(typeSeparator, showParameters);
        }
        StringBuffer buffer = new StringBuffer(declTName);
        buffer.append(typeSeparator);
        String simpleName = this.name.length() == 0 ? Integer.toString(this.occurrenceCount) : this.name;
        buffer.append(simpleName);
        if (showParameters && DLTKCore.DEBUG) {
            System.err.println("TODO: NamedMember: Add type parameters.");
        }
        return buffer.toString();
    }

    protected String getKey(IField field, boolean forceOpen) throws ModelException {
        StringBuffer key = new StringBuffer();
        String declaringKey = this.getKey((IType)field.getParent(), forceOpen);
        key.append(declaringKey);
        key.append('.');
        key.append(field.getElementName());
        return key.toString();
    }

    protected String getKey(IMethod method, boolean forceOpen) throws ModelException {
        StringBuffer key = new StringBuffer();
        String declaringKey = this.getKey((IType)method.getParent(), forceOpen);
        key.append(declaringKey);
        key.append('.');
        String selector = method.getElementName();
        key.append(selector);
        key.append('(');
        String[] parameters = method.getParameterNames();
        int i = 0;
        int length = parameters.length;
        while (i < length) {
            key.append(parameters[i].replace('.', '/'));
            ++i;
        }
        key.append(')');
        key.append('V');
        return key.toString();
    }

    protected String getKey(IType type, boolean forceOpen) throws ModelException {
        StringBuffer key = new StringBuffer();
        key.append('L');
        String packageName = type.getScriptFolder().getElementName();
        key.append(packageName.replace('.', '/'));
        if (packageName.length() > 0) {
            key.append('/');
        }
        String typeQualifiedName = type.getTypeQualifiedName("$");
        ISourceModule cu = (ISourceModule)type.getAncestor(5);
        if (cu != null) {
            String topLevelTypeName;
            String cuName = cu.getElementName();
            String mainTypeName = cuName.substring(0, cuName.lastIndexOf(46));
            int end = typeQualifiedName.indexOf(36);
            if (end == -1) {
                end = typeQualifiedName.length();
            }
            if (!mainTypeName.equals(topLevelTypeName = typeQualifiedName.substring(0, end))) {
                key.append(mainTypeName);
                key.append('~');
            }
        }
        key.append(typeQualifiedName);
        key.append(';');
        return key.toString();
    }
}

