/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.workingset;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTocsArray;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.IHelpWorkingSetManager;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetComparator;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WorkingSetManager
implements IHelpWorkingSetManager {
    private static final String WORKING_SET_STATE_FILENAME = "workingsets.xml";
    private static final String UNCATEGORIZED = "Uncategorized";
    private SortedSet<WorkingSet> workingSets = new TreeSet<WorkingSet>(new WorkingSetComparator());
    private AdaptableTocsArray root;
    private Map<String, Set<String>> allCriteriaValues;
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public WorkingSetManager() {
        this.restoreState();
    }

    @Override
    public AdaptableTocsArray getRoot() {
        if (this.root == null) {
            this.root = new AdaptableTocsArray((IToc[])HelpPlugin.getTocManager().getTocs(Platform.getNL()));
        }
        return this.root;
    }

    @Override
    public void addWorkingSet(WorkingSet workingSet) {
        if (workingSet == null || this.workingSets.contains(workingSet)) {
            return;
        }
        this.workingSets.add(workingSet);
        this.saveState();
    }

    @Override
    public WorkingSet createWorkingSet(String name, AdaptableHelpResource[] elements) {
        return new WorkingSet(name, elements);
    }

    @Override
    public WorkingSet createWorkingSet(String name, AdaptableHelpResource[] elements, CriterionResource[] criteria) {
        return new WorkingSet(name, elements, criteria);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WorkingSetManager) {
            WorkingSetManager workingSetManager = (WorkingSetManager)object;
            return workingSetManager.workingSets.equals(this.workingSets);
        }
        return false;
    }

    @Override
    public WorkingSet getWorkingSet(String name) {
        if (name == null || this.workingSets == null) {
            return null;
        }
        for (WorkingSet workingSet : this.workingSets) {
            if (!name.equals(workingSet.getName())) continue;
            return workingSet;
        }
        return null;
    }

    public int hashCode() {
        return this.workingSets.hashCode();
    }

    @Override
    public WorkingSet[] getWorkingSets() {
        return this.workingSets.toArray(new WorkingSet[this.workingSets.size()]);
    }

    private File getWorkingSetStateFile() {
        IPath path = HelpBasePlugin.getDefault().getStateLocation();
        path = path.append(WORKING_SET_STATE_FILENAME);
        return path.toFile();
    }

    @Override
    public void removeWorkingSet(WorkingSet workingSet) {
        this.workingSets.remove(workingSet);
        this.saveState();
    }

    public boolean restoreState() {
        File stateFile = this.getWorkingSetStateFile();
        if (stateFile.exists()) {
            try {
                FileInputStream input = new FileInputStream(stateFile);
                InputStreamReader reader = new InputStreamReader((InputStream)input, "utf-8");
                InputSource inputSource = new InputSource(reader);
                inputSource.setSystemId(stateFile.toString());
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                Document d = parser.parse(inputSource);
                Element rootElement = d.getDocumentElement();
                this.restoreWorkingSetState(rootElement);
                input.close();
                return true;
            }
            catch (ParserConfigurationException pce) {
                HelpPlugin.logError((String)"DocumentBuilder implementation could not be loaded, to restore working set state.", (Throwable)pce);
                return false;
            }
            catch (SAXException se) {
                HelpBasePlugin.logError("Error occurred parsing file " + stateFile.toString() + ", while restoring working set state.", se);
                return false;
            }
            catch (IOException ioe) {
                HelpBasePlugin.logError("Error occurred parsing file " + stateFile.toString() + ", while restoring working set state.", ioe);
                return false;
            }
        }
        return false;
    }

    private void restoreWorkingSetState(Element parent) {
        NodeList workingSets = parent.getChildNodes();
        int i = 0;
        while (i < workingSets.getLength()) {
            WorkingSet workingSet;
            if (workingSets.item(i).getNodeType() == 1 && (workingSet = this.restoreWorkingSet((Element)workingSets.item(i))) != null) {
                this.workingSets.add(workingSet);
            }
            ++i;
        }
    }

    private WorkingSet restoreWorkingSet(Element workingSetNode) {
        String name = workingSetNode.getAttribute("name");
        ArrayList<AdaptableHelpResource> helpResources = new ArrayList<AdaptableHelpResource>();
        NodeList contents = workingSetNode.getElementsByTagName("contents");
        int i = 0;
        while (i < contents.getLength()) {
            Element content = (Element)contents.item(i);
            NodeList items = content.getElementsByTagName("item");
            int j = 0;
            while (j < items.getLength()) {
                Element itemI = (Element)items.item(j);
                String href = itemI.getAttribute("toc");
                if (href != null && href.length() != 0) {
                    AdaptableToc toc;
                    String child_pos = itemI.getAttribute("topic");
                    int pos = -1;
                    if (child_pos != null) {
                        try {
                            pos = Integer.parseInt(child_pos);
                        }
                        catch (Exception exception) {}
                    }
                    if ((toc = this.getAdaptableToc(href)) == null) {
                        return null;
                    }
                    if (pos == -1) {
                        helpResources.add(toc);
                    } else {
                        AdaptableTopic[] topics = (AdaptableTopic[])((AdaptableHelpResource)toc).getChildren();
                        if (pos >= 0 && topics.length > pos) {
                            helpResources.add(topics[pos]);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        AdaptableHelpResource[] elements = new AdaptableHelpResource[helpResources.size()];
        helpResources.toArray(elements);
        ArrayList<CriterionResource> criteriaResource = new ArrayList<CriterionResource>();
        NodeList criteriaContents = workingSetNode.getElementsByTagName("criterion");
        int i2 = 0;
        while (i2 < criteriaContents.getLength()) {
            Element criterion = (Element)criteriaContents.item(i2);
            String criterionName = criterion.getAttribute("name");
            if (name != null && name.length() != 0) {
                NodeList items = criterion.getElementsByTagName("item");
                ArrayList<String> criterionValues = new ArrayList<String>();
                int j = 0;
                while (j < items.getLength()) {
                    String value = ((Element)items.item(j)).getAttribute("value");
                    if (value != null && value.length() != 0) {
                        criterionValues.add(value);
                    }
                    ++j;
                }
                if (criterionValues.size() > 0) {
                    CriterionResource criterionResource = new CriterionResource(criterionName, criterionValues);
                    criteriaResource.add(criterionResource);
                }
            }
            ++i2;
        }
        CriterionResource[] criteria = new CriterionResource[criteriaResource.size()];
        criteriaResource.toArray(criteria);
        WorkingSet ws = this.createWorkingSet(name, elements, criteria);
        return ws;
    }

    public synchronized boolean saveState() {
        File stateFile = null;
        try {
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("workingSets");
            doc.appendChild(rootElement);
            this.saveWorkingSetState(rootElement);
            stateFile = this.getWorkingSetStateFile();
            stateFile.getParentFile().mkdir();
            FileOutputStream stream = new FileOutputStream(stateFile);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            stream.close();
            return true;
        }
        catch (ParserConfigurationException pce) {
            HelpPlugin.logError((String)"DocumentBuilder implementation could not be loaded.", (Throwable)pce);
            return false;
        }
        catch (TransformerException transformerException) {
            HelpPlugin.logError((String)"Problems occurred while saving working sets.");
            return false;
        }
        catch (IOException iOException) {
            stateFile.delete();
            HelpPlugin.logError((String)"Problems occurred while saving working set file.");
            return false;
        }
    }

    private void saveWorkingSetState(Element parent) {
        for (WorkingSet workingSet : this.workingSets) {
            workingSet.saveState(parent);
        }
    }

    @Override
    public void workingSetChanged(WorkingSet changedWorkingSet) {
        this.saveState();
    }

    @Override
    public AdaptableToc getAdaptableToc(String href) {
        return this.getRoot().getAdaptableToc(href);
    }

    @Override
    public AdaptableTopic getAdaptableTopic(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        int len = id.length();
        if (id.charAt(len - 1) == '_') {
            String indexStr = id.substring(id.lastIndexOf(95, len - 2) + 1, len - 1);
            int index = 0;
            try {
                index = Integer.parseInt(indexStr);
            }
            catch (Exception exception) {}
            String tocStr = id.substring(0, id.lastIndexOf(95, len - 2));
            AdaptableToc toc = this.getAdaptableToc(tocStr);
            if (toc == null) {
                return null;
            }
            AdaptableHelpResource[] topics = toc.getChildren();
            if (index < 0 || index >= topics.length) {
                return null;
            }
            return (AdaptableTopic)topics[index];
        }
        return null;
    }

    @Override
    public String getCurrentWorkingSet() {
        return Platform.getPreferencesService().getString("org.eclipse.help.base", "workingSet", "", null);
    }

    @Override
    public void setCurrentWorkingSet(String workingSet) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.put("workingSet", workingSet);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void tocsChanged() {
        this.saveState();
        this.root = null;
        this.workingSets = new TreeSet<WorkingSet>(new WorkingSetComparator());
        this.restoreState();
    }

    @Override
    public boolean isCriteriaScopeEnabled() {
        if (this.allCriteriaValues == null) {
            this.allCriteriaValues = HelpPlugin.getCriteriaManager().getAllCriteriaValues(Platform.getNL());
        }
        return HelpPlugin.getCriteriaManager().isCriteriaEnabled() && !this.allCriteriaValues.isEmpty();
    }

    @Override
    public String[] getCriterionIds() {
        if (this.allCriteriaValues == null) {
            this.allCriteriaValues = HelpPlugin.getCriteriaManager().getAllCriteriaValues(Platform.getNL());
        }
        ArrayList<String> criterionIds = new ArrayList<String>();
        if (this.allCriteriaValues != null) {
            for (String criterion : this.allCriteriaValues.keySet()) {
                if (criterion == null || criterion.length() == 0 || this.getCriterionValueIds(criterion).length == 0) continue;
                criterionIds.add(criterion);
            }
            Collections.sort(criterionIds);
        }
        String[] ids = new String[criterionIds.size()];
        criterionIds.toArray(ids);
        return ids;
    }

    @Override
    public String[] getCriterionValueIds(String criterionName) {
        Set<String> criterionValues;
        if (this.allCriteriaValues == null) {
            this.allCriteriaValues = HelpPlugin.getCriteriaManager().getAllCriteriaValues(Platform.getNL());
        }
        ArrayList<String> valueIds = new ArrayList<String>();
        if (criterionName != null && this.allCriteriaValues != null && (criterionValues = this.allCriteriaValues.get(criterionName)) != null && !criterionValues.isEmpty()) {
            valueIds.addAll(criterionValues);
            Collections.sort(valueIds);
            valueIds.add(UNCATEGORIZED);
        }
        String[] valueIdsArray = new String[valueIds.size()];
        valueIds.toArray(valueIdsArray);
        return valueIdsArray;
    }

    @Override
    public String getCriterionDisplayName(String criterionId) {
        return HelpPlugin.getCriteriaManager().getCriterionDisplayName(criterionId, Platform.getNL());
    }

    @Override
    public String getCriterionValueDisplayName(String criterionId, String criterionValueId) {
        return HelpPlugin.getCriteriaManager().getCriterionValueDisplayName(criterionId, criterionValueId, Platform.getNL());
    }
}

