/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletResponseWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.ResponseStateHandler;
import org.eclipse.equinox.http.servlet.internal.util.Params;

public class DispatchTargets {
    private final ContextController contextController;
    private final EndpointRegistration<?> endpointRegistration;
    private final List<FilterRegistration> matchingFilterRegistrations;
    private final String pathInfo;
    private final Map<String, String[]> parameterMap;
    private final String queryString;
    private final String requestURI;
    private final String servletPath;
    private final String servletName;
    private final String string;

    public DispatchTargets(ContextController contextController, EndpointRegistration<?> endpointRegistration, String servletName, String requestURI, String servletPath, String pathInfo, String queryString) {
        this(contextController, endpointRegistration, Collections.emptyList(), servletName, requestURI, servletPath, pathInfo, queryString);
    }

    public DispatchTargets(ContextController contextController, EndpointRegistration<?> endpointRegistration, List<FilterRegistration> matchingFilterRegistrations, String servletName, String requestURI, String servletPath, String pathInfo, String queryString) {
        this.contextController = contextController;
        this.endpointRegistration = endpointRegistration;
        this.matchingFilterRegistrations = matchingFilterRegistrations;
        this.servletName = servletName;
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.parameterMap = DispatchTargets.queryStringToParameterMap(queryString);
        this.queryString = queryString;
        this.string = String.valueOf(this.getClass().getSimpleName()) + '[' + contextController.getFullContextPath() + requestURI + ", " + endpointRegistration.toString() + ']';
    }

    public boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String path, DispatcherType dispatcherType) throws ServletException, IOException {
        HttpServletRequestWrapperImpl httpRuntimeRequest = HttpServletRequestWrapperImpl.findHttpRuntimeRequest(request);
        boolean pushedState = false;
        try {
            if (httpRuntimeRequest == null) {
                httpRuntimeRequest = new HttpServletRequestWrapperImpl((HttpServletRequest)request, this, dispatcherType);
                request = httpRuntimeRequest;
                response = new HttpServletResponseWrapperImpl((HttpServletResponse)response);
            } else {
                httpRuntimeRequest.push(this, dispatcherType);
                pushedState = true;
            }
            ResponseStateHandler responseStateHandler = new ResponseStateHandler((HttpServletRequest)request, (HttpServletResponse)response, this, dispatcherType);
            responseStateHandler.processRequest();
            if (dispatcherType == DispatcherType.FORWARD && !response.isCommitted()) {
                response.flushBuffer();
                response.getWriter().close();
            }
            return true;
        }
        finally {
            if (pushedState) {
                httpRuntimeRequest.pop();
            } else {
                httpRuntimeRequest.destroy();
            }
        }
    }

    public ContextController getContextController() {
        return this.contextController;
    }

    public List<FilterRegistration> getMatchingFilterRegistrations() {
        return this.matchingFilterRegistrations;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            return null;
        }
        return String.valueOf(this.getContextController().getFullContextPath()) + this.requestURI;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public EndpointRegistration<?> getServletRegistration() {
        return this.endpointRegistration;
    }

    public String toString() {
        return this.string;
    }

    private static Map<String, String[]> queryStringToParameterMap(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return Collections.emptyMap();
        }
        try {
            String[] parameters;
            LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
            String[] stringArray = parameters = queryString.split("&");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                int index = parameter.indexOf(61);
                String name = index > 0 ? URLDecoder.decode(parameter.substring(0, index), "UTF-8") : parameter;
                String[] values = (String[])parameterMap.get(name);
                if (values == null) {
                    values = new String[]{};
                }
                String value = index > 0 && parameter.length() > index + 1 ? URLDecoder.decode(parameter.substring(index + 1), "UTF-8") : null;
                values = Params.append(values, value);
                parameterMap.put(name, values);
                ++n2;
            }
            return Collections.unmodifiableMap(parameterMap);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

