/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        int notebookHandle = theme.notebookHandle;
        int gtkStyle = this.gtk_widget_get_style(notebookHandle);
        int drawable = OS.GTK3 ? gc.getGCData().cairo : gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        height -= this.tabsHeight;
        int gap_x = this.selectedX;
        int gap_width = this.selectedWidth;
        int gap_side = 2;
        if ((this.style & 0x400) != 0) {
            gap_side = 3;
        } else {
            y += this.tabsHeight;
        }
        byte[] detail = Converter.wcsToMbcs(null, "notebook", true);
        this.gtk_render_frame_gap(gtkStyle, drawable, this.getStateType(0), 2, null, notebookHandle, detail, x, y, width, height, gap_side, gap_x, gap_width);
        if (this.tabsArea != null) {
            this.tabsArea.x = bounds.x;
            this.tabsArea.y = bounds.y;
            this.tabsArea.width = bounds.width;
            this.tabsArea.height = this.tabsHeight;
            if ((this.style & 0x400) != 0) {
                this.tabsArea.y += bounds.height - this.tabsHeight;
            }
        }
    }

    int getStateType(int part) {
        return 0;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }

    void gtk_render_frame_gap(int style, int window, int state_type, int shadow_type, GdkRectangle area, int widget, byte[] detail, int x, int y, int width, int height, int gap_side, int gap_x, int gap_width) {
        if (OS.GTK3) {
            OS.gtk_render_frame_gap(style, window, style, y, gap_width, height, gap_side, gap_x, gap_x + gap_width);
        } else {
            OS.gtk_paint_box_gap(style, window, state_type, shadow_type, area, widget, detail, x, y, width, height, gap_side, gap_x, gap_width);
        }
    }
}

