/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.ide.IUnknownEditorStrategy;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class UnknownEditorStrategyRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.ide.unknownEditorStrategy";
    private static Map<String, String> idsToLabel;

    public static IUnknownEditorStrategy getStrategy(String strategyId) {
        if (strategyId == null) {
            return null;
        }
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = extRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (extensions != null) {
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                if (strategyId.equals(UnknownEditorStrategyRegistry.readAttribute(extension, "id"))) {
                    try {
                        return (IUnknownEditorStrategy)extension.createExecutableExtension("class");
                    }
                    catch (CoreException ex) {
                        IDEWorkbenchPlugin.log(ex.getMessage(), ex);
                        return null;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private static String readAttribute(IConfigurationElement extension, String attribute) {
        String res = extension.getAttribute(attribute);
        if (res == null) {
            IDEWorkbenchPlugin.log("Missing attribute '" + attribute + "' for extension to " + EXTENSION_POINT_ID + " contributed by " + extension.getContributor());
        }
        return res;
    }

    public static Set<String> retrieveAllStrategies() {
        UnknownEditorStrategyRegistry.populateIdsToLabel();
        return Collections.unmodifiableSet(idsToLabel.keySet());
    }

    public static String getLabel(String id) {
        if (idsToLabel == null || !idsToLabel.containsKey(id)) {
            UnknownEditorStrategyRegistry.populateIdsToLabel();
        }
        return idsToLabel.get(id);
    }

    private static void populateIdsToLabel() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = extRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (extensions != null) {
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                String extId = UnknownEditorStrategyRegistry.readAttribute(extension, "id");
                String label = UnknownEditorStrategyRegistry.readAttribute(extension, "label");
                if (extId != null && label != null) {
                    res.put(extId, label);
                }
                ++n2;
            }
        }
        idsToLabel = res;
    }
}

