/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class TextEditorDefaultsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[][] fAppearanceColorListModel;
    private OverlayPreferenceStore fOverlayStore;
    private org.eclipse.swt.widgets.List fAppearanceColorList;
    private ColorSelector fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private boolean fFieldsInitialized;
    private ArrayList<SelectionListener> fMasterSlaveListeners;
    private List<Initializer> fInitializers;
    private InitializerFactory fInitializerFactory;
    private Map<Domain, Text> fDomains;

    public TextEditorDefaultsPreferencePage() {
        String[][] stringArrayArray = new String[9][];
        String[] stringArray = new String[3];
        stringArray[0] = TextEditorMessages.TextEditorPreferencePage_lineNumberForegroundColor;
        stringArray[1] = "lineNumberColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = TextEditorMessages.TextEditorPreferencePage_currentLineHighlighColor;
        stringArray2[1] = "currentLineColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = TextEditorMessages.TextEditorPreferencePage_printMarginColor;
        stringArray3[1] = "printMarginColor";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = TextEditorMessages.TextEditorPreferencePage_findScopeColor;
        stringArray4[1] = "AbstractTextEditor.Color.FindScope";
        stringArrayArray[3] = stringArray4;
        stringArrayArray[4] = new String[]{TextEditorMessages.TextEditorPreferencePage_selectionForegroundColor, "AbstractTextEditor.Color.SelectionForeground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault"};
        stringArrayArray[5] = new String[]{TextEditorMessages.TextEditorPreferencePage_selectionBackgroundColor, "AbstractTextEditor.Color.SelectionBackground", "AbstractTextEditor.Color.SelectionBackground.SystemDefault"};
        stringArrayArray[6] = new String[]{TextEditorMessages.TextEditorPreferencePage_backgroundColor, "AbstractTextEditor.Color.Background", "AbstractTextEditor.Color.Background.SystemDefault"};
        stringArrayArray[7] = new String[]{TextEditorMessages.TextEditorPreferencePage_foregroundColor, "AbstractTextEditor.Color.Foreground", "AbstractTextEditor.Color.Foreground.SystemDefault"};
        stringArrayArray[8] = new String[]{TextEditorMessages.HyperlinkColor_label, "hyperlinkColor", "hyperlinkColor.SystemDefault"};
        this.fAppearanceColorListModel = stringArrayArray;
        this.fFieldsInitialized = false;
        this.fMasterSlaveListeners = new ArrayList();
        this.fInitializers = new ArrayList<Initializer>();
        this.fDomains = new HashMap<Domain, Text>();
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
        this.fInitializerFactory = new InitializerFactory(this.fOverlayStore);
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.FindScope"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "tabWidth"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wordwrap.enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spacesForTabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "undoHistorySize"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionForeground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionForeground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionBackground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionBackground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Foreground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "hyperlinksEnabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hyperlinkColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "hyperlinkColor.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hyperlinkKeyModifier"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "hyperlinkKeyModifierMask"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showWhitespaceCharacters"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "show_range_indicator"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "warn_if_input_derived"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "textDragAndDropEnabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTextHoverAffordance"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "hoverReplaceMode"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingSpaces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedSpaces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingSpaces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingIdeographicSpaces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedIdeographicSpaces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingIdeographicSpaces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingTabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedTabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingTabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showCarriageReturn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLineFeed"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "whitespaceCharacterAlphaValue"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.text_editor_preference_page_context");
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        if (i == -1) {
            return;
        }
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.fOverlayStore.getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        appearanceComposite.setLayout((Layout)layout);
        Link fontLink = new Link(appearanceComposite, 0);
        fontLink.setText(TextEditorMessages.TextEditorPreferencePage_Font_link);
        fontLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)TextEditorDefaultsPreferencePage.this.getShell(), (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", null, (Object)"selectFont:org.eclipse.jface.textfont");
            }
        });
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        fontLink.setLayoutData((Object)gd);
        this.addFiller(appearanceComposite, 2);
        String label = TextEditorMessages.TextEditorPreferencePage_undoHistorySize;
        Preference undoHistorySize = new Preference("undoHistorySize", label, null);
        IntegerDomain undoHistorySizeDomain = new IntegerDomain(0, 99999);
        this.addTextField(appearanceComposite, undoHistorySize, undoHistorySizeDomain, 15, 0);
        label = TextEditorMessages.TextEditorPreferencePage_displayedTabWidth;
        Preference tabWidth = new Preference("tabWidth", label, null);
        IntegerDomain tabWidthDomain = new IntegerDomain(1, 16);
        this.addTextField(appearanceComposite, tabWidth, tabWidthDomain, 15, 0);
        label = TextEditorMessages.TextEditorPreferencePage_enableWordWrap;
        Preference enableWordWrap = new Preference("wordwrap.enabled", label, null);
        this.addCheckBox(appearanceComposite, enableWordWrap, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorPreferencePage_convertTabsToSpaces;
        Preference spacesForTabs = new Preference("spacesForTabs", label, null);
        this.addCheckBox(appearanceComposite, spacesForTabs, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorPreferencePage_highlightCurrentLine;
        Preference highlightCurrentLine = new Preference("currentLine", label, null);
        this.addCheckBox(appearanceComposite, highlightCurrentLine, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorPreferencePage_showPrintMargin;
        Preference showPrintMargin = new Preference("printMargin", label, null);
        Button showPrintMarginButton = this.addCheckBox(appearanceComposite, showPrintMargin, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorPreferencePage_printMarginColumn;
        Preference printMarginColumn = new Preference("printMarginColumn", label, null);
        final IntegerDomain printMarginDomain = new IntegerDomain(20, 200);
        Control[] printMarginControls = this.addTextField(appearanceComposite, printMarginColumn, printMarginDomain, 15, 20);
        this.createDependency(showPrintMarginButton, showPrintMargin, printMarginControls);
        showPrintMarginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditorDefaultsPreferencePage.this.updateStatus(printMarginDomain);
            }
        });
        label = TextEditorMessages.TextEditorPreferencePage_showLineNumbers;
        Preference showLineNumbers = new Preference("lineNumberRuler", label, null);
        this.addCheckBox(appearanceComposite, showLineNumbers, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorDefaultsPreferencePage_range_indicator;
        Preference showMagnet = new Preference("show_range_indicator", label, null);
        this.addCheckBox(appearanceComposite, showMagnet, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharacters;
        String linkText = TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharactersLinkText;
        Preference showWhitespaceCharacters = new Preference("showWhitespaceCharacters", label, null);
        this.addCheckBoxWithLink(appearanceComposite, showWhitespaceCharacters, linkText, new BooleanDomain(), 0, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WhitespaceCharacterPainterOptionsDialog dialog = new WhitespaceCharacterPainterOptionsDialog(Display.getDefault().getActiveShell(), TextEditorDefaultsPreferencePage.this.fOverlayStore);
                dialog.open();
            }
        });
        label = TextEditorMessages.TextEditorPreferencePage_showAffordance;
        Preference showAffordance = new Preference("showTextHoverAffordance", label, null);
        this.addCheckBox(appearanceComposite, showAffordance, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHoverMode;
        Preference hoverReplace = new Preference("hoverReplaceMode", label, null);
        EnumeratedDomain hoverReplaceDomain = new EnumeratedDomain();
        hoverReplaceDomain.addValue(new EnumeratedDomain.EnumValue(-1, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_disabled));
        hoverReplaceDomain.addValue(new EnumeratedDomain.EnumValue(1, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_immediately));
        hoverReplaceDomain.addValue(new EnumeratedDomain.EnumValue(0, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_afterDelay));
        hoverReplaceDomain.addValue(new EnumeratedDomain.EnumValue(2, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_onClick));
        this.addCombo(appearanceComposite, hoverReplace, hoverReplaceDomain, 0);
        label = TextEditorMessages.TextEditorDefaultsPreferencePage_textDragAndDrop;
        Preference textDragAndDrop = new Preference("textDragAndDropEnabled", label, null);
        this.addCheckBox(appearanceComposite, textDragAndDrop, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorDefaultsPreferencePage_warn_if_derived;
        Preference warnIfDerived = new Preference("warn_if_input_derived", label, null);
        this.addCheckBox(appearanceComposite, warnIfDerived, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorDefaultsPreferencePage_smartHomeEnd;
        Preference smartHomeEnd = new Preference("AbstractTextEditor.Navigation.SmartHomeEnd", label, null);
        this.addCheckBox(appearanceComposite, smartHomeEnd, new BooleanDomain(), 0);
        this.addFiller(appearanceComposite, 2);
        Label l = new Label(appearanceComposite, 16384);
        l.setText(TextEditorMessages.TextEditorPreferencePage_appearanceOptions);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new org.eclipse.swt.widgets.List(editorComposite, 2564);
        gd = new GridData(1810);
        gd.heightHint = this.fAppearanceColorList.getItemHeight() * 8;
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(TextEditorMessages.TextEditorPreferencePage_color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = TextEditorDefaultsPreferencePage.this.fAppearanceColorDefault.getSelection();
                TextEditorDefaultsPreferencePage.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = TextEditorDefaultsPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = TextEditorDefaultsPreferencePage.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText(TextEditorMessages.TextEditorPreferencePage_systemDefault);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextEditorDefaultsPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TextEditorDefaultsPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = TextEditorDefaultsPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)TextEditorDefaultsPreferencePage.this.fOverlayStore, (String)key, (RGB)TextEditorDefaultsPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        Link link = new Link(appearanceComposite, 0);
        link.setText(TextEditorMessages.TextEditorPreferencePage_colorsAndFonts_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)TextEditorDefaultsPreferencePage.this.getShell(), (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", null, (Object)"selectCategory:org.eclipse.ui.workbenchMisc");
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(appearanceComposite, 2);
        appearanceComposite.layout();
        return appearanceComposite;
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control control = this.createAppearancePage(parent);
        this.initialize();
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TextEditorDefaultsPreferencePage.this.fAppearanceColorList != null && !TextEditorDefaultsPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    TextEditorDefaultsPreferencePage.this.fAppearanceColorList.select(0);
                    TextEditorDefaultsPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        for (Initializer initializer : this.fInitializers) {
            initializer.initialize();
        }
        this.fFieldsInitialized = true;
        this.updateStatus(new StatusInfo());
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
    }

    private void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionBackground")) {
            rgb = this.getControl().getDisplay().getSystemColor(26).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionForeground")) {
            rgb = this.getControl().getDisplay().getSystemColor(27).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Foreground")) {
            rgb = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Background")) {
            rgb = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private void checkboxControlChanged(Preference preference, Domain domain, Button checkBox) {
        boolean value = checkBox.getSelection();
        IStatus status = domain.validate(value);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue(preference.getKey(), value);
        }
        this.updateStatus(status);
    }

    Button addCheckBox(Composite composite, final Preference preference, final Domain domain, int indentation) {
        final Button checkBox = new Button(composite, 32);
        checkBox.setText(preference.getName());
        checkBox.setToolTipText(preference.getDescription());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditorDefaultsPreferencePage.this.checkboxControlChanged(preference, domain, checkBox);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, checkBox));
        return checkBox;
    }

    private Button addCheckBoxWithLink(Composite parent, final Preference preference, String linkText, final Domain domain, int indentation, final SelectionListener listener) {
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indentation;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        final Button checkBox = new Button(composite, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(preference.getName());
        gd = new GridData(4, 2, false, false);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditorDefaultsPreferencePage.this.checkboxControlChanged(preference, domain, checkBox);
            }
        });
        gd = new GridData(4, 2, false, false);
        Link link = new Link(composite, 0);
        link.setText(linkText);
        link.setLayoutData((Object)gd);
        if (listener != null) {
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    listener.widgetSelected(e);
                }
            });
        }
        this.fInitializers.add(this.fInitializerFactory.create(preference, checkBox));
        return checkBox;
    }

    Control[] addCombo(Composite composite, final Preference preference, final EnumeratedDomain domain, int indentation) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(preference.getName());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        final Combo combo = new Combo(composite, 12);
        gd = new GridData(32);
        combo.setLayoutData((Object)gd);
        combo.setToolTipText(preference.getDescription());
        for (EnumeratedDomain.EnumValue value : domain.fItems) {
            combo.add(value.getLabel());
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                EnumeratedDomain.EnumValue value = domain.getValueByIndex(index);
                IStatus status = domain.validate(value);
                if (!status.matches(4)) {
                    TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(preference.getKey(), value.getIntValue());
                }
                TextEditorDefaultsPreferencePage.this.updateStatus(status);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, combo, domain));
        return new Control[]{labelControl, combo};
    }

    Control[] addSpinner(Composite composite, final Preference preference, final EnumeratedDomain domain, int indentation) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(preference.getName());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        final Spinner spinner = new Spinner(composite, 2056);
        gd = new GridData(32);
        spinner.setLayoutData((Object)gd);
        spinner.setToolTipText(preference.getDescription());
        spinner.setMinimum(domain.getMinimumValue().getIntValue());
        spinner.setMaximum(domain.getMaximumValue().getIntValue());
        spinner.setIncrement(1);
        spinner.setPageIncrement(4);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = spinner.getSelection();
                EnumeratedDomain.EnumValue value = domain.getValueByInteger(index);
                IStatus status = domain.validate(value);
                if (!status.matches(4)) {
                    TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(preference.getKey(), value.getIntValue());
                }
                TextEditorDefaultsPreferencePage.this.updateStatus(status);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, spinner, domain));
        return new Control[]{labelControl, spinner};
    }

    private Control[] addTextField(Composite composite, final Preference preference, final Domain domain, int textLimit, int indentation) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(preference.getName());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        final Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.setToolTipText(preference.getDescription());
        if (domain != null) {
            textControl.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String value = textControl.getText();
                    IStatus status = domain.validate(value);
                    if (!status.matches(4)) {
                        TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(preference.getKey(), value);
                    }
                    TextEditorDefaultsPreferencePage.this.updateStatus(domain);
                }
            });
        }
        this.fInitializers.add(this.fInitializerFactory.create(preference, textControl));
        this.fDomains.put(domain, textControl);
        return new Control[]{labelControl, textControl};
    }

    private void createDependency(final Button master, Preference preference, final Control[] slaves) {
        TextEditorDefaultsPreferencePage.indent(slaves[0]);
        boolean masterState = this.fOverlayStore.getBoolean(preference.getKey());
        int i = 0;
        while (i < slaves.length) {
            slaves[i].setEnabled(masterState);
            ++i;
        }
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = master.getSelection();
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(state);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    void updateStatus(IStatus status) {
        if (!this.fFieldsInitialized) {
            return;
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    void updateStatus(Domain checkedDomain) {
        if (!this.fFieldsInitialized) {
            return;
        }
        if (this.updateStatusOnError(checkedDomain)) {
            return;
        }
        for (Domain domain : this.fDomains.keySet()) {
            if (domain.equals(checkedDomain) || !this.updateStatusOnError(domain)) continue;
            return;
        }
        this.updateStatus(new StatusInfo());
    }

    private boolean updateStatusOnError(Domain domain) {
        IStatus status;
        Text textWidget = this.fDomains.get(domain);
        if (textWidget.isEnabled() && (status = domain.validate(textWidget.getText())).matches(4)) {
            this.updateStatus(status);
            return true;
        }
        return false;
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    static class BooleanDomain
    extends Domain {
        BooleanDomain() {
        }

        @Override
        public IStatus validate(Object value) {
            StatusInfo status = new StatusInfo();
            if (value instanceof String && ((String)value).length() == 0) {
                status.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return status;
            }
            try {
                this.parseBoolean(value);
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
            }
            return status;
        }

        private boolean parseBoolean(Object value) throws NumberFormatException {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                if (Boolean.TRUE.toString().equalsIgnoreCase((String)value)) {
                    return true;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase((String)value)) {
                    return false;
                }
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
        }
    }

    static abstract class Domain {
        Domain() {
        }

        public abstract IStatus validate(Object var1);

        protected int parseInteger(Object val) throws NumberFormatException {
            if (val instanceof Integer) {
                return (Integer)val;
            }
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(val)));
        }
    }

    static class EnumeratedDomain
    extends Domain {
        private final List<EnumValue> fItems = new ArrayList<EnumValue>();
        private final Set<EnumValue> fValueSet = new HashSet<EnumValue>();

        EnumeratedDomain() {
        }

        public void addValue(EnumValue val) {
            if (this.fValueSet.contains(val)) {
                this.fItems.remove(val);
            }
            this.fItems.add(val);
            this.fValueSet.add(val);
        }

        public int getIndex(EnumValue enumValue) {
            int i = 0;
            for (EnumValue ev : this.fItems) {
                if (ev.equals(enumValue)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public EnumValue getValueByIndex(int index) {
            if (index >= 0 && this.fItems.size() > index) {
                return this.fItems.get(index);
            }
            return null;
        }

        public EnumValue getValueByInteger(int intValue) {
            for (EnumValue e : this.fItems) {
                if (e.getIntValue() != intValue) continue;
                return e;
            }
            return null;
        }

        public void addValue(int val) {
            this.addValue(new EnumValue(val));
        }

        public void addRange(int from, int to) {
            while (from <= to) {
                this.addValue(from++);
            }
        }

        @Override
        public IStatus validate(Object value) {
            StatusInfo status = new StatusInfo();
            if (value instanceof String && ((String)value).length() == 0) {
                status.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return status;
            }
            try {
                EnumValue e = this.parseEnumValue(value);
                if (!this.fValueSet.contains(e)) {
                    status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidRange, new String[]{this.getValueByIndex(0).getLabel(), this.getValueByIndex(this.fItems.size() - 1).getLabel()}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
            }
            return status;
        }

        private EnumValue parseEnumValue(Object value) {
            if (value instanceof EnumValue) {
                return (EnumValue)value;
            }
            int integer = this.parseInteger(value);
            return this.getValueByInteger(integer);
        }

        public EnumValue getMinimumValue() {
            return this.getValueByIndex(0);
        }

        public EnumValue getMaximumValue() {
            return this.getValueByIndex(this.fItems.size() - 1);
        }

        public static final class EnumValue {
            private final int fValue;
            private final String fName;

            public EnumValue(int value) {
                this(value, null);
            }

            public EnumValue(int value, String name) {
                this.fValue = value;
                this.fName = name;
            }

            public String getLabel() {
                return this.fName == null ? String.valueOf(this.fValue) : this.fName;
            }

            public int getIntValue() {
                return this.fValue;
            }

            public final int hashCode() {
                return this.getIntValue();
            }

            public boolean equals(Object obj) {
                if (obj instanceof EnumValue) {
                    return ((EnumValue)obj).getIntValue() == this.fValue;
                }
                return false;
            }
        }
    }

    private static abstract class Initializer {
        protected final Preference fPreference;

        protected Initializer(Preference preference) {
            this.fPreference = preference;
        }

        public abstract void initialize();
    }

    public static final class InitializerFactory {
        private final IPreferenceStore fPreferenceStore;

        public InitializerFactory(IPreferenceStore preferenceStore) {
            this.fPreferenceStore = preferenceStore;
        }

        public Initializer create(Preference preference, Text control) {
            return new TextInitializer(preference, control);
        }

        public Initializer create(Preference preference, Button control) {
            return new CheckboxInitializer(preference, control);
        }

        public Initializer create(Preference preference, Combo control, EnumeratedDomain domain) {
            return new ComboInitializer(preference, control, domain);
        }

        public Initializer create(Preference preference, Spinner control, EnumeratedDomain domain) {
            return new SpinnerInitializer(preference, control, domain);
        }

        private class CheckboxInitializer
        extends Initializer {
            private final Button fControl;

            public CheckboxInitializer(Preference preference, Button control) {
                super(preference);
                this.fControl = control;
            }

            @Override
            public void initialize() {
                boolean value = InitializerFactory.this.fPreferenceStore.getBoolean(this.fPreference.getKey());
                this.fControl.setSelection(value);
            }
        }

        private class ComboInitializer
        extends Initializer {
            private final Combo fControl;
            private final EnumeratedDomain fDomain;

            public ComboInitializer(Preference preference, Combo control, EnumeratedDomain domain) {
                super(preference);
                this.fControl = control;
                this.fDomain = domain;
            }

            @Override
            public void initialize() {
                int index;
                int value = InitializerFactory.this.fPreferenceStore.getInt(this.fPreference.getKey());
                EnumeratedDomain.EnumValue enumValue = this.fDomain.getValueByInteger(value);
                if (enumValue != null && (index = this.fDomain.getIndex(enumValue)) >= 0) {
                    this.fControl.select(index);
                }
            }
        }

        private class SpinnerInitializer
        extends Initializer {
            private final Spinner fControl;
            private final EnumeratedDomain fDomain;

            public SpinnerInitializer(Preference preference, Spinner control, EnumeratedDomain domain) {
                super(preference);
                this.fControl = control;
                this.fDomain = domain;
            }

            @Override
            public void initialize() {
                int value = InitializerFactory.this.fPreferenceStore.getInt(this.fPreference.getKey());
                EnumeratedDomain.EnumValue enumValue = this.fDomain.getValueByInteger(value);
                if (enumValue != null) {
                    this.fControl.setSelection(value);
                }
            }
        }

        private class TextInitializer
        extends Initializer {
            private final Text fText;

            public TextInitializer(Preference preference, Text control) {
                super(preference);
                this.fText = control;
            }

            @Override
            public void initialize() {
                String value = InitializerFactory.this.fPreferenceStore.getString(this.fPreference.getKey());
                this.fText.setText(value);
            }
        }
    }

    static class IntegerDomain
    extends Domain {
        private final int fMax;
        private final int fMin;

        public IntegerDomain(int min, int max) {
            Assert.isLegal((max >= min ? 1 : 0) != 0);
            this.fMax = max;
            this.fMin = min;
        }

        @Override
        public IStatus validate(Object value) {
            StatusInfo status = new StatusInfo();
            if (value instanceof String && ((String)value).length() == 0) {
                status.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return status;
            }
            try {
                int integer = this.parseInteger(value);
                if (!this.rangeCheck(integer)) {
                    status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(integer)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
            }
            return status;
        }

        protected boolean rangeCheck(int i) {
            return i >= this.fMin && i <= this.fMax;
        }
    }

    private static class Preference {
        private String fKey;
        private String fName;
        private String fDescription;

        public Preference(String key, String name, String description) {
            Assert.isNotNull((Object)key);
            Assert.isNotNull((Object)name);
            this.fKey = key;
            this.fName = name;
            this.fDescription = description;
        }

        public final String getKey() {
            return this.fKey;
        }

        public final String getName() {
            return this.fName;
        }

        public final String getDescription() {
            return this.fDescription;
        }
    }

    private static class WhitespaceCharacterPainterOptionsDialog
    extends Dialog {
        private List<Initializer> fDialogInitializers = new ArrayList<Initializer>();
        private OverlayPreferenceStore fDialogOverlayStore;
        private final IPreferenceStore fParentPreferenceStore;
        private InitializerFactory fDialogInitializerFactory;
        private Text errorMessageText;

        protected WhitespaceCharacterPainterOptionsDialog(Shell parentShell, IPreferenceStore parent) {
            super(parentShell);
            this.fParentPreferenceStore = parent;
            this.fDialogOverlayStore = this.createDialogOverlayStore();
            this.fDialogInitializerFactory = new InitializerFactory(this.fDialogOverlayStore);
        }

        private OverlayPreferenceStore createDialogOverlayStore() {
            ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingSpaces"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedSpaces"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingSpaces"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingIdeographicSpaces"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedIdeographicSpaces"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingIdeographicSpaces"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingTabs"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedTabs"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingTabs"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showCarriageReturn"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLineFeed"));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "whitespaceCharacterAlphaValue"));
            OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
            overlayKeys.toArray(keys);
            return new OverlayPreferenceStore(this.fParentPreferenceStore, keys);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharactersDialogTitle);
        }

        protected Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            Dialog.applyDialogFont((Control)contents);
            this.fDialogOverlayStore.load();
            this.fDialogOverlayStore.start();
            this.initializeShowWhitespaceCharactersPreferences();
            return contents;
        }

        private void initializeShowWhitespaceCharactersPreferences() {
            for (Initializer initializer : this.fDialogInitializers) {
                initializer.initialize();
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label description = new Label(composite, 0);
            description.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_configureWhitespaceCharacterPainterProperties);
            description.setLayoutData((Object)new GridData(1, 1, false, false));
            Composite tabularComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.makeColumnsEqualWidth = true;
            tabularComposite.setLayout((Layout)layout);
            Label label = new Label(tabularComposite, 0);
            label.setText("");
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_leading);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_enclosed);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_trailing);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_space);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Preference preference = new Preference("showLeadingSpaces", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            preference = new Preference("showEnclosedSpaces", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            preference = new Preference("showTrailingSpaces", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_ideographicSpace);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            preference = new Preference("showLeadingIdeographicSpaces", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            preference = new Preference("showEnclosedIdeographicSpaces", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            preference = new Preference("showTrailingIdeographicSpaces", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_tab);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            preference = new Preference("showLeadingTabs", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            preference = new Preference("showEnclosedTabs", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            preference = new Preference("showTrailingTabs", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_carriageReturn);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Button checkbox = new Button(tabularComposite, 32);
            checkbox.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            checkbox.setEnabled(false);
            checkbox = new Button(tabularComposite, 32);
            checkbox.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            checkbox.setEnabled(false);
            preference = new Preference("showCarriageReturn", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            label = new Label(tabularComposite, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_lineFeed);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            checkbox = new Button(tabularComposite, 32);
            checkbox.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            checkbox.setEnabled(false);
            checkbox = new Button(tabularComposite, 32);
            checkbox.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            checkbox.setEnabled(false);
            preference = new Preference("showLineFeed", "", null);
            this.addCheckBox(tabularComposite, preference, new BooleanDomain(), 0);
            Composite alphaComposite = new Composite(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 10;
            layout.marginWidth = 0;
            layout.makeColumnsEqualWidth = false;
            alphaComposite.setLayout((Layout)layout);
            preference = new Preference("whitespaceCharacterAlphaValue", TextEditorMessages.TextEditorDefaultsPreferencePage_transparencyLevel, null);
            this.addTextField(alphaComposite, preference, new IntegerDomain(0, 255), 5, 0);
            this.errorMessageText = new Text(composite, 72);
            this.errorMessageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
            this.setErrorMessage(null);
            return composite;
        }

        public void setErrorMessage(String errorMessage) {
            if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
                this.errorMessageText.setText(errorMessage == null ? "  " : errorMessage);
                boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
                this.errorMessageText.setEnabled(hasError);
                this.errorMessageText.setVisible(hasError);
                this.errorMessageText.getParent().update();
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(errorMessage == null);
                }
            }
        }

        private Button addCheckBox(Composite composite, final Preference preference, final Domain domain, int indentation) {
            final Button checkBox = new Button(composite, 32);
            checkBox.setToolTipText(preference.getDescription());
            GridData gd = new GridData(0x1000000, 0x1000000, false, false);
            gd.horizontalIndent = indentation;
            checkBox.setLayoutData((Object)gd);
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean value = checkBox.getSelection();
                    IStatus status = domain.validate(value);
                    if (!status.matches(4)) {
                        fDialogOverlayStore.setValue(preference.getKey(), value);
                    }
                }
            });
            this.fDialogInitializers.add(this.fDialogInitializerFactory.create(preference, checkBox));
            return checkBox;
        }

        private Control[] addTextField(Composite composite, final Preference preference, final Domain domain, int textLimit, int indentation) {
            Label labelControl = new Label(composite, 0);
            labelControl.setText(preference.getName());
            GridData gd = new GridData(1, 0x1000000, false, false);
            gd.horizontalIndent = indentation;
            labelControl.setLayoutData((Object)gd);
            final Text textControl = new Text(composite, 2052);
            gd = new GridData(1, 0x1000000, false, false);
            gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
            textControl.setLayoutData((Object)gd);
            textControl.setTextLimit(textLimit);
            textControl.setToolTipText(preference.getDescription());
            if (domain != null) {
                textControl.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String value = textControl.getText();
                        IStatus status = domain.validate(value);
                        if (!status.matches(4)) {
                            fDialogOverlayStore.setValue(preference.getKey(), value);
                            this.setErrorMessage(null);
                        } else {
                            this.setErrorMessage(NLSUtility.format(TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharactersDialogInvalidInput, value));
                        }
                    }
                });
            }
            this.fDialogInitializers.add(this.fDialogInitializerFactory.create(preference, textControl));
            return new Control[]{labelControl, textControl};
        }

        protected void okPressed() {
            super.okPressed();
            this.fDialogOverlayStore.propagate();
        }
    }
}

