/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroLaunchBarShortcut;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.intro.config.IntroConfigurer;
import org.eclipse.ui.intro.config.IntroElement;

public class IntroLaunchBarElement
extends AbstractIntroElement {
    private ArrayList shortcuts;

    IntroLaunchBarElement(IConfigurationElement element) {
        super(element);
    }

    @Override
    public int getType() {
        return 32768;
    }

    public int getOrientation() {
        int location = this.getLocation();
        return location == 131072 || location == 16384 ? 512 : 256;
    }

    public int getLocation() {
        String fastviewLocation;
        String location = this.getCfgElement().getAttribute("location");
        if (location != null) {
            if (location.equals("left")) {
                return 16384;
            }
            if (location.equals("bottom")) {
                return 1024;
            }
            if (location.equals("right")) {
                return 131072;
            }
        }
        if ((fastviewLocation = PlatformUI.getPreferenceStore().getString("initialFastViewBarLocation")).equals("left")) {
            return 16384;
        }
        if (fastviewLocation.equals("right")) {
            return 131072;
        }
        if (fastviewLocation.equals("bottom")) {
            return 1024;
        }
        return 131072;
    }

    public String getBackground() {
        return this.getCfgElement().getAttribute("bg");
    }

    public String getForeground() {
        return this.getCfgElement().getAttribute("fg");
    }

    public boolean getCreateHandle() {
        return this.getHandleElement() != null;
    }

    public boolean getClose() {
        IConfigurationElement handle = this.getHandleElement();
        if (handle != null) {
            String value = handle.getAttribute("close");
            return value == null || value.equals("true");
        }
        return true;
    }

    private String getHandleImage() {
        IConfigurationElement handle = this.getHandleElement();
        if (handle == null) {
            return null;
        }
        return handle.getAttribute("image");
    }

    public ImageDescriptor getHandleImageDescriptor() {
        String path = this.getHandleImage();
        if (path == null) {
            return null;
        }
        return ImageUtil.createImageDescriptor(this.getBundle(), path);
    }

    private IConfigurationElement getHandleElement() {
        IConfigurationElement[] children = this.getCfgElement().getChildren("handle");
        if (children.length > 0) {
            return children[0];
        }
        return null;
    }

    public IntroLaunchBarShortcut[] getShortcuts() {
        if (this.shortcuts == null) {
            this.createShortcuts();
        }
        return this.shortcuts.toArray(new IntroLaunchBarShortcut[this.shortcuts.size()]);
    }

    private void createShortcuts() {
        boolean computed;
        this.shortcuts = new ArrayList();
        IntroModelRoot model = this.getModelRoot();
        IntroConfigurer configurer = model != null ? model.getConfigurer() : null;
        String cvalue = this.getCfgElement().getAttribute("computed");
        boolean bl = computed = cvalue != null && cvalue.equalsIgnoreCase("true");
        if (computed && configurer != null) {
            IntroElement[] children = configurer.getLaunchBarShortcuts();
            int i = 0;
            while (i < children.length) {
                IntroLaunchBarShortcut shortcut = new IntroLaunchBarShortcut(this.getCfgElement(), children[i]);
                this.shortcuts.add(shortcut);
                ++i;
            }
        } else {
            IConfigurationElement[] children = this.getCfgElement().getChildren("shortcut");
            int i = 0;
            while (i < children.length) {
                IConfigurationElement child = children[i];
                IntroLaunchBarShortcut shortcut = new IntroLaunchBarShortcut(child);
                this.shortcuts.add(shortcut);
                ++i;
            }
        }
    }
}

