/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.intro.config;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.loader.ContentProviderManager;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.parts.StandbyPart;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.ReopenUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.part.IntroPart;

public final class CustomizableIntroPart
extends IntroPart
implements IRegistryChangeListener {
    private IntroPartPresentation presentation;
    private StandbyPart standbyPart;
    private Composite container;
    private IMemento memento;
    IntroModelRoot model;
    private boolean restoreStandby;
    IAdapterFactory factory = new IAdapterFactory(){

        public Class[] getAdapterList() {
            return new Class[]{StandbyPart.class, IntroPartPresentation.class};
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (!(adaptableObject instanceof CustomizableIntroPart)) {
                return null;
            }
            if (adapterType.equals(StandbyPart.class)) {
                return CustomizableIntroPart.this.getStandbyPart();
            }
            if (adapterType.equals(IntroPartPresentation.class)) {
                return CustomizableIntroPart.this.getPresentation();
            }
            return null;
        }
    };

    public CustomizableIntroPart() {
        Platform.getAdapterManager().registerAdapters(this.factory, CustomizableIntroPart.class);
        if (Log.logPerformance) {
            if (PerformanceStats.ENABLED) {
                PerformanceStats.getStats((String)"org.eclipse.ui.intro/perf/createView", (Object)"intro").startRun();
            } else {
                IntroPlugin.getDefault().setUICreationStartTime(System.currentTimeMillis());
            }
        }
    }

    public void init(IIntroSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        IntroPlugin.getDefault().closeLaunchBar();
        String introId = this.getConfigurationElement().getAttribute("id");
        ExtensionPointManager extensionPointManager = IntroPlugin.getDefault().getExtensionPointManager();
        extensionPointManager.setIntroId(introId);
        this.model = extensionPointManager.getCurrentModel();
        if (this.model != null && this.model.hasValidConfig()) {
            boolean startAtHomePage = ReopenUtil.isReopenPreference();
            if (startAtHomePage) {
                PlatformUI.getPreferenceStore().setValue("showIntro", true);
                memento = null;
            }
            this.presentation = this.model.getPresentation();
            if (this.presentation != null) {
                this.presentation.init((IIntroPart)this, this.getMemento(memento, "presentation"));
            }
            this.memento = memento;
            this.restoreStandby = this.needToRestoreStandby(memento);
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.ui.intro");
        }
        if (this.model == null || !this.model.hasValidConfig()) {
            DialogUtil.displayErrorMessage(site.getShell(), Messages.CustomizableIntroPart_configNotFound, new Object[]{ModelLoaderUtil.getLogString(this.getConfigurationElement(), null)}, null);
        }
    }

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        if (this.model != null && this.model.hasValidConfig()) {
            this.presentation.createPartControl(this.container);
        }
        if (Log.logPerformance) {
            PerformanceStats stats = PerformanceStats.getStats((String)"org.eclipse.ui.intro/perf/uiZoom", (Object)"intro");
            stats.startRun();
        }
    }

    private boolean needToRestoreStandby(IMemento memento) {
        IMemento standbyMemento = this.getMemento(memento, "standbyPart");
        if (standbyMemento == null) {
            return false;
        }
        String restore = standbyMemento.getString("restore");
        if (restore == null) {
            return false;
        }
        String cachedStandbyPart = standbyMemento.getString("contentPartID");
        if (cachedStandbyPart != null && cachedStandbyPart.equals("org.eclipse.ui.intro.config.emptyStandby")) {
            return false;
        }
        return cachedStandbyPart != null;
    }

    public void standbyStateChanged(boolean standby) {
        if (this.model == null || !this.model.hasValidConfig()) {
            return;
        }
        if (!standby) {
            this.restoreStandby = false;
        }
        boolean isStandbyPartNeeded = this.isStandbyPartNeeded();
        isStandbyPartNeeded |= this.restoreStandby;
        try {
            if (this.standbyPart == null && standby && isStandbyPartNeeded) {
                this.createStandbyPart();
            }
            this.handleSetFocus(isStandbyPartNeeded);
            this.setTopControl(isStandbyPartNeeded ? this.getStandbyControl() : this.getPresentationControl());
            this.presentation.standbyStateChanged(standby, isStandbyPartNeeded);
        }
        catch (RuntimeException e) {
            Log.error("Exception thrown in intro", e);
        }
    }

    private boolean isStandbyPartNeeded() {
        return this.container.getData("showStandbyPart") != null;
    }

    private void createStandbyPart() {
        this.standbyPart = new StandbyPart(this.model);
        this.standbyPart.init((IIntroPart)this, this.getMemento(this.memento, "standbyPart"));
        this.standbyPart.createPartControl((Composite)this.getControl());
        this.restoreStandby = false;
        this.container.setData("showStandbyPart", (Object)"true");
    }

    private void handleSetFocus(boolean standby) {
        if (standby) {
            if (this.standbyPart != null) {
                this.standbyPart.setFocus();
            }
        } else {
            this.presentation.setFocus();
        }
    }

    public void setFocus() {
        this.handleSetFocus(IntroPlugin.isIntroStandby());
    }

    private void setTopControl(Control c) {
        StackLayout layout = (StackLayout)this.container.getLayout();
        layout.topControl = c;
        this.container.layout();
    }

    private Control getPresentationControl() {
        return this.container.getChildren()[0];
    }

    private Control getStandbyControl() {
        if (this.standbyPart != null) {
            return this.container.getChildren()[1];
        }
        return null;
    }

    IntroPartPresentation getPresentation() {
        return this.presentation;
    }

    public void dispose() {
        super.dispose();
        if (this.presentation != null) {
            this.presentation.dispose();
        }
        if (this.standbyPart != null) {
            this.standbyPart.dispose();
        }
        IntroPlugin.getDefault().getExtensionPointManager().clear();
        ContentProviderManager.getInst().clear();
        Platform.getAdapterManager().unregisterAdapters(this.factory, CustomizableIntroPart.class);
        if (this.model != null && this.model.hasValidConfig()) {
            Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        }
    }

    StandbyPart getStandbyPart() {
        return this.standbyPart;
    }

    public Control getControl() {
        return this.container;
    }

    public void saveState(IMemento memento) {
        boolean restorePresentation = false;
        StackLayout layout = (StackLayout)this.container.getLayout();
        if (this.getPresentationControl().equals(layout.topControl)) {
            restorePresentation = true;
        }
        IMemento presentationMemento = memento.createChild("presentation");
        IMemento standbyPartMemento = memento.createChild("standbyPart");
        if (restorePresentation) {
            presentationMemento.putString("restore", "true");
        } else {
            standbyPartMemento.putString("restore", "true");
        }
        if (this.presentation != null) {
            this.presentation.saveState(presentationMemento);
        }
        if (this.standbyPart != null) {
            this.standbyPart.saveState(standbyPartMemento);
        }
    }

    private IMemento getMemento(IMemento memento, String key) {
        if (memento == null) {
            return null;
        }
        return memento.getChild(key);
    }

    public void registryChanged(final IRegistryChangeEvent event) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String currentPageId = CustomizableIntroPart.this.model.getCurrentPageId();
                ExtensionPointManager.getInst().clear();
                ContentProviderManager.getInst().clear();
                CustomizableIntroPart.this.model = ExtensionPointManager.getInst().getCurrentModel();
                CustomizableIntroPart.this.model.setPresentation(CustomizableIntroPart.this.getPresentation());
                CustomizableIntroPart.this.model.setCurrentPageId(currentPageId, false);
                if (CustomizableIntroPart.this.getPresentation() != null) {
                    CustomizableIntroPart.this.getPresentation().registryChanged(event);
                }
            }
        });
    }

    public boolean internal_isFinishedLoading() {
        BrowserIntroPartImplementation impl = (BrowserIntroPartImplementation)this.presentation.getIntroPartImplementation();
        return impl.isFinishedLoading();
    }
}

