/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisions;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public final class ModuleRevisionBuilder {
    private String symbolicName = null;
    private Version version = Version.emptyVersion;
    private int types = 0;
    private final List<GenericInfo> capabilityInfos = new ArrayList<GenericInfo>();
    private final List<GenericInfo> requirementInfos = new ArrayList<GenericInfo>();

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setTypes(int types) {
        this.types = types;
    }

    public void addCapability(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        ModuleRevisionBuilder.addGenericInfo(this.capabilityInfos, namespace, directives, attributes);
    }

    public List<GenericInfo> getCapabilities() {
        return new ArrayList<GenericInfo>(this.capabilityInfos);
    }

    public void addRequirement(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        ModuleRevisionBuilder.addGenericInfo(this.requirementInfos, namespace, directives, attributes);
    }

    public List<GenericInfo> getRequirements() {
        return new ArrayList<GenericInfo>(this.requirementInfos);
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getTypes() {
        return this.types;
    }

    ModuleRevision addRevision(Module module, Object revisionInfo) {
        Collection<Object> systemNames = Collections.emptyList();
        Module systemModule = module.getContainer().getModule(0L);
        if (systemModule != null) {
            ModuleRevision systemRevision = systemModule.getCurrentRevision();
            List<ModuleCapability> hostCapabilities = systemRevision.getModuleCapabilities("osgi.wiring.host");
            for (ModuleCapability hostCapability : hostCapabilities) {
                Object hostNames = hostCapability.getAttributes().get("osgi.wiring.host");
                if (hostNames instanceof Collection) {
                    systemNames = (Collection)hostNames;
                    continue;
                }
                if (!(hostNames instanceof String)) continue;
                systemNames = Arrays.asList(hostNames);
            }
        }
        ModuleRevisions revisions = module.getRevisions();
        ModuleRevision revision = new ModuleRevision(this.symbolicName, this.version, this.types, this.capabilityInfos, this.requirementInfos, revisions, revisionInfo);
        revisions.addRevision(revision);
        module.getContainer().getAdaptor().associateRevision(revision, revisionInfo);
        try {
            List<ModuleRequirement> hostRequirements = revision.getModuleRequirements("osgi.wiring.host");
            for (ModuleRequirement hostRequirement : hostRequirements) {
                FilterImpl f = null;
                String filterSpec = hostRequirement.getDirectives().get("filter");
                if (filterSpec == null) continue;
                try {
                    f = FilterImpl.newInstance(filterSpec);
                    String hostName = f.getPrimaryKeyValue("osgi.wiring.host");
                    if (hostName == null || !systemNames.contains(hostName)) continue;
                    Bundle b = module.getBundle();
                    if (b != null && !b.hasPermission(new AllPermission())) {
                        SecurityException se = new SecurityException("Must have AllPermission granted to install an extension bundle");
                        BundleException be = new BundleException(se.getMessage(), 6, se);
                        se.initCause(be);
                        throw se;
                    }
                    module.getContainer().checkAdminPermission(module.getBundle(), "extensionLifecycle");
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
            module.getContainer().checkAdminPermission(module.getBundle(), "lifecycle");
        }
        catch (SecurityException e) {
            revisions.removeRevision(revision);
            throw e;
        }
        return revision;
    }

    private static void addGenericInfo(List<GenericInfo> infos, String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        if (infos == null) {
            infos = new ArrayList<GenericInfo>();
        }
        infos.add(new GenericInfo(namespace, ModuleRevisionBuilder.copyUnmodifiableMap(directives), ModuleRevisionBuilder.copyUnmodifiableMap(attributes)));
    }

    private static <K, V> Map<K, V> copyUnmodifiableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    void basicAddCapability(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        ModuleRevisionBuilder.basicAddGenericInfo(this.capabilityInfos, namespace, directives, attributes);
    }

    void basicAddRequirement(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        ModuleRevisionBuilder.basicAddGenericInfo(this.requirementInfos, namespace, directives, attributes);
    }

    private static void basicAddGenericInfo(List<GenericInfo> infos, String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        if (infos == null) {
            infos = new ArrayList<GenericInfo>();
        }
        infos.add(new GenericInfo(namespace, Collections.unmodifiableMap(directives), Collections.unmodifiableMap(attributes)));
    }

    public static class GenericInfo {
        final String namespace;
        final Map<String, String> directives;
        final Map<String, Object> attributes;

        GenericInfo(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
            this.namespace = namespace;
            this.directives = directives;
            this.attributes = attributes;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }
}

