/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;

public class Transform
extends Resource {
    public double[] handle;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        super(device);
        this.device.checkCairo();
        this.handle = new double[6];
        if (this.handle == null) {
            SWT.error(2);
        }
        Cairo.cairo_matrix_init(this.handle, m11, m12, m21, m22, dx, dy);
        this.init();
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    void destroy() {
        this.handle = null;
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        elements[0] = (float)this.handle[0];
        elements[1] = (float)this.handle[1];
        elements[2] = (float)this.handle[2];
        elements[3] = (float)this.handle[3];
        elements[4] = (float)this.handle[4];
        elements[5] = (float)this.handle[5];
    }

    public void identity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_init(this.handle, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (Cairo.cairo_matrix_invert(this.handle) != 0) {
            SWT.error(10);
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float[] m = new float[6];
        this.getElements(m);
        return m[0] == 1.0f && m[1] == 0.0f && m[2] == 0.0f && m[3] == 1.0f && m[4] == 0.0f && m[5] == 0.0f;
    }

    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        Cairo.cairo_matrix_multiply(this.handle, matrix.handle, this.handle);
    }

    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_rotate(this.handle, angle * (float)Math.PI / 180.0f);
    }

    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_scale(this.handle, scaleX, scaleY);
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_init(this.handle, m11, m12, m21, m22, dx, dy);
    }

    public void shear(float shearX, float shearY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        double[] matrix = new double[]{1.0, shearX, shearY, 1.0, 0.0, 0.0};
        Cairo.cairo_matrix_multiply(this.handle, matrix, this.handle);
    }

    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        double[] dx = new double[1];
        double[] dy = new double[1];
        int length = pointArray.length / 2;
        int i = 0;
        int j = 0;
        while (i < length) {
            dx[0] = pointArray[j];
            dy[0] = pointArray[j + 1];
            Cairo.cairo_matrix_transform_point(this.handle, dx, dy);
            pointArray[j] = (float)dx[0];
            pointArray[j + 1] = (float)dy[0];
            ++i;
            j += 2;
        }
    }

    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_translate(this.handle, offsetX, offsetY);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + "," + elements[1] + "," + elements[2] + "," + elements[3] + "," + elements[4] + "," + elements[5] + "}";
    }
}

