/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;

public class CycleViewHandler
extends CycleBaseHandler {
    @Override
    protected void addItems(Table table, WorkbenchPage page) {
        EPartService partService = (EPartService)page.getWorkbenchWindow().getService(EPartService.class);
        EModelService modelService = (EModelService)page.getWorkbenchWindow().getService(EModelService.class);
        MPerspective currentPerspective = page.getCurrentPerspective();
        boolean includeEditor = true;
        List parts = modelService.findElements((MUIElement)currentPerspective, null, MPart.class, null);
        for (MPart part : parts) {
            if (!partService.isPartOrPlaceholderInPerspective(part.getElementId(), currentPerspective)) continue;
            if (part.getTags().contains("Editor")) {
                if (!includeEditor) continue;
                IEditorPart activeEditor = page.getActiveEditor();
                IEditorDescriptor editorDescriptor = (IEditorDescriptor)Adapters.adapt((Object)activeEditor, IEditorDescriptor.class);
                TableItem item = new TableItem(table, 0);
                item.setText(WorkbenchMessages.CyclePartAction_editor);
                item.setImage(activeEditor.getTitleImage());
                item.setData((Object)editorDescriptor);
                includeEditor = false;
                continue;
            }
            TableItem item = new TableItem(table, 0);
            item.setText(part.getLabel());
            IWorkbenchWindow iwbw = page.getWorkbenchWindow();
            if (iwbw instanceof WorkbenchWindow) {
                WorkbenchWindow wbw = (WorkbenchWindow)iwbw;
                if (part != null && wbw.getModel().getRenderer() instanceof SWTPartRenderer) {
                    SWTPartRenderer r = (SWTPartRenderer)wbw.getModel().getRenderer();
                    item.setImage(r.getImage((MUILabel)part));
                }
            }
            item.setData((Object)part);
        }
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.previousView");
        ParameterizedCommand commandBack = new ParameterizedCommand(command, null);
        return commandBack;
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.nextView");
        ParameterizedCommand commandF = new ParameterizedCommand(command, null);
        return commandF;
    }

    @Override
    protected String getTableHeader(IWorkbenchPart activePart) {
        return WorkbenchMessages.CyclePartAction_header;
    }
}

