/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.http.jetty.internal.EquinoxStdErrLog;
import org.eclipse.equinox.http.jetty.internal.HttpServerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final String JETTY_WORK_DIR = "jettywork";
    private static final String DEFAULT_PID = "default";
    private static final String MANAGED_SERVICE_FACTORY_PID = "org.eclipse.equinox.http.jetty.config";
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final String ORG_OSGI_SERVICE_HTTP_PORT_SECURE = "org.osgi.service.http.port.secure";
    private static final String AUTOSTART = "org.eclipse.equinox.http.jetty.autostart";
    private static final String LOG_STDERR_THRESHOLD = "org.eclipse.equinox.http.jetty.log.stderr.threshold";
    private static final String SERVLET3_MULTIPART = "org.eclipse.equinox.http.jetty.servlet3.multipart";
    private static HttpServerManager staticServerManager;
    private HttpServerManager httpServerManager;
    private ServiceRegistration registration;

    public void start(BundleContext context) throws Exception {
        String autostart;
        File jettyWorkDir = new File(context.getDataFile(""), JETTY_WORK_DIR);
        jettyWorkDir.mkdir();
        EquinoxStdErrLog.setThresholdLogger(context.getProperty(LOG_STDERR_THRESHOLD));
        this.httpServerManager = new HttpServerManager(jettyWorkDir);
        String servlet3multipart = context.getProperty(SERVLET3_MULTIPART);
        if (servlet3multipart != null && Boolean.valueOf(servlet3multipart).booleanValue()) {
            this.httpServerManager.setServlet3multipart(Boolean.valueOf(servlet3multipart));
        }
        if (((autostart = context.getProperty(AUTOSTART)) == null || Boolean.valueOf(autostart).booleanValue()) && !this.isBundleActivationPolicyUsed(context)) {
            Dictionary<String, Object> defaultSettings = this.createDefaultSettings(context);
            this.httpServerManager.updated(DEFAULT_PID, defaultSettings);
        }
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("service.pid", MANAGED_SERVICE_FACTORY_PID);
        this.registration = context.registerService(ManagedServiceFactory.class.getName(), (Object)this.httpServerManager, dictionary);
        Activator.setStaticServerManager(this.httpServerManager);
    }

    private boolean isBundleActivationPolicyUsed(BundleContext context) {
        StartLevel sl;
        ServiceReference reference = context.getServiceReference(StartLevel.class.getName());
        StartLevel startLevel = sl = reference != null ? (StartLevel)context.getService(reference) : null;
        if (sl != null) {
            try {
                Bundle bundle = context.getBundle();
                Method isBundleActivationPolicyUsed = StartLevel.class.getMethod("isBundleActivationPolicyUsed", Bundle.class);
                Boolean result = (Boolean)isBundleActivationPolicyUsed.invoke((Object)sl, bundle);
                boolean bl = result;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                context.ungetService(reference);
            }
        }
        return false;
    }

    public void stop(BundleContext context) throws Exception {
        Activator.setStaticServerManager(null);
        this.registration.unregister();
        this.registration = null;
        this.httpServerManager.shutdown();
        this.httpServerManager = null;
    }

    private Dictionary<String, Object> createDefaultSettings(BundleContext context) {
        String customizerClass;
        String otherInfo;
        String sessionInactiveInterval;
        String contextpath;
        String maxThreadsProperty;
        Hashtable<String, Object> defaultSettings = new Hashtable<String, Object>();
        ((Dictionary)defaultSettings).put("service.pid", DEFAULT_PID);
        String httpEnabledProperty = context.getProperty("org.eclipse.equinox.http.jetty.http.enabled");
        Boolean httpEnabled = httpEnabledProperty == null ? Boolean.TRUE : Boolean.valueOf(httpEnabledProperty);
        ((Dictionary)defaultSettings).put("http.enabled", httpEnabled);
        String httpPortProperty = context.getProperty("org.eclipse.equinox.http.jetty.http.port");
        if (httpPortProperty == null) {
            httpPortProperty = context.getProperty(ORG_OSGI_SERVICE_HTTP_PORT);
        }
        int httpPort = 80;
        if (httpPortProperty != null) {
            try {
                httpPort = Integer.parseInt(httpPortProperty);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ((Dictionary)defaultSettings).put("http.port", new Integer(httpPort));
        String httpHost = context.getProperty("org.eclipse.equinox.http.jetty.http.host");
        if (httpHost != null) {
            ((Dictionary)defaultSettings).put("http.host", httpHost);
        }
        Boolean httpsEnabled = Boolean.valueOf(context.getProperty("org.eclipse.equinox.http.jetty.https.enabled"));
        ((Dictionary)defaultSettings).put("https.enabled", httpsEnabled);
        String minThreadsProperty = context.getProperty("org.eclipse.equinox.http.jetty.http.minThreads");
        if (minThreadsProperty != null) {
            try {
                int minThreads = Integer.parseInt(minThreadsProperty);
                ((Dictionary)defaultSettings).put("http.minThreads", new Integer(minThreads));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((maxThreadsProperty = context.getProperty("org.eclipse.equinox.http.jetty.http.maxThreads")) != null) {
            try {
                int maxThreads = Integer.parseInt(maxThreadsProperty);
                ((Dictionary)defaultSettings).put("http.maxThreads", new Integer(maxThreads));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (httpsEnabled.booleanValue()) {
            String keystoretype;
            String algorithm;
            String protocol;
            String wantclientauth;
            String needclientauth;
            String keypassword;
            String password;
            String keystore;
            String httpsPortProperty = context.getProperty("org.eclipse.equinox.http.jetty.https.port");
            if (httpsPortProperty == null) {
                httpsPortProperty = context.getProperty(ORG_OSGI_SERVICE_HTTP_PORT_SECURE);
            }
            int httpsPort = 443;
            if (httpsPortProperty != null) {
                try {
                    httpsPort = Integer.parseInt(httpsPortProperty);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ((Dictionary)defaultSettings).put("https.port", new Integer(httpsPort));
            String httpsHost = context.getProperty("org.eclipse.equinox.http.jetty.https.host");
            if (httpsHost != null) {
                ((Dictionary)defaultSettings).put("https.host", httpsHost);
            }
            if ((keystore = context.getProperty("org.eclipse.equinox.http.jetty.ssl.keystore")) != null) {
                ((Dictionary)defaultSettings).put("ssl.keystore", keystore);
            }
            if ((password = context.getProperty("org.eclipse.equinox.http.jetty.ssl.password")) != null) {
                ((Dictionary)defaultSettings).put("ssl.password", password);
            }
            if ((keypassword = context.getProperty("org.eclipse.equinox.http.jetty.ssl.keypassword")) != null) {
                ((Dictionary)defaultSettings).put("ssl.keypassword", keypassword);
            }
            if ((needclientauth = context.getProperty("org.eclipse.equinox.http.jetty.ssl.needclientauth")) != null) {
                ((Dictionary)defaultSettings).put("ssl.needclientauth", Boolean.valueOf(needclientauth));
            }
            if ((wantclientauth = context.getProperty("org.eclipse.equinox.http.jetty.ssl.wantclientauth")) != null) {
                ((Dictionary)defaultSettings).put("ssl.wantclientauth", Boolean.valueOf(wantclientauth));
            }
            if ((protocol = context.getProperty("org.eclipse.equinox.http.jetty.ssl.protocol")) != null) {
                ((Dictionary)defaultSettings).put("ssl.protocol", protocol);
            }
            if ((algorithm = context.getProperty("org.eclipse.equinox.http.jetty.ssl.algorithm")) != null) {
                ((Dictionary)defaultSettings).put("ssl.algorithm", algorithm);
            }
            if ((keystoretype = context.getProperty("org.eclipse.equinox.http.jetty.ssl.keystoretype")) != null) {
                ((Dictionary)defaultSettings).put("ssl.keystoretype", keystoretype);
            }
        }
        if ((contextpath = context.getProperty("org.eclipse.equinox.http.jetty.context.path")) != null) {
            ((Dictionary)defaultSettings).put("context.path", contextpath);
        }
        if ((sessionInactiveInterval = context.getProperty("org.eclipse.equinox.http.jetty.context.sessioninactiveinterval")) != null) {
            try {
                ((Dictionary)defaultSettings).put("context.sessioninactiveinterval", new Integer(sessionInactiveInterval));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((otherInfo = context.getProperty("org.eclipse.equinox.http.jetty.other.info")) != null) {
            ((Dictionary)defaultSettings).put("other.info", otherInfo);
        }
        if ((customizerClass = context.getProperty("org.eclipse.equinox.http.jetty.customizer.class")) != null) {
            ((Dictionary)defaultSettings).put("customizer.class", customizerClass);
        }
        return defaultSettings;
    }

    public static synchronized void startServer(String pid, Dictionary<String, ?> settings) throws Exception {
        if (staticServerManager == null) {
            throw new IllegalStateException("Inactive");
        }
        staticServerManager.updated(pid, settings);
    }

    public static synchronized void stopServer(String pid) throws Exception {
        if (staticServerManager != null) {
            staticServerManager.deleted(pid);
        }
    }

    private static synchronized void setStaticServerManager(HttpServerManager httpServerManager) {
        staticServerManager = httpServerManager;
    }
}

