/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFileHandler;
import org.eclipse.core.internal.filesystem.local.LocalFileNatives;
import org.eclipse.core.internal.filesystem.local.NativeHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileNatives;

public class LocalFileNativesManager {
    private static final NativeHandler DEFAULT;
    private static NativeHandler DELEGATE;

    static {
        DELEGATE = DEFAULT = new NativeHandler(){

            @Override
            public boolean putFileInfo(String fileName, IFileInfo info, int options) {
                return false;
            }

            @Override
            public int getSupportedAttributes() {
                return 0;
            }

            @Override
            public FileInfo fetchFileInfo(String fileName) {
                return new FileInfo();
            }
        };
        boolean nativesAllowed = Boolean.valueOf(System.getProperty("eclipse.filesystem.useNatives", "true"));
        if (nativesAllowed && UnixFileNatives.isUsingNatives()) {
            DELEGATE = new UnixFileHandler();
        } else if (nativesAllowed && LocalFileNatives.isUsingNatives()) {
            DELEGATE = new LocalFileHandler();
        } else {
            try {
                Class<?> c = LocalFileNativesManager.class.getClassLoader().loadClass("org.eclipse.core.internal.filesystem.java7.HandlerFactory");
                DELEGATE = (NativeHandler)c.getMethod("getHandler", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public static int getSupportedAttributes() {
        return DELEGATE.getSupportedAttributes();
    }

    public static FileInfo fetchFileInfo(String fileName) {
        return DELEGATE.fetchFileInfo(fileName);
    }

    public static boolean putFileInfo(String fileName, IFileInfo info, int options) {
        return DELEGATE.putFileInfo(fileName, info, options);
    }

    public static boolean isUsingNatives() {
        return DELEGATE != DEFAULT;
    }
}

