/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.CopyToClipboardAction;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.SelectAllAction;
import org.eclipse.search.internal.ui.text.EditorOpener;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FilterUpdateEvent;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.MatchFilterAction;
import org.eclipse.search2.internal.ui.MatchFilterSelectionAction;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.basic.views.CollapseAllAction;
import org.eclipse.search2.internal.ui.basic.views.ExpandAllAction;
import org.eclipse.search2.internal.ui.basic.views.INavigate;
import org.eclipse.search2.internal.ui.basic.views.RemoveAllMatchesAction;
import org.eclipse.search2.internal.ui.basic.views.RemoveMatchAction;
import org.eclipse.search2.internal.ui.basic.views.RemoveSelectedMatchesAction;
import org.eclipse.search2.internal.ui.basic.views.SetLayoutAction;
import org.eclipse.search2.internal.ui.basic.views.ShowNextResultAction;
import org.eclipse.search2.internal.ui.basic.views.ShowPreviousResultAction;
import org.eclipse.search2.internal.ui.basic.views.TableViewerNavigator;
import org.eclipse.search2.internal.ui.basic.views.TreeViewerNavigator;
import org.eclipse.search2.internal.ui.text.AnnotationManagers;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractTextSearchViewPage
extends Page
implements ISearchResultPage {
    private volatile boolean fIsUIUpdateScheduled = false;
    private volatile boolean fScheduleEnsureSelection = false;
    private static final String KEY_LAYOUT = "org.eclipse.search.resultpage.layout";
    protected static final Match[] EMPTY_MATCH_ARRAY = new Match[0];
    private StructuredViewer fViewer;
    private Composite fViewerContainer;
    private Control fBusyLabel;
    private PageBook fPagebook;
    private boolean fIsBusyShown;
    private ISearchResultViewPart fViewPart;
    private Set<Object> fBatchedUpdates;
    private boolean fBatchedClearAll;
    private ISearchResultListener fListener;
    private IQueryListener fQueryListener;
    private MenuManager fMenu;
    private AbstractTextSearchResult fInput;
    private CopyToClipboardAction fCopyToClipboardAction;
    private Action fRemoveSelectedMatches;
    private Action fRemoveCurrentMatch;
    private Action fRemoveAllResultsAction;
    private Action fShowNextAction;
    private Action fShowPreviousAction;
    private ExpandAllAction fExpandAllAction;
    private CollapseAllAction fCollapseAllAction;
    private SetLayoutAction fFlatAction;
    private SetLayoutAction fHierarchicalAction;
    private int fCurrentLayout;
    private int fCurrentMatchIndex = 0;
    private String fId;
    private final int fSupportedLayouts;
    private SelectionProviderAdapter fViewerAdapter;
    private SelectAllAction fSelectAllAction;
    private IAction[] fFilterActions;
    private Integer fElementLimit;
    private EditorOpener fEditorOpener = new EditorOpener();
    public static final int FLAG_LAYOUT_FLAT = 1;
    public static final int FLAG_LAYOUT_TREE = 2;

    protected AbstractTextSearchViewPage(int supportedLayouts) {
        this.fSupportedLayouts = supportedLayouts;
        this.initLayout();
        this.fRemoveAllResultsAction = new RemoveAllMatchesAction(this);
        this.fRemoveSelectedMatches = new RemoveSelectedMatchesAction(this);
        this.fRemoveCurrentMatch = new RemoveMatchAction(this);
        this.fShowNextAction = new ShowNextResultAction(this);
        this.fShowPreviousAction = new ShowPreviousResultAction(this);
        this.fCopyToClipboardAction = new CopyToClipboardAction();
        if ((supportedLayouts & 2) != 0) {
            this.fExpandAllAction = new ExpandAllAction();
            this.fCollapseAllAction = new CollapseAllAction();
        }
        this.fSelectAllAction = new SelectAllAction();
        this.createLayoutActions();
        this.fBatchedUpdates = new HashSet<Object>();
        this.fBatchedClearAll = false;
        this.fListener = new ISearchResultListener(){

            @Override
            public void searchResultChanged(SearchResultEvent e) {
                AbstractTextSearchViewPage.this.handleSearchResultChanged(e);
            }
        };
        this.fFilterActions = null;
        this.fElementLimit = null;
    }

    private void initLayout() {
        this.fCurrentLayout = this.supportsTreeLayout() ? 2 : 1;
    }

    protected AbstractTextSearchViewPage() {
        this(3);
    }

    private void createLayoutActions() {
        if (this.countBits(this.fSupportedLayouts) > 1) {
            this.fFlatAction = new SetLayoutAction(this, SearchMessages.AbstractTextSearchViewPage_flat_layout_label, SearchMessages.AbstractTextSearchViewPage_flat_layout_tooltip, 1);
            this.fHierarchicalAction = new SetLayoutAction(this, SearchMessages.AbstractTextSearchViewPage_hierarchical_layout_label, SearchMessages.AbstractTextSearchViewPage_hierarchical_layout_tooltip, 2);
            SearchPluginImages.setImageDescriptors((IAction)this.fFlatAction, "lcl16/", "org.eclipse.search.ui.flatLayout.gif");
            SearchPluginImages.setImageDescriptors((IAction)this.fHierarchicalAction, "lcl16/", "org.eclipse.search.ui.hierarchicalLayout.gif");
        }
    }

    private int countBits(int layoutFlags) {
        int bitCount = 0;
        int i = 0;
        while (i < 32) {
            if (layoutFlags % 2 == 1) {
                ++bitCount;
            }
            layoutFlags >>= 1;
            ++i;
        }
        return bitCount;
    }

    private boolean supportsTreeLayout() {
        return this.isLayoutSupported(2);
    }

    protected IDialogSettings getSettings() {
        IDialogSettings parent = SearchPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = parent.getSection(this.getID());
        if (settings == null) {
            settings = parent.addNewSection(this.getID());
        }
        return settings;
    }

    @Override
    public void setID(String id) {
        this.fId = id;
    }

    @Override
    public String getID() {
        return this.fId;
    }

    @Override
    public String getLabel() {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return "";
        }
        return result.getLabel();
    }

    @Deprecated
    protected void showMatch(Match match, int currentOffset, int currentLength) throws PartInitException {
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        this.showMatch(match, currentOffset, currentLength);
    }

    protected final IEditorPart openAndSelect(IWorkbenchPage page, IFile file, int offset, int length, boolean activate) throws PartInitException {
        return this.fEditorOpener.openAndSelect(page, file, offset, length, activate);
    }

    protected final IEditorPart open(IWorkbenchPage page, IFile file, boolean activate) throws PartInitException {
        return this.fEditorOpener.open(page, file, activate);
    }

    protected abstract void elementsChanged(Object[] var1);

    protected abstract void clear();

    protected abstract void configureTreeViewer(TreeViewer var1);

    protected abstract void configureTableViewer(TableViewer var1);

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.appendToGroup("group.show", (IAction)this.fShowNextAction);
        mgr.appendToGroup("group.show", (IAction)this.fShowPreviousAction);
        mgr.appendToGroup("group.edit", (IAction)this.fCopyToClipboardAction);
        if (this.getCurrentMatch() != null) {
            mgr.appendToGroup("group.removeMatches", (IAction)this.fRemoveCurrentMatch);
        }
        if (this.canRemoveMatchesWith(this.getViewer().getSelection())) {
            mgr.appendToGroup("group.removeMatches", (IAction)this.fRemoveSelectedMatches);
        }
        mgr.appendToGroup("group.removeMatches", (IAction)this.fRemoveAllResultsAction);
        if (this.getLayout() == 2) {
            mgr.appendToGroup("group.show", (IAction)this.fExpandAllAction);
        }
    }

    protected boolean canRemoveMatchesWith(ISelection selection) {
        return !selection.isEmpty();
    }

    public void createControl(Composite parent) {
        this.fQueryListener = this.createQueryListener();
        this.fMenu = new MenuManager("#PopUp");
        this.fMenu.setRemoveAllWhenShown(true);
        this.fMenu.setParent((IContributionManager)this.getSite().getActionBars().getMenuManager());
        this.fMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SearchView.createContextMenuGroups(mgr);
                AbstractTextSearchViewPage.this.fillContextMenu(mgr);
                AbstractTextSearchViewPage.this.fViewPart.fillContextMenu(mgr);
            }
        });
        this.fPagebook = new PageBook(parent, 0);
        this.fPagebook.setLayoutData((Object)new GridData(1808));
        this.fBusyLabel = this.createBusyControl();
        this.fViewerContainer = new Composite((Composite)this.fPagebook, 0);
        this.fViewerContainer.setLayoutData((Object)new GridData(1808));
        this.fViewerContainer.setSize(100, 100);
        this.fViewerContainer.setLayout((Layout)new FillLayout());
        this.fViewerAdapter = new SelectionProviderAdapter();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewerAdapter);
        this.getSite().registerContextMenu(this.fViewPart.getViewSite().getId(), this.fMenu, (ISelectionProvider)this.fViewerAdapter);
        this.createViewer(this.fViewerContainer, this.fCurrentLayout);
        this.showBusyLabel(this.fIsBusyShown);
        NewSearchUI.addQueryListener(this.fQueryListener);
    }

    private Control createBusyControl() {
        Table busyLabel = new Table((Composite)this.fPagebook, 0);
        TableItem item = new TableItem(busyLabel, 0);
        item.setText(SearchMessages.AbstractTextSearchViewPage_searching_label);
        busyLabel.setLayoutData((Object)new GridData(768));
        return busyLabel;
    }

    private synchronized void scheduleUIUpdate() {
        if (!this.fIsUIUpdateScheduled) {
            this.fIsUIUpdateScheduled = true;
            new UpdateUIJob().schedule();
        }
    }

    private IQueryListener createQueryListener() {
        return new IQueryListener(){

            @Override
            public void queryAdded(ISearchQuery query) {
            }

            @Override
            public void queryRemoved(ISearchQuery query) {
            }

            @Override
            public void queryStarting(final ISearchQuery query) {
                Runnable runnable1 = new Runnable(){

                    @Override
                    public void run() {
                        AbstractTextSearchViewPage.this.updateBusyLabel();
                        AbstractTextSearchResult result = AbstractTextSearchViewPage.this.getInput();
                        if (result == null || !result.getQuery().equals(query)) {
                            return;
                        }
                        AbstractTextSearchViewPage.this.turnOffDecoration();
                        AbstractTextSearchViewPage.this.scheduleUIUpdate();
                    }
                };
                AbstractTextSearchViewPage.this.asyncExec(runnable1);
            }

            @Override
            public void queryFinished(ISearchQuery query) {
                AbstractTextSearchViewPage.this.postEnsureSelection();
            }
        };
    }

    protected void postEnsureSelection() {
        this.fScheduleEnsureSelection = true;
        this.scheduleUIUpdate();
    }

    private void updateBusyLabel() {
        boolean shouldShowBusy;
        AbstractTextSearchResult result = this.getInput();
        boolean bl = shouldShowBusy = result != null && NewSearchUI.isQueryRunning(result.getQuery()) && result.getMatchCount() == 0;
        if (shouldShowBusy == this.fIsBusyShown) {
            return;
        }
        this.fIsBusyShown = shouldShowBusy;
        this.showBusyLabel(this.fIsBusyShown);
    }

    private void showBusyLabel(boolean shouldShowBusy) {
        if (shouldShowBusy) {
            this.fPagebook.showPage(this.fBusyLabel);
        } else {
            this.fPagebook.showPage((Control)this.fViewerContainer);
        }
    }

    public boolean isLayoutSupported(int layout) {
        return (layout & this.fSupportedLayouts) == layout;
    }

    public void setLayout(int layout) {
        Assert.isTrue((this.countBits(layout) == 1 ? 1 : 0) != 0);
        Assert.isTrue((boolean)this.isLayoutSupported(layout));
        if (this.countBits(this.fSupportedLayouts) < 2) {
            return;
        }
        if (this.fCurrentLayout == layout) {
            return;
        }
        this.fCurrentLayout = layout;
        ISelection selection = this.fViewer.getSelection();
        this.disconnectViewer();
        this.disposeViewer();
        this.createViewer(this.fViewerContainer, layout);
        this.fViewerContainer.layout(true);
        this.connectViewer(this.fInput);
        this.fViewer.setSelection(selection, true);
        this.getSettings().put(KEY_LAYOUT, layout);
        this.getViewPart().updateLabel();
    }

    private void disposeViewer() {
        this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this.fViewerAdapter);
        this.fViewer.getControl().dispose();
        this.fViewer = null;
    }

    private void updateLayoutActions() {
        if (this.fFlatAction != null) {
            this.fFlatAction.setChecked(this.fCurrentLayout == this.fFlatAction.getLayout());
        }
        if (this.fHierarchicalAction != null) {
            this.fHierarchicalAction.setChecked(this.fCurrentLayout == this.fHierarchicalAction.getLayout());
        }
    }

    public int getLayout() {
        return this.fCurrentLayout;
    }

    private void createViewer(Composite parent, int layout) {
        TableViewer viewer;
        if ((layout & 1) != 0) {
            viewer = this.createTableViewer(parent);
            this.fViewer = viewer;
            this.configureTableViewer(viewer);
        } else if ((layout & 2) != 0) {
            viewer = this.createTreeViewer(parent);
            this.fViewer = viewer;
            this.configureTreeViewer((TreeViewer)viewer);
            this.fCollapseAllAction.setViewer((TreeViewer)viewer);
            this.fExpandAllAction.setViewer((TreeViewer)viewer);
        }
        this.fCopyToClipboardAction.setViewer(this.fViewer);
        this.fSelectAllAction.setViewer(this.fViewer);
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        SearchView.createToolBarGroups(tbm);
        this.fillToolbar(tbm);
        tbm.update(false);
        new OpenAndLinkWithEditorHelper(this.fViewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    AbstractTextSearchViewPage.this.handleOpen(new OpenEvent((Viewer)AbstractTextSearchViewPage.this.fViewer, selection));
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                AbstractTextSearchViewPage.this.handleOpen(new OpenEvent((Viewer)AbstractTextSearchViewPage.this.fViewer, selection));
            }
        };
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTextSearchViewPage.this.fCurrentMatchIndex = -1;
                AbstractTextSearchViewPage.this.fRemoveSelectedMatches.setEnabled(AbstractTextSearchViewPage.this.canRemoveMatchesWith(event.getSelection()));
            }
        });
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.fViewerAdapter);
        Menu menu = this.fMenu.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.updateLayoutActions();
        this.getViewPart().updateLabel();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 770);
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new TableViewer(parent, 770);
    }

    public void setFocus() {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public Control getControl() {
        return this.fPagebook;
    }

    @Override
    public void setInput(ISearchResult newSearch, Object viewState) {
        if (newSearch != null && !(newSearch instanceof AbstractTextSearchResult)) {
            return;
        }
        AbstractTextSearchResult oldSearch = this.fInput;
        if (oldSearch != null) {
            this.disconnectViewer();
            this.removeFilterActionsFromViewMenu(this.fFilterActions);
            oldSearch.removeListener(this.fListener);
            AnnotationManagers.removeSearchResult(this.getSite().getWorkbenchWindow(), oldSearch);
        }
        this.fInput = (AbstractTextSearchResult)newSearch;
        if (this.fInput != null) {
            AnnotationManagers.addSearchResult(this.getSite().getWorkbenchWindow(), this.fInput);
            this.fInput.addListener(this.fListener);
            this.connectViewer(this.fInput);
            if (viewState instanceof ISelection) {
                this.fViewer.setSelection((ISelection)viewState, true);
            } else {
                this.navigateNext(true);
            }
            this.updateBusyLabel();
            this.turnOffDecoration();
            this.scheduleUIUpdate();
            this.fFilterActions = this.addFilterActionsToViewMenu();
        } else {
            this.getViewPart().updateLabel();
        }
    }

    private void removeFilterActionsFromViewMenu(IAction[] filterActions) {
        IActionBars bars = this.getSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        if (filterActions != null) {
            int i = 0;
            while (i < filterActions.length) {
                menu.remove(filterActions[i].getId());
                ++i;
            }
        }
        menu.remove("MatchFilterSelectionAction");
    }

    private IAction[] addFilterActionsToViewMenu() {
        AbstractTextSearchResult input = this.getInput();
        if (input == null) {
            return null;
        }
        MatchFilter[] allMatchFilters = input.getAllMatchFilters();
        if (allMatchFilters == null && this.getElementLimit() == null) {
            return null;
        }
        IActionBars bars = this.getSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        menu.prependToGroup("group.filtering", (IAction)new MatchFilterSelectionAction(this));
        if (allMatchFilters != null) {
            MatchFilterAction[] actions = new MatchFilterAction[allMatchFilters.length];
            int i = allMatchFilters.length - 1;
            while (i >= 0) {
                MatchFilterAction filterAction;
                actions[i] = filterAction = new MatchFilterAction(this, allMatchFilters[i]);
                menu.prependToGroup("group.filtering", (IAction)filterAction);
                --i;
            }
            return actions;
        }
        return null;
    }

    private void updateFilterActions(IAction[] filterActions) {
        if (filterActions != null) {
            int i = 0;
            while (i < filterActions.length) {
                IAction curr = filterActions[i];
                if (curr instanceof IUpdate) {
                    ((IUpdate)curr).update();
                }
                ++i;
            }
        }
    }

    @Override
    public Object getUIState() {
        return this.fViewer.getSelection();
    }

    private void connectViewer(AbstractTextSearchResult search) {
        this.fViewer.setInput((Object)search);
    }

    private void disconnectViewer() {
        this.fViewer.setInput(null);
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    private void showMatch(final Match match, final boolean activateEditor) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable exception) {
                if (exception instanceof PartInitException) {
                    PartInitException pie = (PartInitException)exception;
                    ErrorDialog.openError((Shell)AbstractTextSearchViewPage.this.getSite().getShell(), (String)SearchMessages.DefaultSearchViewPage_show_match, (String)SearchMessages.DefaultSearchViewPage_error_no_editor, (IStatus)pie.getStatus());
                }
            }

            public void run() throws Exception {
                IRegion location = AbstractTextSearchViewPage.this.getCurrentMatchLocation(match);
                AbstractTextSearchViewPage.this.showMatch(match, location.getOffset(), location.getLength(), activateEditor);
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    public AbstractTextSearchResult getInput() {
        return this.fInput;
    }

    public void gotoNextMatch() {
        this.gotoNextMatch(false);
    }

    private void gotoNextMatch(boolean activateEditor) {
        ++this.fCurrentMatchIndex;
        Match nextMatch = this.getCurrentMatch();
        if (nextMatch == null) {
            this.navigateNext(true);
            this.fCurrentMatchIndex = 0;
        }
        this.showCurrentMatch(activateEditor);
    }

    public void gotoPreviousMatch() {
        this.gotoPreviousMatch(false);
    }

    private void gotoPreviousMatch(boolean activateEditor) {
        --this.fCurrentMatchIndex;
        Match nextMatch = this.getCurrentMatch();
        if (nextMatch == null) {
            this.navigateNext(false);
            this.fCurrentMatchIndex = this.getDisplayedMatchCount(this.getFirstSelectedElement()) - 1;
        }
        this.showCurrentMatch(activateEditor);
    }

    private void navigateNext(boolean forward) {
        INavigate navigator = null;
        navigator = this.fViewer instanceof TableViewer ? new TableViewerNavigator((TableViewer)this.fViewer) : new TreeViewerNavigator(this, (TreeViewer)this.fViewer);
        navigator.navigateNext(forward);
    }

    private boolean showCurrentMatch(boolean activateEditor) {
        Match currentMatch = this.getCurrentMatch();
        if (currentMatch != null) {
            this.showMatch(currentMatch, activateEditor);
            return true;
        }
        return false;
    }

    public Match getCurrentMatch() {
        Object element = this.getFirstSelectedElement();
        if (element != null) {
            Match[] matches = this.getDisplayedMatches(element);
            if (this.fCurrentMatchIndex >= 0 && this.fCurrentMatchIndex < matches.length) {
                return matches[this.fCurrentMatchIndex];
            }
        }
        return null;
    }

    public Match[] getDisplayedMatches(Object element) {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return EMPTY_MATCH_ARRAY;
        }
        Match[] matches = result.getMatches(element);
        if (result.getActiveMatchFilters() == null) {
            return matches;
        }
        int count = 0;
        int i = 0;
        while (i < matches.length) {
            if (matches[i].isFiltered()) {
                matches[i] = null;
            } else {
                ++count;
            }
            ++i;
        }
        if (count == matches.length) {
            return matches;
        }
        Match[] filteredMatches = new Match[count];
        int i2 = 0;
        int k = 0;
        while (i2 < matches.length) {
            if (matches[i2] != null) {
                filteredMatches[k++] = matches[i2];
            }
            ++i2;
        }
        return filteredMatches;
    }

    public IRegion getCurrentMatchLocation(Match match) {
        int length;
        int offset;
        PositionTracker tracker = InternalSearchUI.getInstance().getPositionTracker();
        Position pos = tracker.getCurrentPosition(match);
        if (pos == null) {
            offset = match.getOffset();
            length = match.getLength();
        } else {
            offset = pos.getOffset();
            length = pos.getLength();
        }
        return new Region(offset, length);
    }

    public int getDisplayedMatchCount(Object element) {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return 0;
        }
        if (result.getActiveMatchFilters() == null) {
            return result.getMatchCount(element);
        }
        int count = 0;
        Match[] matches = result.getMatches(element);
        int i = 0;
        while (i < matches.length) {
            if (!matches[i].isFiltered()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private Object getFirstSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() > 0) {
            return selection.getFirstElement();
        }
        return null;
    }

    public void dispose() {
        AbstractTextSearchResult oldSearch = this.getInput();
        if (oldSearch != null) {
            AnnotationManagers.removeSearchResult(this.getSite().getWorkbenchWindow(), oldSearch);
        }
        super.dispose();
        NewSearchUI.removeQueryListener(this.fQueryListener);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IMenuManager menuManager = pageSite.getActionBars().getMenuManager();
        this.addLayoutActions(menuManager);
        this.initActionDefinitionIDs();
        menuManager.updateAll(true);
        pageSite.getActionBars().updateActionBars();
    }

    private void initActionDefinitionIDs() {
        this.fCopyToClipboardAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fRemoveSelectedMatches.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fShowNextAction.setActionDefinitionId("org.eclipse.ui.navigate.next");
        this.fShowPreviousAction.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        this.fSelectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
    }

    protected void fillToolbar(IToolBarManager tbm) {
        tbm.appendToGroup("group.show", (IAction)this.fShowNextAction);
        tbm.appendToGroup("group.show", (IAction)this.fShowPreviousAction);
        tbm.appendToGroup("group.removeMatches", (IAction)this.fRemoveSelectedMatches);
        tbm.appendToGroup("group.removeMatches", (IAction)this.fRemoveAllResultsAction);
        IActionBars actionBars = this.getSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fShowNextAction);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fShowPreviousAction);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fRemoveSelectedMatches);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyToClipboardAction);
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        }
        if (this.getLayout() == 2) {
            tbm.appendToGroup("group.viewerSetup", (IAction)this.fExpandAllAction);
            tbm.appendToGroup("group.viewerSetup", (IAction)this.fCollapseAllAction);
        }
    }

    private void addLayoutActions(IMenuManager menuManager) {
        if (this.fFlatAction != null) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)this.fFlatAction);
        }
        if (this.fHierarchicalAction != null) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)this.fHierarchicalAction);
        }
    }

    @Override
    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    protected ISearchResultViewPart getViewPart() {
        return this.fViewPart;
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            this.postUpdate(((MatchEvent)e).getMatches());
        } else if (e instanceof RemoveAllEvent) {
            this.postClear();
        } else if (e instanceof FilterUpdateEvent) {
            this.postUpdate(((FilterUpdateEvent)e).getUpdatedMatches());
            this.updateFilterActions(this.fFilterActions);
        }
    }

    protected void evaluateChangedElements(Match[] matches, Set<Object> changedElements) {
        int i = 0;
        while (i < matches.length) {
            changedElements.add(matches[i].getElement());
            ++i;
        }
    }

    private synchronized void postUpdate(Match[] matches) {
        this.evaluateChangedElements(matches, this.fBatchedUpdates);
        this.scheduleUIUpdate();
    }

    private synchronized void runBatchedUpdates() {
        this.elementsChanged(this.fBatchedUpdates.toArray());
        this.fBatchedUpdates.clear();
        this.updateBusyLabel();
    }

    private synchronized void postClear() {
        this.fBatchedClearAll = true;
        this.fBatchedUpdates.clear();
        this.scheduleUIUpdate();
    }

    private synchronized boolean hasMoreUpdates() {
        return this.fBatchedClearAll || this.fBatchedUpdates.size() > 0;
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning(result.getQuery());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchedClear() {
        AbstractTextSearchViewPage abstractTextSearchViewPage = this;
        synchronized (abstractTextSearchViewPage) {
            if (!this.fBatchedClearAll) {
                return;
            }
            this.fBatchedClearAll = false;
            this.updateBusyLabel();
        }
        this.getViewPart().updateLabel();
        this.clear();
    }

    private void asyncExec(final Runnable runnable) {
        final Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay == null || !currentDisplay.equals(control.getDisplay())) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            } else {
                runnable.run();
            }
        }
    }

    @Override
    public void restoreState(IMemento memento) {
        if (this.countBits(this.fSupportedLayouts) > 1) {
            Integer layout;
            try {
                this.fCurrentLayout = this.getSettings().getInt(KEY_LAYOUT);
                if (this.fCurrentLayout == 0) {
                    this.initLayout();
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (memento != null && (layout = memento.getInteger(KEY_LAYOUT)) != null) {
                this.fCurrentLayout = layout;
                if (this.fCurrentLayout == 0) {
                    this.initLayout();
                }
            }
        }
    }

    @Override
    public void saveState(IMemento memento) {
        if (this.countBits(this.fSupportedLayouts) > 1) {
            memento.putInteger(KEY_LAYOUT, this.fCurrentLayout);
        }
    }

    public void internalRemoveSelected() {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return;
        }
        StructuredViewer viewer = this.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        HashSet<Match> set = new HashSet<Match>();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider cp = (ITreeContentProvider)viewer.getContentProvider();
            this.collectAllMatchesBelow(result, set, cp, selection.toArray());
        } else {
            this.collectAllMatches(set, selection.toArray());
        }
        this.navigateNext(true);
        Match[] matches = new Match[set.size()];
        set.toArray(matches);
        result.removeMatches(matches);
    }

    private void collectAllMatches(HashSet<Match> set, Object[] elements) {
        int j = 0;
        while (j < elements.length) {
            Match[] matches = this.getDisplayedMatches(elements[j]);
            int i = 0;
            while (i < matches.length) {
                set.add(matches[i]);
                ++i;
            }
            ++j;
        }
    }

    private void collectAllMatchesBelow(AbstractTextSearchResult result, Set<Match> set, ITreeContentProvider cp, Object[] elements) {
        int j = 0;
        while (j < elements.length) {
            Match[] matches = this.getDisplayedMatches(elements[j]);
            int i = 0;
            while (i < matches.length) {
                set.add(matches[i]);
                ++i;
            }
            Object[] children = cp.getChildren(elements[j]);
            this.collectAllMatchesBelow(result, set, cp, children);
            ++j;
        }
    }

    private void turnOffDecoration() {
        IBaseLabelProvider lp = this.fViewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(null);
        }
    }

    private void turnOnDecoration() {
        IBaseLabelProvider lp = this.fViewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        }
    }

    protected void handleOpen(OpenEvent event) {
        Viewer viewer = event.getViewer();
        boolean hasCurrentMatch = this.showCurrentMatch(OpenStrategy.activateOnOpen());
        ISelection sel = event.getSelection();
        if (viewer instanceof TreeViewer && sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            TreeViewer tv = (TreeViewer)this.getViewer();
            Object element = selection.getFirstElement();
            if (element != null) {
                if (!hasCurrentMatch && this.getDisplayedMatchCount(element) > 0) {
                    this.gotoNextMatch(OpenStrategy.activateOnOpen());
                } else {
                    tv.setExpandedState(element, !tv.getExpandedState(element));
                }
            }
            return;
        }
        if (!hasCurrentMatch) {
            this.gotoNextMatch(OpenStrategy.activateOnOpen());
        }
    }

    public void setElementLimit(Integer limit) {
        this.fElementLimit = limit;
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
        if (this.fViewPart != null) {
            this.fViewPart.updateLabel();
        }
    }

    public Integer getElementLimit() {
        return this.fElementLimit;
    }

    private class SelectionProviderAdapter
    implements ISelectionProvider,
    ISelectionChangedListener {
        private ArrayList<ISelectionChangedListener> fListeners = new ArrayList(5);

        private SelectionProviderAdapter() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add(listener);
        }

        public ISelection getSelection() {
            return AbstractTextSearchViewPage.this.fViewer.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            AbstractTextSearchViewPage.this.fViewer.setSelection(selection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionChangedEvent wrappedEvent = new SelectionChangedEvent((ISelectionProvider)this, event.getSelection());
            for (ISelectionChangedListener listener : this.fListeners) {
                listener.selectionChanged(wrappedEvent);
            }
        }
    }

    private class UpdateUIJob
    extends UIJob {
        public UpdateUIJob() {
            super(SearchMessages.AbstractTextSearchViewPage_update_job_name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = AbstractTextSearchViewPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return Status.OK_STATUS;
            }
            AbstractTextSearchViewPage.this.runBatchedClear();
            AbstractTextSearchViewPage.this.runBatchedUpdates();
            if (AbstractTextSearchViewPage.this.hasMoreUpdates() || AbstractTextSearchViewPage.this.isQueryRunning()) {
                this.schedule(500L);
            } else {
                AbstractTextSearchViewPage.this.fIsUIUpdateScheduled = false;
                AbstractTextSearchViewPage.this.turnOnDecoration();
                AbstractTextSearchViewPage.this.updateBusyLabel();
                if (AbstractTextSearchViewPage.this.fScheduleEnsureSelection) {
                    AbstractTextSearchViewPage.this.fScheduleEnsureSelection = false;
                    AbstractTextSearchResult result = AbstractTextSearchViewPage.this.getInput();
                    if (result != null && AbstractTextSearchViewPage.this.fViewer.getSelection().isEmpty()) {
                        AbstractTextSearchViewPage.this.navigateNext(true);
                    }
                }
            }
            AbstractTextSearchViewPage.this.fViewPart.updateLabel();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == AbstractTextSearchViewPage.this;
        }
    }
}

