/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.registry.MarkerImageProviderRegistry;
import org.eclipse.ui.internal.ide.registry.ProjectImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class IDEWorkbenchPlugin
extends AbstractUIPlugin {
    private static IDEWorkbenchPlugin inst;
    public static final String IDE_WORKBENCH = "org.eclipse.ui.ide";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String PL_MARKER_IMAGE_PROVIDER = "markerImageProviders";
    public static final String PL_MARKER_HELP = "markerHelp";
    public static final String PL_MARKER_RESOLUTION = "markerResolution";
    public static final String PL_PROJECT_NATURE_IMAGES = "projectNatureImages";
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private static final int PROBLEMS_VIEW_CREATION_DELAY = 6000;
    private ProjectImageRegistry projectImageRegistry = null;
    private MarkerImageProviderRegistry markerImageProviderRegistry = null;
    private ResourceManager resourceManager;

    public IDEWorkbenchPlugin() {
        inst = this;
    }

    public static Object createExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Bundle plugin = Platform.getBundle((String)element.getNamespace());
        if (plugin.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        Object[] ret = new Object[1];
        CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, () -> {
            try {
                objectArray[0] = element.createExecutableExtension(classAttribute);
            }
            catch (CoreException e) {
                coreExceptionArray[0] = e;
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IDEWorkbenchPlugin getDefault() {
        return inst;
    }

    public static IWorkspace getPluginWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(String message) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
    }

    public static void log(String message, Throwable t) {
        IStatus status = StatusUtil.newStatus(4, message, t);
        IDEWorkbenchPlugin.log(message, status);
    }

    public static void log(Class clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format((String)"Exception in {0}.{1}: {2}", (Object[])new Object[]{clazz.getName(), methodName, t});
        IDEWorkbenchPlugin.log(msg, t);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        }
        IDEWorkbenchPlugin.getDefault().getLog().log(status);
    }

    protected void refreshPluginActions() {
    }

    public ProjectImageRegistry getProjectImageRegistry() {
        if (this.projectImageRegistry == null) {
            this.projectImageRegistry = new ProjectImageRegistry();
            this.projectImageRegistry.load();
        }
        return this.projectImageRegistry;
    }

    public MarkerImageProviderRegistry getMarkerImageProviderRegistry() {
        if (this.markerImageProviderRegistry == null) {
            this.markerImageProviderRegistry = new MarkerImageProviderRegistry();
        }
        return this.markerImageProviderRegistry;
    }

    public AboutInfo[] getFeatureInfos() {
        ArrayList<AboutInfo> infos = new ArrayList<AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                IBundleGroup[] bundleGroups = providers[i].getBundleGroups();
                int j = 0;
                while (j < bundleGroups.length) {
                    infos.add(new AboutInfo(bundleGroups[j]));
                    ++j;
                }
                ++i;
            }
        }
        return infos.toArray(new AboutInfo[infos.size()]);
    }

    public static ImageDescriptor getIDEImageDescriptor(String relativePath) {
        return IDEWorkbenchPlugin.imageDescriptorFromPlugin((String)IDE_WORKBENCH, (String)(ICONS_PATH + relativePath));
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.createProblemsViews();
    }

    private void createProblemsViews() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench;
                Object object = workbench = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench() : null;
                if (workbench != null && (workbench.getDisplay().isDisposed() || PlatformUI.getWorkbench().isClosing())) {
                    return;
                }
                if (workbench == null || workbench.isStarting()) {
                    Display.getCurrent().timerExec(6000, (Runnable)this);
                    return;
                }
                IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchWindow window = windows[i];
                    IWorkbenchPage activePage = window.getActivePage();
                    if (activePage != null) {
                        IViewReference[] refs = activePage.getViewReferences();
                        int j = 0;
                        while (j < refs.length) {
                            IViewReference viewReference = refs[j];
                            if ("org.eclipse.ui.views.ProblemView".equals(viewReference.getId())) {
                                try {
                                    activePage.showView(viewReference.getId(), viewReference.getSecondaryId(), 3);
                                }
                                catch (PartInitException e) {
                                    IDEWorkbenchPlugin.log("Could not create Problems view", e.getStatus());
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        };
        Display display = Display.getCurrent();
        if (display != null) {
            display.timerExec(6000, r);
        } else {
            Display.getDefault().asyncExec(r);
        }
    }
}

