/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayoutUtils;
import org.eclipse.ui.internal.e4.migration.IModelBuilderFactory;
import org.eclipse.ui.internal.e4.migration.InfoReader;
import org.eclipse.ui.internal.e4.migration.MementoSerializer;
import org.eclipse.ui.internal.e4.migration.PerspectiveBuilder;
import org.eclipse.ui.internal.e4.migration.PerspectiveReader;
import org.eclipse.ui.internal.e4.migration.WindowReader;

public class WindowBuilder {
    private MWindow window;
    private List<MUIElement> sharedElements;
    private MPartSashContainer mainSash;
    @Inject
    private WindowReader windowReader;
    @Inject
    private EModelService modelService;
    @Inject
    private IModelBuilderFactory factory;
    private ModeledPageLayoutUtils layoutUtils;
    private MArea editorArea;
    private List<MPerspective> perspectives;
    public static String PERSPECTIVES = "perspectives";

    @PostConstruct
    private void postConstruct() {
        this.layoutUtils = new ModeledPageLayoutUtils(this.modelService);
    }

    MWindow createWindow() {
        this.create();
        this.populate();
        return this.window;
    }

    boolean isSelected() {
        return this.windowReader.isSelected();
    }

    boolean isWelcomePageOpen() {
        return this.windowReader.isWelcomePageOpen();
    }

    private void create() {
        this.window = (MWindow)this.modelService.createModelElement(MTrimmedWindow.class);
        Rectangle bounds = this.windowReader.getBounds();
        this.window.setX(bounds.x);
        this.window.setY(bounds.y);
        this.window.setWidth(bounds.width);
        this.window.setHeight(bounds.height);
        this.window.getTags().add("topLevel");
        String coolbarVisible = Boolean.TRUE.toString();
        if (!this.windowReader.isCoolbarVisible() && !this.isWelcomePageOpen()) {
            coolbarVisible = Boolean.FALSE.toString();
        }
        this.window.getPersistedState().put("coolBarVisible", coolbarVisible);
        this.window.getPersistedState().put("perspectiveBarVisible", coolbarVisible);
        if (this.windowReader.isStatusBarVisible()) {
            MTrimBar statusBar = this.modelService.getTrim((MTrimmedWindow)this.window, SideValue.BOTTOM);
            if (this.windowReader.hasStatusLine()) {
                MToolControl statusLine = (MToolControl)this.modelService.createModelElement(MToolControl.class);
                statusLine.setElementId("org.eclipse.ui.StatusLine");
                statusLine.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.StandardTrim");
                statusLine.getTags().add("stretch");
                statusBar.getChildren().add(statusLine);
            }
        }
        List tags = this.window.getTags();
        if (this.windowReader.isMinimized()) {
            tags.add("shellMinimized");
        } else if (this.windowReader.isMaximized()) {
            tags.add("shellMaximized");
        }
        this.sharedElements = this.window.getSharedElements();
    }

    private void populate() {
        this.addEditorArea();
        this.addEditors();
        this.addViews();
        this.perspectives = new ArrayList<MPerspective>();
        this.mainSash = (MPartSashContainer)this.modelService.createModelElement(MPartSashContainer.class);
        this.mainSash.setHorizontal(true);
        MPerspectiveStack perspectiveStack = this.createPerspectiveStack();
        this.mainSash.getChildren().add(perspectiveStack);
        this.mainSash.setSelectedElement((MUIElement)perspectiveStack);
        this.window.getChildren().add(this.mainSash);
        this.window.setSelectedElement((MUIElement)this.mainSash);
        for (PerspectiveReader perspReader : this.windowReader.getPerspectiveReaders()) {
            PerspectiveBuilder builder = this.factory.createPerspectiveBuilder(perspReader);
            MPerspective perspective = builder.createPerspective(this.windowReader.getDefaultFastViewSide());
            perspectiveStack.getChildren().add(perspective);
            MPlaceholder eaPlaceholder = builder.getEditorAreaPlaceholder();
            if (eaPlaceholder != null) {
                eaPlaceholder.setRef((MUIElement)this.editorArea);
            }
            for (MPlaceholder viewPlaceholder : builder.getPlaceholders()) {
                String id = viewPlaceholder.getElementId();
                if (id == null) continue;
                viewPlaceholder.setRef((MUIElement)this.getSharedView(id));
            }
            this.perspectives.add(perspective);
        }
        String activePerspectiveId = this.windowReader.getActivePerspectiveId();
        if (activePerspectiveId != null) {
            for (MPerspective persp : perspectiveStack.getChildren()) {
                String id = persp.getElementId();
                String originalId = (String)persp.getTransientData().get("originalId");
                if (originalId != null) {
                    id = originalId;
                }
                if (!activePerspectiveId.equals(id)) continue;
                perspectiveStack.setSelectedElement((MUIElement)persp);
                this.createTrimBars(persp);
                break;
            }
        }
        this.addStickyFolder();
        this.window.getTransientData().put(PERSPECTIVES, this.perspectives);
    }

    private void createTrimBars(MPerspective perspective) {
        List minimizedElements = this.modelService.findElements((MUIElement)perspective, null, MUIElement.class, Arrays.asList("Minimized"));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element, perspective);
        }
    }

    private int getBarIndex(MUIElement element, String trimStr) {
        String[] stacks;
        if (trimStr == null) {
            return -1;
        }
        String[] stringArray = stacks = trimStr.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                return Integer.parseInt(vals[1]);
            }
            ++n2;
        }
        return -1;
    }

    private int getIndex(MUIElement element, String trimStr) {
        String[] stacks;
        if (trimStr == null) {
            return -1;
        }
        String[] stringArray = stacks = trimStr.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                return Integer.parseInt(vals[2]);
            }
            ++n2;
        }
        return -1;
    }

    private void createTrim(MUIElement element, MPerspective perspective) {
        if (!(this.window instanceof MTrimmedWindow)) {
            return;
        }
        String trimStr = (String)perspective.getPersistedState().get("trims");
        MTrimmedWindow win = (MTrimmedWindow)this.window;
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(perspective);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)this.window);
        if (trimStack == null) {
            trimStack = MenuFactoryImpl.eINSTANCE.createToolControl();
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(TrimStack.CONTRIBUTION_URI);
            trimStack.getTags().add("TrimStack");
            MTrimBar bar = this.getBarForElement(element, win, trimStr);
            int index = this.getIndex(element, trimStr);
            if (index == -1 || index >= bar.getChildren().size()) {
                bar.getChildren().add(trimStack);
            } else {
                bar.getChildren().add(index, trimStack);
            }
            bar.setVisible(true);
        } else {
            MElementContainer parent = trimStack.getParent();
            parent.setVisible(true);
            trimStack.setToBeRendered(true);
        }
    }

    private String getMinimizedElementSuffix(MPerspective perspective) {
        String id = "(minimized)";
        if (perspective != null) {
            id = String.valueOf('(') + perspective.getElementId() + ')';
        }
        return id;
    }

    private MTrimBar getBarForElement(MUIElement element, MTrimmedWindow window, String trimStr) {
        SideValue side = SideValue.get((int)this.getBarIndex(element, trimStr));
        if (side == null) {
            side = SideValue.BOTTOM;
        }
        MTrimBar bar = this.modelService.getTrim(window, side);
        return bar;
    }

    private void addEditors() {
        HashMap<MPartStack, InfoReader> stackToReader = new HashMap<MPartStack, InfoReader>();
        List<InfoReader> stackReaders = this.windowReader.getEditorStacks();
        if (stackReaders.isEmpty()) {
            MPartStack editorStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
            editorStack.getTags().add("EditorStack");
            this.editorArea.getChildren().add(editorStack);
        }
        for (InfoReader stackReader : stackReaders) {
            stackToReader.put(this.addEditorStack(stackReader), stackReader);
        }
        this.editorArea.setSelectedElement((MUIElement)((MPartSashContainerElement)this.editorArea.getChildren().get(0)));
        for (WindowReader.EditorReader editorReader : this.windowReader.getEditors()) {
            MPart editor = (MPart)this.modelService.createModelElement(MPart.class);
            editor.setElementId("org.eclipse.e4.ui.compatibility.editor");
            editor.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor");
            editor.setLabel(editorReader.getLabel());
            editor.getPersistedState().put(Workbench.MEMENTO_KEY, new MementoSerializer(editorReader.getMemento()).serialize());
            List tags = editor.getTags();
            tags.add("Editor");
            tags.add("removeOnHide");
            tags.add(editorReader.getType());
            MPartStack stack = (MPartStack)this.modelService.find(editorReader.getStackId(), (MUIElement)this.editorArea);
            stack.getChildren().add(editor);
            if (!editorReader.isSelected()) continue;
            stack.setSelectedElement((MUIElement)editor);
        }
        for (MPartStack editorStack : stackToReader.keySet()) {
            InfoReader stackReader;
            if (editorStack.getChildren().size() < 2 || (stackReader = (InfoReader)stackToReader.get(editorStack)) == null) continue;
            int[] partOrder = stackReader.getPartOrder();
            List stackChildren = editorStack.getChildren();
            ArrayList originalOrder = new ArrayList(stackChildren);
            MStackElement selectedElement = (MStackElement)editorStack.getSelectedElement();
            stackChildren.clear();
            int i = 0;
            while (i < partOrder.length) {
                stackChildren.add((MStackElement)originalOrder.get(partOrder[i]));
                ++i;
            }
            if (selectedElement == null) continue;
            editorStack.setSelectedElement((MUIElement)selectedElement);
        }
    }

    private MPartStack addEditorStack(InfoReader info) {
        MPartStack stack = this.layoutUtils.createStack(info.getId(), true);
        if (info.isRelativelyPositioned()) {
            MUIElement refElement = this.modelService.find(info.getRelative(), (MUIElement)this.editorArea);
            MElementContainer parent = refElement.getParent();
            if (parent instanceof MPartStack) {
                refElement = parent;
            }
            this.layoutUtils.insert((MUIElement)stack, refElement, this.layoutUtils.plRelToSwt(info.getRelationship()), info.getRatio());
        } else {
            this.editorArea.getChildren().add(stack);
        }
        return stack;
    }

    private void addViews() {
        for (WindowReader.ViewReader viewReader : this.windowReader.getViews()) {
            this.sharedElements.add((MUIElement)this.createView(viewReader));
        }
    }

    private MPart createView(WindowReader.ViewReader viewReader) {
        MPart view = (MPart)this.modelService.createModelElement(MPart.class);
        view.setElementId(viewReader.getId());
        view.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView");
        view.setLabel(viewReader.getLabel());
        view.getTags().add("View");
        view.getPersistedState().put(Workbench.MEMENTO_KEY, new MementoSerializer(viewReader.getViewState()).serialize());
        return view;
    }

    private void addEditorArea() {
        this.editorArea = (MArea)this.modelService.createModelElement(MArea.class);
        this.sharedElements.add((MUIElement)this.editorArea);
        this.editorArea.setElementId("org.eclipse.ui.editorss");
    }

    private MPerspectiveStack createPerspectiveStack() {
        MPerspectiveStack perspStack = (MPerspectiveStack)this.modelService.createModelElement(MPerspectiveStack.class);
        perspStack.setElementId("PerspectiveStack");
        return perspStack;
    }

    private void addStickyFolder() {
        MPartStack stickyFolder = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        stickyFolder.setElementId("stickyFolderRight");
        stickyFolder.setContainerData("2500");
        stickyFolder.setToBeRendered(false);
        this.mainSash.getChildren().add(stickyFolder);
    }

    private MPart getSharedView(String id) {
        MPart part = null;
        for (MUIElement element : this.sharedElements) {
            if (!id.equals(element.getElementId()) || !(element instanceof MPart)) continue;
            part = (MPart)element;
            break;
        }
        return part;
    }
}

