/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native long getAWTHandle(Canvas var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Frame new_Frame(final Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        final long handle = parent.handle;
        final Frame[] result = new Frame[1];
        final Throwable[] exception = new Throwable[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<?> clazz;
                try {
                    clazz = null;
                    try {
                        String className = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.windows.WEmbeddedFrame";
                        clazz = Class.forName(className);
                    }
                    catch (Throwable e) {
                        exception[0] = e;
                        Frame[] frameArray = result;
                        synchronized (result) {
                            result.notify();
                            // ** MonitorExit[var7_4] (shouldn't be in output)
                            return;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Frame[] frameArray = result;
                    synchronized (result) {
                        result.notify();
                        // ** MonitorExit[var7_6] (shouldn't be in output)
                        throw throwable;
                    }
                }
                SWT_AWT.initializeSwing();
                Object value = null;
                Constructor<?> constructor = null;
                try {
                    constructor = clazz.getConstructor(Integer.TYPE);
                    value = constructor.newInstance(new Integer((int)handle));
                }
                catch (Throwable throwable) {
                    try {
                        constructor = clazz.getConstructor(Long.TYPE);
                        value = constructor.newInstance(new Long(handle));
                    }
                    catch (Throwable e2) {
                        exception[0] = e2;
                        Frame[] frameArray = result;
                        synchronized (result) {
                            result.notify();
                            // ** MonitorExit[var7_5] (shouldn't be in output)
                            return;
                        }
                    }
                }
                Frame frame = value;
                try {
                    clazz = Class.forName("sun.awt.windows.WComponentPeer");
                    Field field = clazz.getDeclaredField("winGraphicsConfig");
                    field.setAccessible(true);
                    field.set(frame.getPeer(), frame.getGraphicsConfiguration());
                }
                catch (Throwable throwable) {}
                result[0] = frame;
                Frame[] frameArray = result;
                synchronized (result) {
                    result.notify();
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return;
                }
            }
        };
        if (EventQueue.isDispatchThread() || parent.getDisplay().getSyncThread() != null) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
            OS.ReplyMessage(0L);
            boolean interrupted = false;
            MSG msg = new MSG();
            int flags = 0x400002;
            while (result[0] == null && exception[0] == null) {
                OS.PeekMessage(msg, 0L, 0, 0, flags);
                try {
                    Frame[] frameArray = result;
                    // MONITORENTER : result
                    result.wait(50L);
                    // MONITOREXIT : frameArray
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (exception[0] != null) {
            SWT.error(20, exception[0]);
        }
        final Frame frame = result[0];
        parent.setData(EMBEDDED_FRAME_KEY, frame);
        final Listener shellListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        Shell shell = parent.getShell();
                        shell.removeListener(20, shellListener);
                        shell.removeListener(19, shellListener);
                        parent.setVisible(false);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    frame.dispose();
                                }
                                catch (Throwable throwable) {}
                            }
                        });
                        break;
                    }
                    case 15: 
                    case 26: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                if (frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)frame, Boolean.TRUE);
                                    }
                                }
                                catch (Throwable throwable) {}
                            }
                        });
                        break;
                    }
                    case 27: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                if (!frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)frame, Boolean.FALSE);
                                    }
                                }
                                catch (Throwable throwable) {}
                            }
                        });
                    }
                }
            }
        };
        parent.addListener(15, listener);
        parent.addListener(27, listener);
        parent.addListener(12, listener);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (parent.isDisposed()) {
                    return;
                }
                final Rectangle clientArea = parent.getClientArea();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        frame.setSize(clientArea.width, clientArea.height);
                        frame.validate();
                    }
                });
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas parent) {
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        long handle = 0L;
        try {
            SWT_AWT.loadLibrary();
            handle = SWT_AWT.getAWTHandle(parent);
        }
        catch (Throwable e) {
            SWT.error(20, e);
        }
        if (handle == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.win32_new(display, handle);
        final ComponentAdapter listener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                display.syncExec(new Runnable(){

                    public void run() {
                        if (shell.isDisposed()) {
                            return;
                        }
                        Dimension dim = parent.getSize();
                        shell.setSize(dim.width, dim.height);
                    }
                });
            }
        };
        parent.addComponentListener(listener);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                parent.removeComponentListener(listener);
            }
        });
        shell.setVisible(true);
        return shell;
    }
}

