/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;

public class HttpSessionAdaptor
implements HttpSession,
Serializable {
    private static final long serialVersionUID = 3418610936889860782L;
    private final transient ContextController controller;
    private final transient HttpSession session;
    private final transient ServletContext servletContext;
    private final transient String attributePrefix;
    private final String string;

    public static HttpSessionAdaptor createHttpSessionAdaptor(HttpSession session, ServletContext servletContext, ContextController controller) {
        HttpSessionAdaptor sessionAdaptor = new HttpSessionAdaptor(session, servletContext, controller);
        ParentSessionListener.addHttpSessionAdaptor(sessionAdaptor);
        return sessionAdaptor;
    }

    private HttpSessionAdaptor(HttpSession session, ServletContext servletContext, ContextController controller) {
        this.session = session;
        this.servletContext = servletContext;
        this.controller = controller;
        this.attributePrefix = "equinox.http." + controller.getContextName();
        this.string = String.valueOf(this.getClass().getSimpleName()) + '[' + session.getId() + ", " + this.attributePrefix + ']';
    }

    public ContextController getController() {
        return this.controller;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getAttribute(String arg0) {
        Object result = this.session.getAttribute(String.valueOf(this.attributePrefix) + arg0);
        if (result instanceof HttpSessionAttributeWrapper) {
            result = ((HttpSessionAttributeWrapper)result).value;
        }
        return result;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeNames0());
    }

    private Collection<String> getAttributeNames0() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration containerSessionAttributes = this.session.getAttributeNames();
        while (containerSessionAttributes.hasMoreElements()) {
            String attribute = (String)containerSessionAttributes.nextElement();
            if (!attribute.startsWith(this.attributePrefix)) continue;
            result.add(attribute.substring(this.attributePrefix.length()));
        }
        return result;
    }

    public Object getValue(String arg0) {
        return this.getAttribute(arg0);
    }

    public String[] getValueNames() {
        Collection<String> result = this.getAttributeNames0();
        return result.toArray(new String[result.size()]);
    }

    public void invalidate() {
        HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
        for (HttpSessionListener listener : this.controller.getEventListeners().get(HttpSessionListener.class)) {
            listener.sessionDestroyed(httpSessionEvent);
        }
        try {
            for (String attribute : this.getAttributeNames0()) {
                this.removeAttribute(attribute);
            }
            ParentSessionListener.removeHttpSessionAdaptor(this);
        }
        catch (IllegalStateException illegalStateException) {}
        this.controller.removeActiveSession(this.session);
    }

    public void putValue(String arg0, Object arg1) {
        this.setAttribute(arg0, arg1);
    }

    public void removeAttribute(String arg0) {
        this.session.removeAttribute(String.valueOf(this.attributePrefix) + arg0);
    }

    public void removeValue(String arg0) {
        this.removeAttribute(arg0);
    }

    public void setAttribute(String name, Object value) {
        boolean added = this.session.getAttribute(String.valueOf(this.attributePrefix) + name) == null;
        this.session.setAttribute(String.valueOf(this.attributePrefix) + name, (Object)new HttpSessionAttributeWrapper(this, name, value, added));
    }

    public void setMaxInactiveInterval(int arg0) {
        this.session.setMaxInactiveInterval(arg0);
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public String toString() {
        return this.string;
    }

    class HttpSessionAttributeWrapper
    implements HttpSessionBindingListener,
    HttpSessionActivationListener,
    Serializable {
        private static final long serialVersionUID = 7945998375225990980L;
        final String name;
        final Object value;
        final boolean added;
        final HttpSessionAdaptor innerSession;

        public HttpSessionAttributeWrapper(HttpSessionAdaptor innerSession, String name, Object value, boolean added) {
            this.innerSession = innerSession;
            this.name = name;
            this.value = value;
            this.added = added;
        }

        public void valueBound(HttpSessionBindingEvent event) {
            List<HttpSessionAttributeListener> listeners = this.getEventListeners().get(HttpSessionAttributeListener.class);
            for (HttpSessionAttributeListener listener : listeners) {
                if (this.added) {
                    listener.attributeAdded(event);
                    continue;
                }
                listener.attributeReplaced(event);
            }
            if (this.value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)this.value).valueBound(new HttpSessionBindingEvent((HttpSession)this.innerSession, this.name, this.value));
            }
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (!this.added) {
                List<HttpSessionAttributeListener> listeners = this.getEventListeners().get(HttpSessionAttributeListener.class);
                for (HttpSessionAttributeListener listener : listeners) {
                    listener.attributeRemoved(event);
                }
            }
            if (this.value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)this.value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this.innerSession, this.name, this.value));
            }
        }

        public void sessionWillPassivate(HttpSessionEvent se) {
            if (this.value instanceof HttpSessionActivationListener) {
                ((HttpSessionActivationListener)this.value).sessionWillPassivate(new HttpSessionEvent((HttpSession)this.innerSession));
            }
        }

        public void sessionDidActivate(HttpSessionEvent se) {
            if (this.value instanceof HttpSessionActivationListener) {
                ((HttpSessionActivationListener)this.value).sessionDidActivate(new HttpSessionEvent((HttpSession)this.innerSession));
            }
        }

        private EventListeners getEventListeners() {
            return this.innerSession.getController().getEventListeners();
        }
    }

    static class ParentSessionListener
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 4626167646903550760L;
        private static final String PARENT_SESSION_LISTENER_KEY = "org.eclipse.equinox.http.parent.session.listener";
        final transient Set<HttpSessionAdaptor> innerSessions = new HashSet<HttpSessionAdaptor>();

        ParentSessionListener() {
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueUnbound(HttpSessionBindingEvent event) {
            HashSet<HttpSessionAdaptor> innerSessionsToInvalidate;
            Set<HttpSessionAdaptor> set = this.innerSessions;
            synchronized (set) {
                innerSessionsToInvalidate = new HashSet<HttpSessionAdaptor>(this.innerSessions);
                this.innerSessions.clear();
            }
            for (HttpSessionAdaptor innerSession : innerSessionsToInvalidate) {
                innerSession.invalidate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void addHttpSessionAdaptor(HttpSessionAdaptor innerSession) {
            Object object = ParentSessionListener.class;
            synchronized (ParentSessionListener.class) {
                ParentSessionListener parentListener = (ParentSessionListener)innerSession.getSession().getAttribute(PARENT_SESSION_LISTENER_KEY);
                if (parentListener == null) {
                    parentListener = new ParentSessionListener();
                    innerSession.getSession().setAttribute(PARENT_SESSION_LISTENER_KEY, (Object)parentListener);
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                object = parentListener.innerSessions;
                synchronized (object) {
                    parentListener.innerSessions.add(innerSession);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeHttpSessionAdaptor(HttpSessionAdaptor innerSession) {
            Object object = ParentSessionListener.class;
            synchronized (ParentSessionListener.class) {
                ParentSessionListener parentListener = (ParentSessionListener)innerSession.getSession().getAttribute(PARENT_SESSION_LISTENER_KEY);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                if (parentListener != null) {
                    object = parentListener.innerSessions;
                    synchronized (object) {
                        parentListener.innerSessions.remove(innerSession);
                    }
                }
                return;
            }
        }
    }
}

