/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import org.eclipse.dltk.ui.preferences.IPreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.osgi.util.NLS;

public class PreferenceChangeRebuildPrompt
implements IPreferenceChangeRebuildPrompt {
    private String title;
    private String message;
    private String messageTemplate;

    public PreferenceChangeRebuildPrompt() {
        this(null);
    }

    public PreferenceChangeRebuildPrompt(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public PreferenceChangeRebuildPrompt(boolean workspaceSettings) {
        this.messageTemplate = workspaceSettings ? PreferencesMessages.PreferenceChange_rebuildWorkspaceMessageTemplate : PreferencesMessages.PreferenceChange_rebuildProjectMessageTemplate;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    public String getMessage() {
        if (this.messageTemplate == null || this.messageTemplate.length() == 0) {
            return this.message;
        }
        return NLS.bind((String)this.messageTemplate, (Object)this.message);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public static IPreferenceChangeRebuildPrompt create(boolean workspaceSettings, String title, String message) {
        PreferenceChangeRebuildPrompt prompt = new PreferenceChangeRebuildPrompt(workspaceSettings);
        prompt.setTitle(title);
        prompt.setMessage(message);
        return prompt;
    }

    public static IPreferenceChangeRebuildPrompt create(final String title, final String message) {
        return new IPreferenceChangeRebuildPrompt(){

            @Override
            public String getMessage() {
                return message;
            }

            @Override
            public String getTitle() {
                return title;
            }
        };
    }
}

