/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserDescriptorDialog;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.SWTUtil;
import org.eclipse.ui.internal.browser.SystemBrowserDescriptor;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class WebBrowserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Button internal;
    protected Button external;
    protected Table table;
    protected CheckboxTableViewer tableViewer;
    protected Button edit;
    protected Button remove;
    protected Button search;
    protected Label location;
    protected Label parameters;
    protected IBrowserDescriptor checkedBrowser;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.browser.browser_preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        label.setText(Messages.preferenceWebBrowserDescription);
        data = new GridData(4, 0, false, false);
        data.horizontalSpan = 2;
        data.widthHint = 275;
        label.setLayoutData((Object)data);
        this.internal = new Button(composite, 16);
        this.internal.setText(Messages.prefInternalBrowser);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        this.internal.setLayoutData((Object)data);
        if (!WebBrowserUtil.canUseInternalWebBrowser()) {
            this.internal.setEnabled(false);
        }
        this.external = new Button(composite, 16);
        this.external.setText(Messages.prefExternalBrowser);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        this.external.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText(Messages.browserList);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.table = new Table(composite, 68388);
        data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        new TableColumn(this.table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new BrowserTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BrowserTableLabelProvider());
        this.tableViewer.setInput((Object)BrowserManager.getInstance());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                WebBrowserPreferencePage.this.checkNewDefaultBrowser(e.getElement());
                WebBrowserPreferencePage.this.checkedBrowser = (IBrowserDescriptor)e.getElement();
                Object[] obj = WebBrowserPreferencePage.this.tableViewer.getCheckedElements();
                if (obj.length == 0) {
                    WebBrowserPreferencePage.this.tableViewer.setChecked(e.getElement(), true);
                }
            }
        });
        this.checkedBrowser = BrowserManager.getInstance().getCurrentWebBrowser();
        if (this.checkedBrowser != null) {
            this.tableViewer.setChecked((Object)this.checkedBrowser, true);
        } else {
            Object obj = this.tableViewer.getElementAt(0);
            if (obj != null) {
                this.tableViewer.setChecked(obj, true);
            }
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sele = (IStructuredSelection)WebBrowserPreferencePage.this.tableViewer.getSelection();
                boolean sel = sele.getFirstElement() != null && !(sele.getFirstElement() instanceof SystemBrowserDescriptor);
                WebBrowserPreferencePage.this.remove.setEnabled(sel);
                WebBrowserPreferencePage.this.edit.setEnabled(sel);
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)WebBrowserPreferencePage.this.tableViewer.getSelection();
                Object firstElem = sel.getFirstElement();
                if (firstElem != null && !(firstElem instanceof SystemBrowserDescriptor)) {
                    IBrowserDescriptor browser2 = (IBrowserDescriptor)sel.getFirstElement();
                    IBrowserDescriptorWorkingCopy wc = browser2.getWorkingCopy();
                    BrowserDescriptorDialog dialog = new BrowserDescriptorDialog(WebBrowserPreferencePage.this.getShell(), wc);
                    if (dialog.open() != 1) {
                        try {
                            WebBrowserPreferencePage.this.tableViewer.refresh((Object)wc.save());
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                IStructuredSelection sel;
                if (e.character == '\u007f' && (sel = (IStructuredSelection)WebBrowserPreferencePage.this.tableViewer.getSelection()).getFirstElement() != null) {
                    IBrowserDescriptor browser2 = (IBrowserDescriptor)sel.getFirstElement();
                    try {
                        browser2.delete();
                        WebBrowserPreferencePage.this.tableViewer.remove((Object)browser2);
                        BrowserManager manager = BrowserManager.getInstance();
                        if (browser2 == WebBrowserPreferencePage.this.checkedBrowser && manager.browsers.size() > 0) {
                            WebBrowserPreferencePage.this.checkedBrowser = manager.browsers.get(0);
                            WebBrowserPreferencePage.this.tableViewer.setChecked((Object)WebBrowserPreferencePage.this.checkedBrowser, true);
                        }
                    }
                    catch (Exception exception) {}
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Composite buttonComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(272);
        buttonComp.setLayoutData((Object)data);
        Button add = SWTUtil.createButton(buttonComp, Messages.add);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserDescriptorDialog dialog = new BrowserDescriptorDialog(WebBrowserPreferencePage.this.getShell());
                if (dialog.open() == 1) {
                    return;
                }
                WebBrowserPreferencePage.this.tableViewer.refresh();
                if (WebBrowserPreferencePage.this.checkedBrowser != null) {
                    WebBrowserPreferencePage.this.tableViewer.setChecked((Object)WebBrowserPreferencePage.this.checkedBrowser, true);
                }
            }
        });
        this.edit = SWTUtil.createButton(buttonComp, Messages.edit);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)WebBrowserPreferencePage.this.tableViewer.getSelection();
                IBrowserDescriptor browser2 = (IBrowserDescriptor)sel.getFirstElement();
                IBrowserDescriptorWorkingCopy wc = browser2.getWorkingCopy();
                BrowserDescriptorDialog dialog = new BrowserDescriptorDialog(WebBrowserPreferencePage.this.getShell(), wc);
                if (dialog.open() != 1) {
                    try {
                        WebBrowserPreferencePage.this.tableViewer.refresh((Object)wc.save());
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.remove = SWTUtil.createButton(buttonComp, Messages.remove);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)WebBrowserPreferencePage.this.tableViewer.getSelection();
                IBrowserDescriptor browser2 = (IBrowserDescriptor)sel.getFirstElement();
                try {
                    browser2.delete();
                    WebBrowserPreferencePage.this.tableViewer.remove((Object)browser2);
                    BrowserManager manager = BrowserManager.getInstance();
                    if (browser2 == WebBrowserPreferencePage.this.checkedBrowser && manager.browsers.size() > 0) {
                        WebBrowserPreferencePage.this.checkedBrowser = manager.browsers.get(0);
                        WebBrowserPreferencePage.this.tableViewer.setChecked((Object)WebBrowserPreferencePage.this.checkedBrowser, true);
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.search = SWTUtil.createButton(buttonComp, Messages.search);
        data = (GridData)this.search.getLayoutData();
        data.verticalIndent = 9;
        this.search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ArrayList foundBrowsers = new ArrayList();
                final List<String> existingPaths = WebBrowserUtil.getExternalBrowserPaths();
                DirectoryDialog dialog = new DirectoryDialog(WebBrowserPreferencePage.this.getShell());
                dialog.setMessage(Messages.selectDirectory);
                dialog.setText(Messages.directoryDialogTitle);
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                final File rootDir = new File(path);
                ProgressMonitorDialog pm = new ProgressMonitorDialog(WebBrowserPreferencePage.this.getShell());
                IRunnableWithProgress r = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.searchingTaskName, -1);
                        WebBrowserPreferencePage.search(rootDir, existingPaths, foundBrowsers, new HashSet<String>(), monitor);
                        monitor.done();
                    }
                };
                try {
                    pm.run(true, true, r);
                }
                catch (InvocationTargetException ex) {
                    Trace.trace(Trace.SEVERE, "Invocation Exception occured running monitor: " + ex);
                }
                catch (InterruptedException ex) {
                    Trace.trace(Trace.SEVERE, "Interrupted exception occured running monitor: " + ex);
                    return;
                }
                if (pm.getProgressMonitor().isCanceled()) {
                    return;
                }
                ArrayList browsersToCreate = foundBrowsers;
                if (browsersToCreate.isEmpty()) {
                    WebBrowserUtil.openMessage(Messages.searchingNoneFound);
                    return;
                }
                for (IBrowserDescriptorWorkingCopy browser2 : browsersToCreate) {
                    browser2.save();
                }
                WebBrowserPreferencePage.this.tableViewer.refresh();
                if (WebBrowserPreferencePage.this.checkedBrowser != null) {
                    WebBrowserPreferencePage.this.tableViewer.setChecked((Object)WebBrowserPreferencePage.this.checkedBrowser, true);
                }
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                WebBrowserPreferencePage.this.checkNewDefaultBrowser(e.getElement());
                WebBrowserPreferencePage.this.checkedBrowser = (IBrowserDescriptor)e.getElement();
            }
        });
        this.internal.setSelection(WebBrowserPreference.getBrowserChoice() == 0);
        this.external.setSelection(WebBrowserPreference.getBrowserChoice() == 1);
        IStructuredSelection sele = (IStructuredSelection)this.tableViewer.getSelection();
        boolean sel = sele.getFirstElement() != null && !(sele.getFirstElement() instanceof SystemBrowserDescriptor);
        this.edit.setEnabled(sel);
        this.remove.setEnabled(sel);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(Messages.preferenceWebBrowserTitle);
        }
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    protected void checkNewDefaultBrowser(Object browser) {
        TableItem[] children = this.tableViewer.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (!item.getData().equals(browser)) {
                item.setChecked(false);
            }
            ++i;
        }
    }

    protected static void search(File directory, List<String> existingPaths, List<IBrowserDescriptorWorkingCopy> foundBrowsers, Set<String> directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String canonicalPath = directory.getCanonicalPath();
            if (!directoriesVisited.add(canonicalPath)) {
                return;
            }
        }
        catch (IOException iOException) {}
        monitor.subTask(NLS.bind((String)Messages.searching, (Object[])new String[]{Integer.toString(foundBrowsers.size()), directory.getAbsolutePath()}));
        String[] names = directory.list();
        ArrayList<File> subDirs = new ArrayList<File>();
        int i = 0;
        while (i < names.length) {
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, names[i]);
            if (!existingPaths.contains(file.getAbsolutePath().toLowerCase())) {
                IBrowserDescriptorWorkingCopy wc = WebBrowserUtil.createExternalBrowser(file);
                if (wc != null) {
                    foundBrowsers.add(wc);
                }
                if (file.isDirectory()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    subDirs.add(file);
                }
            }
            ++i;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            WebBrowserPreferencePage.search(subDir, existingPaths, foundBrowsers, directoriesVisited, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    protected void performDefaults() {
        this.internal.setSelection(WebBrowserPreference.isDefaultUseInternalBrowser());
        this.external.setSelection(!WebBrowserPreference.isDefaultUseInternalBrowser());
        BrowserManager.getInstance().currentBrowser = null;
        BrowserManager.getInstance().setupDefaultBrowsers();
        this.tableViewer.refresh();
        this.checkedBrowser = BrowserManager.getInstance().getCurrentWebBrowser();
        if (this.checkedBrowser != null) {
            this.tableViewer.setChecked((Object)this.checkedBrowser, true);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        int choice = this.internal.getSelection() ? 0 : 1;
        WebBrowserPreference.setBrowserChoice(choice);
        if (this.checkedBrowser != null) {
            BrowserManager.getInstance().setCurrentWebBrowser(this.checkedBrowser);
        } else {
            BrowserManager.getInstance().saveBrowsers();
        }
        return true;
    }

    public boolean performCancel() {
        BrowserManager.getInstance().loadBrowsers();
        return super.performCancel();
    }

    class BrowserTableContentProvider
    implements IStructuredContentProvider {
        private BrowserManager input;

        BrowserTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = (BrowserManager)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.input.getWebBrowsers().toArray();
        }

        public void dispose() {
        }
    }

    class BrowserTableLabelProvider
    implements ITableLabelProvider {
        BrowserTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IBrowserDescriptor browser = (IBrowserDescriptor)element;
            return this.notNull(browser.getName());
        }

        protected String notNull(String s) {
            if (s == null) {
                return "";
            }
            return s;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

