/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.text.ScriptBreakIterator;

public class DLTKWordIterator
extends BreakIterator {
    private ScriptBreakIterator fIterator = new ScriptBreakIterator();
    private int fIndex;

    public DLTKWordIterator() {
        this.first();
    }

    public int first() {
        this.fIndex = this.fIterator.first();
        return this.fIndex;
    }

    public int last() {
        this.fIndex = this.fIterator.last();
        return this.fIndex;
    }

    public int next(int n) {
        int next = 0;
        while (--n > 0 && next != -1) {
            next = this.next();
        }
        return next;
    }

    public int next() {
        this.fIndex = this.following(this.fIndex);
        return this.fIndex;
    }

    public int previous() {
        this.fIndex = this.preceding(this.fIndex);
        return this.fIndex;
    }

    public int preceding(int offset) {
        int second;
        int first = this.fIterator.preceding(offset);
        if (this.isWhitespace(first, offset) && (second = this.fIterator.preceding(first)) != -1 && !this.isDelimiter(second, first)) {
            return second;
        }
        return first;
    }

    public int following(int offset) {
        int second;
        int first = this.fIterator.following(offset);
        if (this.eatFollowingWhitespace(offset, first) && this.isWhitespace(first, second = this.fIterator.following(first))) {
            return second;
        }
        return first;
    }

    private boolean eatFollowingWhitespace(int offset, int exclusiveEnd) {
        if (exclusiveEnd == -1 || offset == -1) {
            return false;
        }
        if (this.isWhitespace(offset, exclusiveEnd)) {
            return false;
        }
        return !this.isDelimiter(offset, exclusiveEnd);
    }

    private boolean isDelimiter(int offset, int exclusiveEnd) {
        if (exclusiveEnd == -1 || offset == -1) {
            return false;
        }
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((exclusiveEnd <= this.getText().getEndIndex() ? 1 : 0) != 0);
        Assert.isTrue((exclusiveEnd > offset ? 1 : 0) != 0);
        CharSequence seq = this.fIterator.fText;
        while (offset < exclusiveEnd) {
            char ch = seq.charAt(offset);
            if (ch != '\n' && ch != '\r') {
                return false;
            }
            ++offset;
        }
        return true;
    }

    private boolean isWhitespace(int offset, int exclusiveEnd) {
        if (exclusiveEnd == -1 || offset == -1) {
            return false;
        }
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((exclusiveEnd <= this.getText().getEndIndex() ? 1 : 0) != 0);
        Assert.isTrue((exclusiveEnd > offset ? 1 : 0) != 0);
        CharSequence seq = this.fIterator.fText;
        while (offset < exclusiveEnd) {
            char ch = seq.charAt(offset);
            if (!Character.isWhitespace(ch)) {
                return false;
            }
            if (ch == '\n' || ch == '\r') {
                return false;
            }
            ++offset;
        }
        return true;
    }

    public int current() {
        return this.fIndex;
    }

    public CharacterIterator getText() {
        return this.fIterator.getText();
    }

    public void setText(CharSequence newText) {
        this.fIterator.setText(newText);
        this.first();
    }

    public void setText(CharacterIterator newText) {
        this.fIterator.setText(newText);
        this.first();
    }

    public void setText(String newText) {
        this.setText((CharSequence)newText);
    }
}

