/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaDLTKModelUtils;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.navigation.Messages;

public class LuaCompletionProposalLabelProvide
extends CompletionProposalLabelProvider {
    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodProposal.getName());
        buffer.append('(');
        this.appendParameterList(buffer, methodProposal);
        buffer.append(')');
        IModelElement element = methodProposal.getModelElement();
        if (element != null && element.getElementType() == 9 && element.exists()) {
            IMethod method = (IMethod)element;
            try {
                if (!method.isConstructor()) {
                    IType declaringType;
                    String type = method.getType();
                    if (type != null) {
                        buffer.append(" : ").append(type);
                    }
                    if ((declaringType = method.getDeclaringType()) != null) {
                        buffer.append(" - ").append(declaringType.getElementName());
                    }
                }
            }
            catch (ModelException modelException) {}
        }
        return buffer.toString();
    }

    protected String createSimpleLabelWithType(CompletionProposal proposal) {
        ILocalVariable var;
        String type;
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 13 && element.exists() && (type = (var = (ILocalVariable)element).getType()) != null) {
            return String.valueOf(proposal.getName()) + " : " + type;
        }
        return proposal.getName();
    }

    protected String createFieldProposalLabel(CompletionProposal proposal) {
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 8 && element.exists()) {
            IField field = (IField)element;
            try {
                String type = field.getType();
                if (type != null) {
                    return String.valueOf(proposal.getName()) + " : " + type;
                }
            }
            catch (ModelException modelException) {}
        }
        return proposal.getName();
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof IMember) {
            IMember member = (IMember)proposal.getModelElement();
            try {
                if (member.exists()) {
                    if (member instanceof IType) {
                        if (LuaDLTKModelUtils.isModule((IMember)member)) {
                            return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module.gif");
                        }
                        if (LuaDLTKModelUtils.isGlobalTable((IMember)member)) {
                            return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/global_table.gif");
                        }
                        if (LuaDLTKModelUtils.isLocalTable((IMember)member)) {
                            return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/local_table.gif");
                        }
                    } else if (LuaDLTKModelUtils.isModuleFunction((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module_function.gif");
                    }
                }
            }
            catch (ModelException e) {
                Activator.logError(Messages.LuaCompletionProvidersFlags, e);
                return super.createImageDescriptor(proposal);
            }
        }
        return super.createImageDescriptor(proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof IMember) {
            IMember member = (IMember)proposal.getModelElement();
            try {
                if (member.exists()) {
                    if (member instanceof IType) {
                        if (LuaDLTKModelUtils.isModule((IMember)member)) {
                            return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module.gif");
                        }
                        if (LuaDLTKModelUtils.isGlobalTable((IMember)member)) {
                            return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/global_table.gif");
                        }
                        if (LuaDLTKModelUtils.isLocalTable((IMember)member)) {
                            return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/local_table.gif");
                        }
                    } else if (LuaDLTKModelUtils.isModuleFunction((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module_function.gif");
                    }
                }
            }
            catch (ModelException e) {
                Activator.logError(Messages.LuaCompletionProvidersFlags, e);
                return super.createImageDescriptor(proposal);
            }
        }
        return super.createImageDescriptor(proposal);
    }
}

