/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.linuxtools.internal.oprofile.core.IOpcontrolProvider;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.launching.AbstractOprofileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.tools.launch.core.properties.LinuxtoolsPathProperty;
import org.eclipse.swt.widgets.Display;

public class OprofileLaunchConfigurationDelegate
extends AbstractOprofileLaunchConfigurationDelegate {
    @Override
    protected boolean preExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents, ILaunch launch) {
        IProject project;
        block5: {
            try {
                project = this.getProject();
                Oprofile.OprofileProject.setProject((IProject)project);
                if (this.oprofileStatus()) break block5;
                OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", null);
                return false;
            }
            catch (OpcontrolException oe) {
                OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                return false;
            }
        }
        if (Oprofile.OprofileProject.getProfilingBinary().equals("opcontrol")) {
            IOpcontrolProvider provider;
            if (!LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project).isEmpty() && !(provider = OprofileCorePlugin.getDefault().getOpcontrolProvider()).hasPermissions(project)) {
                throw new OpcontrolException(OprofileCorePlugin.createErrorStatus((String)"opcontrolSudo", null));
            }
            this.oprofileShutdown();
            this.oprofileReset();
            this.oprofileSetupDaemon(options.getOprofileDaemonOptions(), daemonEvents);
            this.oprofileStartCollection();
        }
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationWatcher(launch, options.getExecutionsNumber()));
        return true;
    }

    @Override
    protected void postExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents, Process process) {
    }

    class LaunchTerminationWatcher
    implements ILaunchesListener2 {
        private ILaunch launch;
        private int executions;

        public LaunchTerminationWatcher(ILaunch il, int executions) {
            this.launch = il;
            this.executions = executions;
        }

        public void launchesTerminated(ILaunch[] launches) {
            try {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch l = iLaunchArray[n2];
                    if (l.equals(this.launch) && l.getProcesses().length == this.executions) {
                        if (Oprofile.OprofileProject.getProfilingBinary().equals("opcontrol")) {
                            OprofileLaunchConfigurationDelegate.this.oprofileDumpSamples();
                            OprofileLaunchConfigurationDelegate.this.oprofileShutdown();
                        }
                        if (!Oprofile.OprofileProject.getProfilingBinary().equals("ocount")) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    OprofileLaunchConfigurationDelegate.this.refreshOprofileView();
                                }
                            });
                        }
                    }
                    ++n2;
                }
            }
            catch (OpcontrolException oe) {
                OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

