/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.util.Arrays;
import org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ErrorTableDisplay {
    private final MouseListener mouseListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent me) {
            String location = ErrorTableDisplay.this.table.getSelection()[0].getText(4);
            if (location.length() > 0) {
                int line = 0;
                if (location.indexOf(58) > 0) {
                    String[] pos = location.split(":");
                    line = Integer.parseInt(pos[0]);
                } else {
                    line = Integer.parseInt(location);
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart ed = page.getActiveEditor();
                if (ed instanceof SimpleEditor) {
                    SimpleEditor editor = (SimpleEditor)ed;
                    editor.selectLine(line);
                    editor.setFocus();
                }
            }
        }
    };
    private Table table;
    private String[] titles;
    private TableItem item;

    public ErrorTableDisplay(Composite parent, String[] titles) {
        this.titles = Arrays.copyOf(titles, titles.length);
        this.createControl(parent);
    }

    private void createControl(Composite parent) {
        this.table = new Table(parent, 4);
        this.table.setHeaderVisible(true);
        this.table.getVerticalBar().setVisible(true);
        this.table.setLinesVisible(true);
        this.table.addMouseListener(this.mouseListener);
        String[] stringArray = this.titles;
        int n = this.titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(title);
            ++n2;
        }
        this.updateColumns();
    }

    public void clear() {
        this.table.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorTableDisplay.this.table.removeAll();
            }
        });
    }

    public void addRow(String[] row) {
        this.addRow(row, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.systemtap.ui.consolelog", (String)"icons/views/error_st_obj.gif").createImage());
    }

    private void addRow(final String[] row, final Image img) {
        this.table.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorTableDisplay.this.item = new TableItem(ErrorTableDisplay.this.table, 0);
                int i = 0;
                while (i < row.length) {
                    ErrorTableDisplay.this.item.setText(i + 1, row[i]);
                    ++i;
                }
                ErrorTableDisplay.this.item.setImage(img);
                ErrorTableDisplay.this.updateColumns();
            }
        });
    }

    private void updateColumns() {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = this.table.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            column.setMoveable(true);
            ++n2;
        }
    }

    public Control getControl() {
        return this.table;
    }

    public void dispose() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.removeMouseListener(this.mouseListener);
            this.table.dispose();
            this.table = null;
        }
        if (this.titles != null) {
            int i = 0;
            while (i < this.titles.length) {
                this.titles[i] = null;
                ++i;
            }
        }
        this.titles = null;
        if (this.item != null) {
            this.item.dispose();
        }
        this.item = null;
    }
}

