/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.editor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.editor.Localization;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.editor.SimpleDocumentProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SimpleEditor
extends TextEditor {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor";

    public SimpleEditor() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.linuxtools.systemtap.ui.ide.context"});
        this.internalInit();
    }

    protected void internalInit() {
        this.configureInsertMode(SMART_INSERT, false);
        this.setDocumentProvider((IDocumentProvider)new SimpleDocumentProvider());
    }

    public int find(String search) {
        return this.findWithOptions(search, false);
    }

    public int findRegex(String regex) {
        return this.findWithOptions(regex, true);
    }

    private int findWithOptions(String search, boolean regExSearch) {
        IDocument doc = this.getSourceViewer().getDocument();
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(doc);
        int line = 0;
        this.jumpToLocation(0, 0);
        try {
            IRegion reg = finder.find(0, search, true, !regExSearch, false, regExSearch);
            int offset = reg.getOffset();
            line = doc.getLineOfOffset(offset);
        }
        catch (BadLocationException reg) {
        }
        catch (NullPointerException npe) {
            line = -1;
        }
        return line;
    }

    public void jumpToLocation(int line, int character) {
        IDocument doc = this.getSourceViewer().getDocument();
        try {
            int offset = doc.getLineOffset(line - 1) + character;
            this.getSelectionProvider().setSelection((ISelection)new TextSelection(doc, offset, 0));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void selectLine(int line) {
        IDocument doc = this.getSourceViewer().getDocument();
        try {
            this.getSelectionProvider().setSelection((ISelection)new TextSelection(doc, doc.getLineOffset(line - 1), doc.getLineLength(line - 1) - 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSaveAs() {
        IEditorInput inputFile;
        block16: {
            File file = SimpleEditor.queryFile();
            if (file == null) {
                return;
            }
            inputFile = SimpleEditor.createEditorInput(file);
            IDocument doc = this.getSourceViewer().getDocument();
            String s = doc.get();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        try (PrintStream ps = new PrintStream(fos);){
                            ps.print(s);
                            ps.close();
                        }
                        if (fos == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setInput(inputFile);
        this.setPartName(inputFile.getName());
    }

    private static IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        return new PathEditorInput((IPath)location);
    }

    public void insertText(String text) {
        IDocument doc = this.getSourceViewer().getDocument();
        String s = doc.get();
        int offset = s.length();
        s = String.valueOf(s) + text;
        doc.set(s);
        this.setHighlightRange(offset, 0, true);
    }

    public void insertTextAtCurrent(String text) {
        ISelection selection = this.getSelectionProvider().getSelection();
        IDocument doc = this.getSourceViewer().getDocument();
        if (selection instanceof ITextSelection) {
            ITextSelection s = (ITextSelection)selection;
            StringBuffer sb = new StringBuffer(doc.get().substring(0, s.getOffset()));
            sb.append(text.trim());
            sb.append(doc.get().substring(s.getOffset() + s.getLength(), doc.get().length()));
            doc.set(sb.toString());
            this.setHighlightRange(s.getOffset() + text.trim().length(), 0, true);
        }
    }

    private static File queryFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setText(Localization.getString("NewFileAction.NewFile"));
        String path = dialog.open();
        if (path != null && !path.isEmpty()) {
            return new File(path);
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }
}

