/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts;

import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.Messages;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.Range;

public class BarChart
extends Chart {
    private static final int MIN_LABEL_SIZE = Messages.BarChartBuilder_LabelTrimTag.length();
    private final int fontSize = this.getFont().getFontData()[0].getHeight();
    private double[][] actualYSeries;
    private String[] fullLabels = null;
    private IAxis xAxis = this.getAxisSet().getXAxis(0);
    private boolean updateSuspended = false;

    public void suspendUpdate(boolean suspend) {
        if (this.updateSuspended == suspend) {
            return;
        }
        this.updateSuspended = suspend;
        if (!suspend) {
            this.updateLayout();
        }
    }

    public BarChart(Composite parent, int style) {
        super(parent, style);
        this.xAxis.enableCategory(true);
        this.xAxis.setCategorySeries(new String[]{""});
    }

    public void setCategorySeries(String[] series) {
        this.xAxis.setCategorySeries(series);
        this.fullLabels = this.xAxis.getCategorySeries();
    }

    public double getBarValue(int series, int barIndex) {
        return this.actualYSeries[series][barIndex];
    }

    public String[] getCategorySeries() {
        String[] copiedCategorySeries = null;
        if (this.fullLabels != null) {
            copiedCategorySeries = new String[this.fullLabels.length];
            System.arraycopy(this.fullLabels, 0, copiedCategorySeries, 0, this.fullLabels.length);
        }
        return copiedCategorySeries;
    }

    public void updateLayout() {
        if (this.updateSuspended) {
            return;
        }
        if (this.fullLabels != null) {
            this.hideBars();
            String[] labels = this.xAxis.getCategorySeries();
            if (labels != null && labels.length > 0) {
                String[] trimmedLabels = null;
                trimmedLabels = this.fitLabels(this.fullLabels);
                int i = 0;
                while (i < this.fullLabels.length) {
                    if (!trimmedLabels[i].equals(labels[i])) {
                        labels = trimmedLabels;
                        break;
                    }
                    ++i;
                }
                if (labels == trimmedLabels) {
                    this.updateSuspended = true;
                    this.xAxis.setCategorySeries(labels);
                    this.updateSuspended = false;
                }
            }
        }
        super.updateLayout();
    }

    private String[] fitLabels(String[] labels) {
        Range range = this.xAxis.getRange();
        int maxLabelSize = (int)Math.max((double)this.getClientArea().width / (Math.max(range.upper - range.lower, 1.0) * (double)this.fontSize), (double)MIN_LABEL_SIZE);
        String[] trimlabels = new String[labels.length];
        int i = 0;
        while (i < labels.length) {
            trimlabels[i] = labels[i].length() > maxLabelSize ? labels[i].substring(0, maxLabelSize - MIN_LABEL_SIZE).concat(Messages.BarChartBuilder_LabelTrimTag) : labels[i];
            ++i;
        }
        return trimlabels;
    }

    private void hideBars() {
        Range rangeX = this.xAxis.getRange();
        double bottomY = this.getAxisSet().getYAxis((int)0).getRange().lower;
        double nonNegBottomY = Math.max(0.0, bottomY);
        ISeries[] allSeries = this.getSeriesSet().getSeries();
        this.actualYSeries = new double[allSeries.length][];
        int i = 0;
        int n = allSeries.length;
        while (i < n) {
            double[] yseries = allSeries[i].getYSeries();
            if (yseries == null) {
                return;
            }
            this.actualYSeries[i] = new double[yseries.length];
            System.arraycopy(yseries, 0, this.actualYSeries[i], 0, yseries.length);
            int x = (int)rangeX.lower;
            while (x <= (int)rangeX.upper) {
                if (yseries[x] < bottomY) {
                    yseries[x] = bottomY;
                }
                ++x;
            }
            if ((double)(yseries.length - 1) > rangeX.upper) {
                yseries[(int)rangeX.upper + 1] = nonNegBottomY;
            }
            allSeries[i].setYSeries(yseries);
            ++i;
        }
    }
}

