/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers;

import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapScriptLaunch;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.EnvironmentVariablesPreferencePage;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.StapErrorParser;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpClient;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.RemoteScriptOptions;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.ResourceUtil;

public class RunScriptHandler
extends AbstractHandler {
    private RemoteScriptOptions remoteOptions = null;
    private IEditorPart targetEditor = null;
    private String fileName = null;
    private String tmpfileName = null;
    private IPath path = null;
    private IProject project = null;
    private SystemTapScriptLaunch launch = null;
    private final List<String> cmdList = new ArrayList<String>();

    public void setPath(IPath path) {
        this.path = path;
        URI uri = URIUtil.toURI((IPath)path);
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        if (files.length > 0) {
            this.project = files[0].getProject();
        }
    }

    public void setLaunch(SystemTapScriptLaunch launch) {
        this.launch = launch;
    }

    public void addComandLineOptions(String option) {
        this.cmdList.add(option);
    }

    public void setRemoteScriptOptions(RemoteScriptOptions remoteOptions) {
        this.remoteOptions = remoteOptions;
    }

    public boolean getRunLocal() {
        return this.remoteOptions == null;
    }

    public IProject getProject() {
        return this.project;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.executeAction(event);
        }
        catch (ExecutionException e) {
            if (event != null) {
                ExceptionErrorDialog.openError((String)Localization.getString("RunScriptHandler.Error"), (String)Localization.getString("RunScriptHandler.ErrorMessage"), (Exception)((Object)e));
            }
            throw e;
        }
        return null;
    }

    private void executeAction(ExecutionEvent event) throws ExecutionException {
        this.cmdList.clear();
        boolean local = this.getRunLocal();
        this.findTargetEditor(event);
        this.findFilePath();
        this.tryEditorSave(event);
        if (!local) {
            this.prepareNonLocalScript();
        }
        String[] script = this.buildStandardScript();
        String[] envVars = EnvironmentVariablesPreferencePage.getEnvironmentVariables();
        Display.getDefault().asyncExec(() -> {
            MessageDialog dialog;
            String name = this.getConsoleName();
            if (ScriptConsole.instanceIsRunning((String)name) && (dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.RunScriptHandler_AlreadyRunningDialogTitle, null, MessageFormat.format(Messages.RunScriptHandler_AlreadyRunningDialogMessage, this.fileName), 3, new String[]{"Yes", "No"}, 0)).open() != 0) {
                if (this.launch != null) {
                    this.launch.forceRemove();
                }
                return;
            }
            ScriptConsole console = ScriptConsole.getInstance((String)name);
            if (!local) {
                console.run(script, envVars, this.remoteOptions, (IErrorParser)new StapErrorParser());
            } else {
                console.runLocally(script, envVars, (IErrorParser)new StapErrorParser(), this.getProject());
            }
            this.scriptConsoleInitialized(console);
        });
    }

    private String getConsoleName() {
        return this.getRunLocal() ? this.fileName : MessageFormat.format(Messages.RunScriptHandler_NonLocalTitle, this.fileName, this.remoteOptions.userName, this.remoteOptions.hostName);
    }

    protected void scriptConsoleInitialized(ScriptConsole console) {
        if (this.launch != null && this.path != null) {
            this.launch.setConsole(console);
        }
    }

    private void findTargetEditor(ExecutionEvent event) {
        if (event != null) {
            this.targetEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        } else {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage activePage = window.getActivePage();
                IEditorPart edTest = activePage.getActiveEditor();
                if (edTest != null && this.editorMatchesPath(edTest.getEditorInput())) {
                    this.targetEditor = edTest;
                } else {
                    IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
                    int n3 = iEditorReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference ref = iEditorReferenceArray[n4];
                        try {
                            if (this.editorMatchesPath(ref.getEditorInput())) {
                                this.targetEditor = ref.getEditor(false);
                                break;
                            }
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private boolean editorMatchesPath(IEditorInput input) {
        return input instanceof IPathEditorInput && ((IPathEditorInput)input).getPath().equals((Object)this.path);
    }

    private void findFilePath() throws ExecutionException {
        if (this.path != null) {
            this.fileName = this.path.toOSString();
        } else {
            if (this.targetEditor == null) {
                throw new ExecutionException(Localization.getString("RunScriptHandler.noScriptFile"));
            }
            this.fileName = this.targetEditor.getEditorInput() instanceof PathEditorInput ? ((PathEditorInput)this.targetEditor.getEditorInput()).getPath().toString() : ResourceUtil.getFile((IEditorInput)this.targetEditor.getEditorInput()).getLocation().toString();
        }
    }

    private void tryEditorSave(ExecutionEvent event) {
        if (this.project != null) {
            return;
        }
        if (this.targetEditor != null && this.targetEditor.isDirty()) {
            Display.getDefault().syncExec(() -> {
                Shell shell = event != null ? HandlerUtil.getActiveShell((ExecutionEvent)event) : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                this.targetEditor.doSave((IProgressMonitor)new ProgressMonitorPart((Composite)shell, (Layout)new FillLayout()));
            });
        }
    }

    private void prepareNonLocalScript() throws ExecutionException {
        try {
            ScpClient scpclient = new ScpClient(this.remoteOptions);
            this.tmpfileName = new Path("/tmp").append(this.getFileName(this.fileName)).toOSString();
            scpclient.transfer(this.fileName, this.tmpfileName);
        }
        catch (JSchException | IOException e) {
            String message = e instanceof JSchException ? Localization.getString("RunScriptHandler.checkCredentials") : Localization.getString("RunScriptHandler.ioError");
            throw new ExecutionException(message, e);
        }
    }

    private String getFileName(String fileName) {
        return new File(fileName).getName();
    }

    private String[] buildStandardScript() throws ExecutionException {
        this.getImportedTapsets();
        if (this.isGuru()) {
            this.cmdList.add("-g");
        }
        return this.finalizeScript();
    }

    private void getImportedTapsets() {
        IPreferenceStore preferenceStore = IDEPlugin.getDefault().getPreferenceStore();
        String[] tapsets = preferenceStore.getString("TapsetPreference").split(File.pathSeparator);
        if (tapsets.length > 0 && tapsets[0].trim().length() > 0) {
            int i = 0;
            while (i < tapsets.length) {
                this.cmdList.add("-I");
                this.cmdList.add(tapsets[i]);
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isGuru() throws ExecutionException {
        File f = new File(this.fileName);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileReader fr = new FileReader(f);){
                int curr = 0;
                int prev = 0;
                boolean front = false;
                boolean embedded = false;
                boolean inLineComment = false;
                boolean inBlockComment = false;
                while (-1 != (curr = fr.read())) {
                    if (!inLineComment && !inBlockComment && prev == 37 && curr == 123) {
                        front = true;
                    } else {
                        if (!inLineComment && !inBlockComment && prev == 37 && curr == 125 && front) {
                            embedded = true;
                            break;
                        }
                        if (!inBlockComment && (prev == 47 && curr == 47 || curr == 35)) {
                            inLineComment = true;
                        } else if (!inLineComment && prev == 47 && curr == 42) {
                            inBlockComment = true;
                        } else if (curr == 10) {
                            inLineComment = false;
                        } else if (prev == 42 && curr == 47) {
                            inBlockComment = false;
                        }
                    }
                    prev = curr;
                }
                if (!embedded) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ExecutionException(Localization.getString("RunScriptHandler.couldNotOpenScriptFile"), (Throwable)fnfe);
        }
        catch (IOException ie) {
            throw new ExecutionException(Localization.getString("RunScriptHandler.fileIOError"), (Throwable)ie);
        }
    }

    private String[] finalizeScript() throws ExecutionException {
        if (!Pattern.matches("^[a-z0-9_A-Z]+$", this.getFileNameWithoutExtension(this.getFileName(this.fileName)))) {
            throw new ExecutionException(Messages.RunScriptHandler_InvalidScriptMessage);
        }
        String[] script = new String[this.cmdList.size() + 2];
        script[0] = "stap";
        script[script.length - 1] = !this.getRunLocal() ? this.tmpfileName : this.fileName;
        int i = 0;
        while (i < this.cmdList.size()) {
            script[i + 1] = this.cmdList.get(i);
            ++i;
        }
        return script;
    }

    private String getFileNameWithoutExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex != -1 ? fileName.substring(0, dotIndex) : fileName;
    }
}

