/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.editors;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfCodeScanner;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfDocumentProvider;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfEditorMacroValidator;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfEditorMessages;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfErrorHandler;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfMacroCodeScanner;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfPartitionScanner;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfSourceViewerConfiguration;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.IAutotoolEditorActionDefinitionIds;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.IAutotoolHelpContextIds;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.IAutotoolsEditor;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.outline.AutoconfContentOutlinePage;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.AutoconfElement;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.AutoconfMacroDetector;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.AutoconfParser;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.autoconf.ProjectionFileUpdater;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IReconcilingParticipant;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.preferences.AutoconfEditorPreferencePage;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.preferences.AutotoolsEditorPreferenceConstants;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.preferences.ColorManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.properties.AutotoolsPropertyManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.properties.IProjectPropertyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AutoconfEditor
extends TextEditor
implements IAutotoolsEditor,
IProjectPropertyListener {
    public static final String AUTOCONF_PARTITIONING = "autoconf_partitioning";
    private AutoconfPartitionScanner fPartitionScanner;
    private RuleBasedScanner fCodeScanner;
    private RuleBasedScanner fMacroCodeScanner;
    private static AutoconfDocumentProvider fDocumentProvider;
    private AutoconfElement rootElement;
    private AutoconfContentOutlinePage outlinePage;
    private AutoconfParser fParser;
    private IEditorInput input;
    private IProject fProject;
    private InformationPresenter fInformationPresenter;
    ProjectionSupport fProjectionSupport;
    ProjectionFileUpdater fProjectionFileUpdater;
    private ListenerList fReconcilingListeners = new ListenerList(1);

    protected void initializeEditor() {
        super.initializeEditor();
        this.setDocumentProvider((IDocumentProvider)AutoconfEditor.getAutoconfDocumentProvider());
        IPreferenceStore[] stores = new IPreferenceStore[]{AutotoolsPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(stores);
        this.setPreferenceStore((IPreferenceStore)chainedStore);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AutoconfSourceViewerConfiguration((IPreferenceStore)chainedStore, this));
        AutotoolsEditorPreferenceConstants.initializeDefaultValues(stores[0]);
        AutoconfEditorPreferencePage.initDefaults(stores[0]);
    }

    public static AutoconfDocumentProvider getAutoconfDocumentProvider() {
        if (fDocumentProvider == null) {
            fDocumentProvider = new AutoconfDocumentProvider();
        }
        return fDocumentProvider;
    }

    public AutoconfElement getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(AutoconfElement element) {
        this.rootElement = element;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected IDocument getInputDocument() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.input);
        return document;
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        if (this.fProject != null) {
            AutotoolsPropertyManager.getDefault().removeProjectPropertyListener(this.fProject, this);
        }
        this.fProject = null;
        super.doSetInput(newInput);
        this.input = newInput;
        if (this.input instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)this.input).getFile();
            this.fProject = f.getProject();
            AutotoolsPropertyManager.getDefault().addProjectPropertyListener(this.fProject, this);
        }
        this.getOutlinePage().setInput(this.input);
        try {
            IDocument document = this.getInputDocument();
            this.setRootElement(this.reparseDocument(document, newInput));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getAdapter(Class required) {
        if (ProjectionAnnotationModel.class.equals((Object)required)) {
            Object result;
            if (this.fProjectionSupport != null && (result = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
                return result;
            }
        } else if (IContentOutlinePage.class.equals((Object)required)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(required);
    }

    public AutoconfContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new AutoconfContentOutlinePage(this);
            if (this.getEditorInput() != null) {
                this.outlinePage.setInput(this.getEditorInput());
            }
        }
        return this.outlinePage;
    }

    public AutoconfParser getAutoconfParser() {
        if (this.fParser == null) {
            AutoconfErrorHandler errorHandler = new AutoconfErrorHandler(this.input);
            AutoconfEditorMacroValidator macroValidator = new AutoconfEditorMacroValidator(this);
            this.fParser = new AutoconfParser(errorHandler, new AutoconfMacroDetector(), macroValidator);
        }
        return this.fParser;
    }

    public AutoconfPartitionScanner getAutoconfPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new AutoconfPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public RuleBasedScanner getAutoconfCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new AutoconfCodeScanner();
        }
        return this.fCodeScanner;
    }

    public RuleBasedScanner getAutoconfMacroCodeScanner() {
        if (this.fMacroCodeScanner == null) {
            this.fMacroCodeScanner = new AutoconfMacroCodeScanner();
        }
        return this.fMacroCodeScanner;
    }

    public static Color getPreferenceColor(String key) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)AutotoolsPlugin.getDefault().getPreferenceStore(), (String)key));
    }

    public void handleProjectPropertyChanged(IProject project, String property) {
        if (property.equals("AutoconfEditorMacroVersioning")) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            this.handleVersionChange(sourceViewer);
        }
    }

    protected void handleVersionChange(ISourceViewer sourceViewer) {
        sourceViewer.invalidateTextPresentation();
        try {
            IDocument document = this.getInputDocument();
            this.setRootElement(this.reparseDocument(document, this.getEditorInput()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AutoconfElement reparseDocument(IDocument document, IEditorInput editorInput) {
        AutoconfParser parser = this.getAutoconfParser();
        ((AutoconfErrorHandler)parser.getErrorHandler()).removeAllExistingMarkers();
        return parser.parse(document);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        String property = event.getProperty();
        AutoconfCodeScanner scanner = (AutoconfCodeScanner)this.getAutoconfCodeScanner();
        if (scanner != null && scanner.affectsBehavior(event)) {
            scanner.adaptToPreferenceChange(event);
            sourceViewer.invalidateTextPresentation();
        }
        if ("autoconf_version".equals(property) || "automake_version".equals(property)) {
            this.handleVersionChange(sourceViewer);
        } else if ("editor_folding_enabled".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
                if (this.fProjectionFileUpdater != null) {
                    this.fProjectionFileUpdater.uninstall();
                }
                this.fProjectionFileUpdater = new ProjectionFileUpdater();
                if (this.fProjectionFileUpdater != null) {
                    this.fProjectionFileUpdater.install(this, projectionViewer);
                }
            }
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.remove((Object)listener);
        }
    }

    public void reconciled() {
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IReconcilingParticipant)listeners[i]).reconciled();
            ++i;
        }
    }

    boolean isFoldingEnabled() {
        return AutotoolsPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{String.valueOf(AutotoolsUIPlugin.getUniqueIdentifier()) + ".editor.scope"});
    }

    protected void createActions() {
        super.createActions();
        Object resAction = new TextOperationAction(AutoconfEditorMessages.getResourceBundle(), "ShowToolTip.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(AutoconfEditorMessages.getResourceBundle(), "ShowToolTip.", (TextOperationAction)resAction);
        resAction.setActionDefinitionId(IAutotoolEditorActionDefinitionIds.SHOW_TOOLTIP);
        this.setAction("ShowToolTip", (IAction)resAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)resAction, IAutotoolHelpContextIds.SHOW_TOOLTIP_ACTION);
        ContentAssistAction action = new ContentAssistAction(AutoconfEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, IAutotoolHelpContextIds.CONTENT_ASSIST);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, true);
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        this.fInformationPresenter.setDocumentPartitioning("autoconf_macro");
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        this.fProjectionFileUpdater = new ProjectionFileUpdater();
        if (this.fProjectionFileUpdater != null) {
            this.fProjectionFileUpdater.install(this, projectionViewer);
            this.fProjectionFileUpdater.initialize();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IAutotoolHelpContextIds.AC_EDITOR_VIEW);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void dispose() {
        if (this.fProjectionFileUpdater != null) {
            this.fProjectionFileUpdater.uninstall();
            this.fProjectionFileUpdater = null;
        }
        if (this.fProject != null) {
            AutotoolsPropertyManager.getDefault().removeProjectPropertyListener(this.fProject, this);
        }
        super.dispose();
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionFileUpdater != null) {
                    this.fProjectionFileUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionFileUpdater != null) {
                    this.fProjectionFileUpdater.install(this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)AutoconfEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = AutoconfEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(sourceViewer, annotationHover)) {
                return;
            }
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            IRegion hoverRegion;
            int offset;
            block5: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            AutoconfEditor.this.fInformationPresenter.setOffset(offset);
            AutoconfEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            AutoconfEditor.this.fInformationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)"autoconf_macro", (int)offset, (boolean)true);
            AutoconfEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            AutoconfEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer sourceViewer, IAnnotationHover annotationHover) {
            IVerticalRuler info = AutoconfEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            try {
                Object hoverInfo;
                if (annotationHover instanceof IAnnotationHoverExtension) {
                    IAnnotationHoverExtension extension = (IAnnotationHoverExtension)annotationHover;
                    ILineRange hoverLineRange = extension.getHoverLineRange(sourceViewer, line);
                    if (hoverLineRange == null) {
                        return false;
                    }
                    hoverInfo = extension.getHoverInfo(sourceViewer, hoverLineRange, Integer.MAX_VALUE);
                } else {
                    hoverInfo = annotationHover.getHoverInfo(sourceViewer, line);
                }
                IDocument document = sourceViewer.getDocument();
                int offset = document.getLineOffset(line);
                String contentType = TextUtilities.getContentType((IDocument)document, (String)"autoconf_macro", (int)offset, (boolean)true);
                IInformationControlCreator controlCreator = null;
                if (annotationHover instanceof IInformationProviderExtension2) {
                    controlCreator = ((IInformationProviderExtension2)annotationHover).getInformationPresenterControlCreator();
                } else if (annotationHover instanceof IAnnotationHoverExtension) {
                    controlCreator = ((IAnnotationHoverExtension)annotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
                AutoconfEditor.this.fInformationPresenter.setOffset(offset);
                AutoconfEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                AutoconfEditor.this.fInformationPresenter.setMargins(4, 0);
                AutoconfEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
                AutoconfEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
                Point p = styledText.getLocationAtOffset(widgetOffset);
                if (p.x > x) {
                    --widgetOffset;
                }
                if (textViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetOffset + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IRegion fHoverRegion;
        private Object fHoverInfo;
        private IInformationControlCreator fControlCreator;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }
}

