/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni.factory;

import org.eclipse.linuxtools.lttng.jni.exception.JniTraceVersionException;

public class JniTraceVersion {
    private int majorNumber = 0;
    private int minorNumber = 0;
    private String tracepath = "";
    private boolean wasTraceRead = false;

    protected native void ltt_getTraceVersion(String var1);

    public JniTraceVersion() {
    }

    public JniTraceVersion(String newTracepath) throws JniTraceVersionException {
        this.readVersionFromTrace(newTracepath);
    }

    public JniTraceVersion(JniTraceVersion oldVersion) {
        this.majorNumber = oldVersion.majorNumber;
        this.minorNumber = oldVersion.minorNumber;
    }

    private void readVersionNumberNofail() {
        try {
            this.readVersionFromTrace(this.tracepath);
        }
        catch (JniTraceVersionException jniTraceVersionException) {}
    }

    public void readVersionNumber() throws JniTraceVersionException {
        this.readVersionFromTrace(this.tracepath);
    }

    public void readVersionFromTrace(String newTracepath) throws JniTraceVersionException {
        if (newTracepath == null || newTracepath.equals("")) {
            throw new JniTraceVersionException("ERROR : Tracepath is null or empty! (readVersionNumber)");
        }
        this.tracepath = newTracepath;
        try {
            System.loadLibrary("lttvtraceread_loader");
            this.ltt_getTraceVersion(this.tracepath);
            this.wasTraceRead = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new JniTraceVersionException("\nERROR : Could not get trace version. Is the library missing?\nMake sure your \"LD_LIBRARY_PATH\" is setted correctly (readVersionNumber)\n");
        }
        catch (Exception exception) {
            throw new JniTraceVersionException("\nERROR : Call to ltt_getTraceVersion failed. (readVersionNumber)\n");
        }
    }

    public int getMajor() {
        if (!this.wasTraceRead) {
            this.readVersionNumberNofail();
        }
        return this.majorNumber;
    }

    public int getMinor() {
        if (!this.wasTraceRead) {
            this.readVersionNumberNofail();
        }
        return this.minorNumber;
    }

    public float getVersionAsFloat() {
        if (!this.wasTraceRead) {
            this.readVersionNumberNofail();
        }
        return (float)this.majorNumber + (float)this.minorNumber / 10.0f;
    }

    public String getVersionAsString() {
        if (!this.wasTraceRead) {
            this.readVersionNumberNofail();
        }
        return String.valueOf(this.majorNumber) + "." + this.minorNumber;
    }

    public String getTracepath() {
        return this.tracepath;
    }

    public void setTracepath(String newtracepath) {
        this.majorNumber = 0;
        this.minorNumber = 0;
        this.wasTraceRead = false;
        this.tracepath = newtracepath;
        this.readVersionNumberNofail();
    }

    private void setTraceVersionFromC(int newMajor, int newMinor) {
        this.majorNumber = newMajor;
        this.minorNumber = newMinor;
    }

    public String toString() {
        return "JniTraceVersion [" + this.majorNumber + "." + this.minorNumber + "]";
    }
}

