/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project;

import java.io.FileNotFoundException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.state.experiment.StateManagerFactory;
import org.eclipse.linuxtools.lttng.trace.LTTngExperiment;
import org.eclipse.linuxtools.lttng.trace.LTTngTrace;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngExperimentNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectContentProvider;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectLabelProvider;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectRoot;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngTraceNode;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class ProjectView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.project";
    private TreeViewer fViewer;
    private LTTngProjectRoot fProjectRoot;
    private LTTngExperiment<LttngEvent> fSelectedExperiment = null;
    private IWorkspace fWorkspace;
    private IResourceChangeListener fResourceChangeListener;
    private Runnable fViewRefresher = new Runnable(){

        @Override
        public void run() {
            if (ProjectView.this.fViewer != null && !ProjectView.this.fViewer.getTree().isDisposed()) {
                Object[] elements = ProjectView.this.fViewer.getExpandedElements();
                ProjectView.this.fViewer.refresh();
                ProjectView.this.fViewer.setExpandedElements(elements);
            }
        }
    };
    private boolean waitForCompletion = true;

    public LTTngProjectRoot getRoot() {
        return this.fProjectRoot;
    }

    public ProjectView() {
        super("ProjectView");
        this.fProjectRoot = new LTTngProjectRoot(this);
        this.fWorkspace = ResourcesPlugin.getWorkspace();
        this.fResourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1) {
                    ProjectView.this.fProjectRoot.refreshChildren();
                    ProjectView.this.refresh();
                }
            }
        };
        this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
    }

    public void refresh() {
        Tree tree = this.fViewer.getTree();
        if (tree != null && !tree.isDisposed()) {
            tree.getDisplay().asyncExec(this.fViewRefresher);
        }
    }

    public void setSelection(ILTTngProjectTreeNode node) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
    }

    public void dispose() {
        this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 4);
        this.fViewer.setContentProvider((IContentProvider)new LTTngProjectContentProvider());
        this.fViewer.setSorter(new ViewerSorter());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LTTngProjectLabelProvider());
        this.fViewer.setInput((Object)this.fProjectRoot);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.hookMouse();
        this.createContextMenu();
    }

    public String toString() {
        return "[ProjectView]";
    }

    private void hookMouse() {
        this.fViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TreeSelection selection = (TreeSelection)ProjectView.this.fViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof LTTngExperimentNode) {
                    LTTngExperimentNode experiment = (LTTngExperimentNode)element;
                    ProjectView.this.selectExperiment(experiment);
                } else if (element instanceof LTTngTraceNode) {
                    LTTngTraceNode trace = (LTTngTraceNode)element;
                    ProjectView.this.selectTrace(trace);
                }
            }
        });
    }

    private void selectTrace(LTTngTraceNode traceNode) {
        if (this.fSelectedExperiment != null) {
            this.fSelectedExperiment.dispose();
        }
        try {
            ITmfTrace[] traces = new ITmfTrace[1];
            IFolder res = traceNode.getFolder();
            String location = res.getLocation().toOSString();
            LTTngTrace trace = new LTTngTrace(location, this.waitForCompletion);
            traces[0] = trace;
            this.fSelectedExperiment = new LTTngExperiment(LttngEvent.class, traceNode.getName(), traces);
            TmfExperiment.setCurrentExperiment(this.fSelectedExperiment);
            StateManagerFactory.getExperimentManager().experimentSelected_prep(this.fSelectedExperiment);
            this.broadcast((TmfSignal)new TmfExperimentSelectedSignal((Object)this, this.fSelectedExperiment));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectExperiment(LTTngExperimentNode experiment) {
        String expId = experiment.getName();
        if (this.fSelectedExperiment != null) {
            this.fSelectedExperiment.dispose();
        }
        try {
            LTTngTraceNode[] traceEntries = experiment.getTraces();
            int nbTraces = traceEntries.length;
            ITmfTrace[] traces = new ITmfTrace[nbTraces];
            int i = 0;
            while (i < nbTraces) {
                IFolder res = traceEntries[i].getFolder();
                String location = res.getLocation().toOSString();
                LTTngTrace trace = new LTTngTrace(location, this.waitForCompletion);
                traces[i] = trace;
                ++i;
            }
            this.fSelectedExperiment = new LTTngExperiment(LttngEvent.class, expId, traces);
            TmfExperiment.setCurrentExperiment(this.fSelectedExperiment);
            StateManagerFactory.getExperimentManager().experimentSelected_prep(this.fSelectedExperiment);
            this.broadcast((TmfSignal)new TmfExperimentSelectedSignal((Object)this, this.fSelectedExperiment));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }
}

