/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.request;

import java.util.Vector;
import org.eclipse.linuxtools.lttng.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.lttng.request.ILttngSyntEventRequest;
import org.eclipse.linuxtools.lttng.request.IRequestStatusListener;
import org.eclipse.linuxtools.lttng.request.RequestCompletedSignal;
import org.eclipse.linuxtools.lttng.request.RequestStartedSignal;
import org.eclipse.linuxtools.lttng.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.tmf.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;

public class LttngSyntEventRequest
extends TmfEventRequest<LttngSyntheticEvent>
implements ILttngSyntEventRequest {
    private Vector<IRequestStatusListener> listeners = new Vector();
    private Long feventCount = 0L;
    private boolean clearDataInd = false;
    private TmfTimeRange fExperimentTimeRange = null;
    private Object fsource = null;
    private final ITransEventProcessor fprocessor;
    private String fExperimentName = null;

    public LttngSyntEventRequest(TmfTimeRange range, long offset, int nbEvents, int maxBlockSize, IRequestStatusListener listener, TmfTimeRange experimentTimeRange, ITransEventProcessor processor) {
        this(range, offset, nbEvents, maxBlockSize, listener, experimentTimeRange, processor, "", ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public LttngSyntEventRequest(TmfTimeRange range, long offset, int nbEvents, int maxBlockSize, IRequestStatusListener listener, TmfTimeRange experimentTimeRange, ITransEventProcessor processor, String experimentName) {
        this(range, offset, nbEvents, maxBlockSize, listener, experimentTimeRange, processor, experimentName, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public LttngSyntEventRequest(TmfTimeRange range, long offset, int nbEvents, int maxBlockSize, IRequestStatusListener listener, TmfTimeRange experimentTimeRange, ITransEventProcessor processor, String experimentName, ITmfDataRequest.ExecutionType execType) {
        super(LttngSyntheticEvent.class, range, nbEvents, maxBlockSize, execType);
        this.fExperimentTimeRange = experimentTimeRange;
        this.fExperimentName = new String(experimentName);
        this.addListener(listener);
        this.fprocessor = processor;
    }

    public void addListener(IRequestStatusListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IRequestStatusListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void startRequestInd(TmfEventProvider<LttngSyntheticEvent> provider) {
        provider.sendRequest((ITmfDataRequest)this);
    }

    @Override
    public void notifyCompletion() {
        for (IRequestStatusListener listener : this.listeners) {
            listener.processingCompleted(new RequestCompletedSignal(this));
        }
    }

    @Override
    public void notifyStarting() {
        for (IRequestStatusListener listener : this.listeners) {
            listener.processingStarted(new RequestStartedSignal(this));
        }
    }

    @Override
    public TmfTimeRange getExperimentTimeRange() {
        return this.fExperimentTimeRange;
    }

    @Override
    public synchronized void setSynEventCount(Long numOfEvents) {
        this.feventCount = numOfEvents;
    }

    @Override
    public synchronized Long getSynEventCount() {
        return this.feventCount;
    }

    @Override
    public void setclearDataInd(boolean clearAllData) {
        this.clearDataInd = clearAllData;
    }

    @Override
    public boolean isclearDataInd() {
        return this.clearDataInd;
    }

    public void handleData(LttngSyntheticEvent event) {
        super.handleData((TmfData)event);
    }

    public void handleCompleted() {
        this.notifyCompletion();
        super.handleCompleted();
    }

    @Override
    public Object getSource() {
        return this.fsource;
    }

    @Override
    public void setSource(Object source) {
        this.fsource = source;
    }

    public ITransEventProcessor getProcessor() {
        return this.fprocessor;
    }

    @Override
    public String getExperimentName() {
        return this.fExperimentName;
    }
}

