/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.state.experiment;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.lttng.TraceDebug;
import org.eclipse.linuxtools.lttng.control.LttngCoreProviderFactory;
import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.lttng.model.LTTngTreeNode;
import org.eclipse.linuxtools.lttng.signal.ILttExperimentSelectedListener;
import org.eclipse.linuxtools.lttng.signal.StateExperimentListener;
import org.eclipse.linuxtools.lttng.state.experiment.IStateExperimentManager;
import org.eclipse.linuxtools.lttng.state.experiment.StateManagerFactory;
import org.eclipse.linuxtools.lttng.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.state.trace.IStateTraceManager;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfTrace;

public class StateExperimentManager
extends LTTngTreeNode
implements ILttExperimentSelectedListener,
IStateExperimentManager {
    private LTTngTreeNode fSelectedExperiment = null;
    private final StateExperimentListener fexperimentListener;
    private boolean fwaitForCompletion = false;
    private final Map<ITmfTrace, StateTraceHelper> ftraceToManagerMap = new HashMap<ITmfTrace, StateTraceHelper>();
    private LttngSyntheticEvent syntheticEvent = null;
    private ITmfEventRequest<LttngEvent> fStateCheckPointRequest = null;

    public StateExperimentManager(Long id, String name) {
        super(id, null, name, null);
        this.fexperimentListener = new StateExperimentListener("Experiment Manager", this);
    }

    @Override
    public void experimentSelected_prep(TmfExperiment<LttngEvent> experiment) {
        if (this.fSelectedExperiment != null) {
            this.clearExperimentNode(this.fSelectedExperiment);
            this.fSelectedExperiment = null;
        }
        LTTngTreeNode experimentNode = null;
        if (experiment != null) {
            ITmfTrace[] rtraces;
            experimentNode = (LTTngTreeNode)this.getChildByName(experiment.getName());
            if (experimentNode != null && experimentNode.getValue() != experiment) {
                this.clearExperimentNode(experimentNode);
                experimentNode = null;
            }
            if (experimentNode == null) {
                experimentNode = new LTTngTreeNode(this.getNextUniqueId(), this, experiment.getName(), (Object)experiment);
                this.addChild(experimentNode);
            }
            ITmfTrace[] iTmfTraceArray = rtraces = experiment.getTraces();
            int n = rtraces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace rtrace = iTmfTraceArray[n2];
                String traceName = rtrace.getName();
                LTTngTreeNode traceStateManagerNode = (LTTngTreeNode)experimentNode.getChildByName(traceName);
                if (traceStateManagerNode == null) {
                    traceStateManagerNode = StateManagerFactory.getManager(rtrace, experimentNode);
                    experimentNode.addChild(traceStateManagerNode);
                }
                ++n2;
            }
            LttngCoreProviderFactory.reset(experimentNode);
            this.fSelectedExperiment = experimentNode;
        }
    }

    private void clearExperimentNode(LTTngTreeNode experimentNode) {
        LTTngTreeNode[] traceNodes;
        LTTngTreeNode[] lTTngTreeNodeArray = traceNodes = experimentNode.getChildren();
        int n = traceNodes.length;
        int n2 = 0;
        while (n2 < n) {
            LTTngTreeNode traceStateManagerNode = lTTngTreeNodeArray[n2];
            IStateTraceManager traceManager = null;
            try {
                traceManager = (IStateTraceManager)((Object)traceStateManagerNode);
                traceManager.clearCheckPoints();
                experimentNode.removeChild(traceStateManagerNode);
            }
            catch (ClassCastException classCastException) {}
            this.removeChild(experimentNode);
            ++n2;
        }
    }

    @Override
    public void experimentSelected(Object source, TmfExperiment<LttngEvent> experiment) {
        if (experiment == null) {
            TraceDebug.debug("Received expriment is null");
            return;
        }
        if (this.fStateCheckPointRequest != null && !this.fStateCheckPointRequest.isCompleted()) {
            this.fStateCheckPointRequest.cancel();
        }
        this.fStateCheckPointRequest = this.buildCheckPoints(experiment);
    }

    @Override
    public void experimentUpdated(TmfExperimentUpdatedSignal signal, boolean wait) {
    }

    @Override
    public LTTngTreeNode getSelectedExperiment() {
        return this.fSelectedExperiment;
    }

    @Override
    public TmfTimeRange getExperimentTimeRange() {
        TmfTimeRange timeRangeResult = null;
        if (this.fSelectedExperiment != null) {
            timeRangeResult = ((TmfExperiment)this.fSelectedExperiment.getValue()).getTimeRange();
        }
        return timeRangeResult;
    }

    protected void finalize() {
        this.fexperimentListener.dispose();
    }

    @Override
    public void waitForCompletion(boolean wait) {
        this.fwaitForCompletion = wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITmfEventRequest<LttngEvent> buildCheckPoints(TmfExperiment<LttngEvent> experiment) {
        if (experiment == null) {
            TraceDebug.debug("Received expriment is null");
            return null;
        }
        LTTngTreeNode experimentNode = (LTTngTreeNode)this.getChildByName(experiment.getName());
        if (experimentNode == null) {
            TraceDebug.debug("Expriment Node " + experiment.getName() + " does not exist");
            return null;
        }
        LTTngTreeNode[] traceNodes = experimentNode.getChildren();
        StateExperimentManager stateExperimentManager = this;
        synchronized (stateExperimentManager) {
            this.ftraceToManagerMap.clear();
        }
        LTTngTreeNode[] lTTngTreeNodeArray = traceNodes;
        int n = traceNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IStateTraceManager traceManager;
            LTTngTreeNode traceStateManagerNode = lTTngTreeNodeArray[n2];
            try {
                traceManager = (IStateTraceManager)((Object)traceStateManagerNode);
            }
            catch (ClassCastException e) {
                System.out.println(e.getStackTrace().toString());
                return null;
            }
            traceManager.clearCheckPoints();
            ITmfTrace trace = traceManager.getTrace();
            StateExperimentManager stateExperimentManager2 = this;
            synchronized (stateExperimentManager2) {
                this.ftraceToManagerMap.put(trace, new StateTraceHelper(traceManager));
            }
            ++n2;
        }
        if (this.ftraceToManagerMap.size() < 1) {
            TraceDebug.debug("No traces associated to experiment " + experiment.getName());
            return null;
        }
        TmfEventRequest<LttngEvent> request = new TmfEventRequest<LttngEvent>(LttngEvent.class, TmfTimeRange.Eternity, Integer.MAX_VALUE, 50000, ITmfDataRequest.ExecutionType.BACKGROUND){
            long nbEventsHandled;
            {
                this.nbEventsHandled = 0L;
            }

            public void handleData(LttngEvent event) {
                super.handleData((TmfData)event);
                if (event != null) {
                    ++this.nbEventsHandled;
                    TmfTrace<LttngEvent> trace = event.getParentTrace();
                    StateTraceHelper helper = (StateTraceHelper)StateExperimentManager.this.ftraceToManagerMap.get(trace);
                    if (helper != null) {
                        helper.incrementNumberRead();
                        LttngSyntheticEvent synEvent = StateExperimentManager.this.updateSynEvent(event, helper.getTraceModel());
                        helper.getStateManager().handleEvent(synEvent, helper.getNumberRead());
                    } else {
                        TraceDebug.debug("StateTraceManager not found for trace" + trace.getName());
                    }
                }
            }

            public void handleFailure() {
                this.printCompletedMessage();
                super.handleFailure();
            }

            public void handleCancel() {
                this.printCompletedMessage();
                super.handleCancel();
            }

            public void handleSuccess() {
                this.printCompletedMessage();
                super.handleSuccess();
            }

            private void printCompletedMessage() {
                if (TraceDebug.isDEBUG()) {
                    TraceDebug.debug("Trace check point building completed, number of events handled: " + this.nbEventsHandled + "\n\t\t");
                    for (StateTraceHelper helper : StateExperimentManager.this.ftraceToManagerMap.values()) {
                        TraceDebug.debug(String.valueOf(helper.getStateManager().toString()) + "\n\t\t");
                    }
                }
            }
        };
        experiment.sendRequest((ITmfDataRequest)request);
        if (this.fwaitForCompletion) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return request;
    }

    private LttngSyntheticEvent updateSynEvent(LttngEvent e, LttngTraceState stateModel) {
        if (this.syntheticEvent == null || this.syntheticEvent.getBaseEvent() != e) {
            this.syntheticEvent = new LttngSyntheticEvent(e);
        }
        this.syntheticEvent.setTraceModel(stateModel);
        this.syntheticEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.UPDATE);
        return this.syntheticEvent;
    }

    private class StateTraceHelper {
        IStateTraceManager stateTraceManager = null;
        long numberEventsRead = 0L;
        LttngTraceState stateTraceModel = null;

        public StateTraceHelper(IStateTraceManager stateManager) {
            this.stateTraceManager = stateManager;
            this.stateTraceManager.restoreCheckPointByTimestamp(stateManager.getTrace().getStartTime());
            this.stateTraceModel = this.stateTraceManager.getStateModel();
        }

        public IStateTraceManager getStateManager() {
            return this.stateTraceManager;
        }

        public long getNumberRead() {
            return this.numberEventsRead;
        }

        public void incrementNumberRead() {
            ++this.numberEventsRead;
        }

        public LttngTraceState getTraceModel() {
            return this.stateTraceModel;
        }
    }
}

